/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.model;

import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.impl.SessionImpl;
import org.hibernate.proxy.HibernateProxy;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.hibernate.generic.BuggyHibernateBaseContext;
import to.etc.domui.util.db.QBasicModelCopier;
import to.etc.domui.util.db.QPersistentObjectState;
import to.etc.webapp.query.QDataContext;

public class HibernateModelCopier
extends QBasicModelCopier {
    public <T> boolean isUnloadedChildList(T source, PropertyMetaModel<?> pmm) throws Exception {
        Object value = pmm.getValue(source);
        if (value == null) {
            return false;
        }
        return !Hibernate.isInitialized((Object)value);
    }

    public <T> boolean isUnloadedParent(T source, PropertyMetaModel<?> pmm) throws Exception {
        Object value = pmm.getValue(source);
        if (value == null) {
            return false;
        }
        return !Hibernate.isInitialized((Object)value);
    }

    protected boolean isPersistedEntry(QDataContext dc, Object instance) throws Exception {
        if (!(dc instanceof BuggyHibernateBaseContext)) {
            throw new IllegalArgumentException("The QDataContext type is not a Hibernate context");
        }
        Session ses = ((BuggyHibernateBaseContext)dc).getSession();
        PersistenceContext pc = ((SessionImpl)ses).getPersistenceContext();
        return pc.getEntry(instance) != null;
    }

    protected void save(QBasicModelCopier.CopyInfo ci, Object instance) throws Exception {
        Object pk = MetaManager.getPrimaryKey((Object)instance);
        if (pk == null) {
            super.save(ci, instance);
            return;
        }
        SessionImpl ses = (SessionImpl)((BuggyHibernateBaseContext)ci.getTargetDC()).getSession();
        ses.save(instance, (Serializable)pk);
    }

    protected QPersistentObjectState getObjectState(QDataContext dc, Object instance) throws Exception {
        if (!(dc instanceof BuggyHibernateBaseContext)) {
            throw new IllegalArgumentException("The QDataContext type is not a Hibernate context");
        }
        SessionImpl ses = (SessionImpl)((BuggyHibernateBaseContext)dc).getSession();
        PersistenceContext pc = ses.getPersistenceContext();
        EntityEntry ee = pc.getEntry(instance);
        if (ee == null && instance instanceof HibernateProxy) {
            HibernateProxy hp = (HibernateProxy)instance;
            Object ainstance = hp.getHibernateLazyInitializer().getImplementation();
            ee = pc.getEntry(ainstance);
            String clz = instance.getClass().getName();
            if (clz.contains("Relation")) {
                System.out.println("DEBUG 2nd try for " + MetaManager.identify((Object)instance));
            }
            if (ee == null) {
                System.out.println("    state for " + MetaManager.identify((Object)instance) + ": null in session");
                return QPersistentObjectState.UNKNOWN;
            }
        }
        if (null == ee) {
            throw new IllegalStateException("current EntityEntry is null- that cannot happen?");
        }
        System.out.println("    state for " + MetaManager.identify((Object)instance) + ": exists=" + ee.isExistsInDatabase() + ", state=" + ee.getStatus());
        if (ee.getStatus() == Status.DELETED) {
            return QPersistentObjectState.DELETED;
        }
        if (!ee.isExistsInDatabase()) {
            return QPersistentObjectState.NEW;
        }
        Object[] snapshot = ee.getLoadedState();
        if (snapshot == null) {
            return QPersistentObjectState.NEW;
        }
        Object[] values = ee.getPersister().getPropertyValues(instance, ses.getEntityMode());
        int[] dirtyProperties = ses.getInterceptor().findDirty(instance, ee.getId(), values, snapshot, ee.getPersister().getPropertyNames(), ee.getPersister().getPropertyTypes());
        if (dirtyProperties == null) {
            dirtyProperties = ee.getPersister().findDirty(values, snapshot, instance, (SessionImplementor)ses);
        }
        return dirtyProperties == null || dirtyProperties.length == 0 ? QPersistentObjectState.PERSISTED : QPersistentObjectState.DIRTY;
    }

    protected QPersistentObjectState getObjectState(QDataContext dc, Class<?> pclass, Object pk) throws Exception {
        Object instance;
        if (pk == null) {
            return QPersistentObjectState.NEW;
        }
        try {
            instance = dc.find(pclass, pk);
        }
        catch (ObjectNotFoundException onfx) {
            return QPersistentObjectState.DELETED;
        }
        if (instance == null) {
            return QPersistentObjectState.UNKNOWN;
        }
        return this.getObjectState(dc, instance);
    }
}

