/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.testsupport;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.SessionImpl;
import org.hibernate.jdbc.util.BasicFormatterImpl;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import to.etc.domui.hibernate.generic.BuggyHibernateBaseContext;
import to.etc.domui.hibernate.model.GenericHibernateHandler;
import to.etc.lexer.ReaderTokenizerBase;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QSelection;

@Immutable
public final class TUtilHibutil {
    private static final Set<String> JOINKWS = new HashSet<String>(Arrays.asList("inner", "outer", "left", "right", "join", "as"));

    private TUtilHibutil() {
    }

    @Nonnull
    public static Session getSession(@Nonnull QDataContext dc) throws Exception {
        BuggyHibernateBaseContext hdc = (BuggyHibernateBaseContext)dc;
        return hdc.getSession();
    }

    @Nonnull
    public static String getCriteriaSQL(@Nonnull Criteria crit) throws Exception {
        CriteriaImpl c = (CriteriaImpl)crit;
        SessionImpl s = (SessionImpl)c.getSession();
        SessionFactoryImplementor factory = (SessionFactoryImplementor)s.getSessionFactory();
        String[] implementors = factory.getImplementors(c.getEntityOrClassName());
        CriteriaLoader loader = new CriteriaLoader((OuterJoinLoadable)factory.getEntityPersister(implementors[0]), factory, c, implementors[0], s.getLoadQueryInfluencers());
        Field f = OuterJoinLoader.class.getDeclaredField("sql");
        f.setAccessible(true);
        String sql = (String)f.get(loader);
        if (null == sql) {
            throw new IllegalStateException("Could not obtain Hibernate's SQL");
        }
        return sql;
    }

    @Nonnull
    public static <T> String getCriteriaSQL(@Nonnull QDataContext dc, @Nonnull QCriteria<T> query) throws Exception {
        Session ses = TUtilHibutil.getSession(dc);
        Criteria crit = GenericHibernateHandler.createCriteria(ses, query);
        return TUtilHibutil.getCriteriaSQL(crit);
    }

    @Nonnull
    public static <T> String getCriteriaSQL(@Nonnull QDataContext dc, @Nonnull QSelection<T> query) throws Exception {
        Session ses = TUtilHibutil.getSession(dc);
        Criteria crit = GenericHibernateHandler.createCriteria(ses, query);
        return TUtilHibutil.getCriteriaSQL(crit);
    }

    @Nonnull
    public static String formatSQL(@Nonnull String sql) {
        return new BasicFormatterImpl().format(sql);
    }

    @Nonnull
    public static final String getFromClause(@Nonnull String sql) throws Exception {
        ReaderTokenizerBase rsb = new ReaderTokenizerBase((Object)sql, (Reader)new StringReader(sql));
        rsb.setKeepQuotes(true);
        rsb.setReturnWhitespace(true);
        StringBuilder upto = new StringBuilder();
        rsb.nextToken();
        TUtilHibutil.scanTillToken(upto, rsb, "from");
        upto.setLength(0);
        rsb.nextToken();
        TUtilHibutil.scanTillToken(upto, rsb, "where", "having", "order", "union", "minus", "");
        return upto.toString();
    }

    @Nonnull
    public static final Map<String, String> getTableAliasMap(@Nonnull String fromclause) throws Exception {
        ReaderTokenizerBase rsb = new ReaderTokenizerBase((Object)fromclause, (Reader)new StringReader(fromclause));
        HashMap<String, String> res = new HashMap<String, String>();
        int parencount = 0;
        int phase = 1;
        String tableName = null;
        int t;
        while ((t = rsb.nextToken()) != -1) {
            if (t == 40) {
                ++parencount;
                continue;
            }
            if (t == 41) {
                --parencount;
                continue;
            }
            if (parencount != 0) continue;
            String name = rsb.getCopied().toLowerCase();
            if ("on".equals(name)) {
                phase = 0;
                continue;
            }
            if (JOINKWS.contains(name) || ",".equals(name)) {
                phase = 1;
                continue;
            }
            if (phase == 1) {
                tableName = name;
                phase = 2;
                continue;
            }
            if (phase != 2 || tableName == null) continue;
            res.put(tableName, name);
        }
        return res;
    }

    @Nonnull
    public static final String getWhereClause(@Nonnull String sql) throws Exception {
        ReaderTokenizerBase rsb = new ReaderTokenizerBase((Object)sql, (Reader)new StringReader(sql));
        rsb.setKeepQuotes(true);
        rsb.setReturnWhitespace(true);
        StringBuilder upto = new StringBuilder();
        rsb.nextToken();
        TUtilHibutil.scanTillToken(upto, rsb, "where");
        upto.setLength(0);
        rsb.nextToken();
        TUtilHibutil.scanTillToken(upto, rsb, "having", "order", "union", "minus", "");
        return upto.toString();
    }

    @Nonnull
    public static final String getSubSelect(@Nonnull String sql) throws Exception {
        ReaderTokenizerBase rsb = new ReaderTokenizerBase((Object)sql, (Reader)new StringReader(sql));
        rsb.setKeepQuotes(true);
        rsb.setReturnWhitespace(true);
        StringBuilder sb = new StringBuilder();
        int parencount = 0;
        boolean collecting = false;
        while (true) {
            int t;
            if ((t = rsb.nextToken()) == -1) {
                throw new IllegalStateException("Subselect not found");
            }
            if (t == 40) {
                ++parencount;
            } else if (t == 41) {
                if (--parencount == 0 && collecting) {
                    return sb.toString();
                }
            } else if (parencount == 1 && !collecting && t == -5 && rsb.getCopied().toLowerCase().equals("select")) {
                collecting = true;
            }
            if (!collecting) continue;
            sb.append(rsb.getCopied());
        }
    }

    @Nonnull
    private static String scanTillToken(@Nonnull StringBuilder upto, @Nonnull ReaderTokenizerBase rsb, String ... tokens) throws Exception {
        HashSet<String> tokenset = new HashSet<String>();
        for (String token : tokens) {
            tokenset.add(token.toLowerCase());
        }
        int parencount = 0;
        while (true) {
            String val;
            int t;
            if ((t = rsb.getLastToken()) == -1) {
                if (tokenset.contains("")) {
                    return "";
                }
                throw new IllegalStateException("Token(s) not found: " + tokenset);
            }
            if (t == 40) {
                ++parencount;
            } else if (t == 41) {
                --parencount;
            } else if (t == -5 && parencount == 0 && tokenset.contains((val = rsb.getCopied()).toLowerCase())) {
                return val;
            }
            upto.append(rsb.getCopied());
            rsb.nextToken();
        }
    }
}

