/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.hibernate.HibernateException;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;

public class Enum5Type
implements EnhancedUserType,
ParameterizedType {
    private Class<? extends Enum<?>> m_enumClass;
    private boolean m_ordinal;
    private static final int[] T_ORD = new int[]{2};
    private static final int[] T_NAME = new int[]{12};

    public void setParameterValues(@Nonnull Properties parameters) {
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.m_enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Enum class not found", (Throwable)cnfe);
        }
        String ord = parameters.getProperty("enumerated");
        if (ord != null && (ord.startsWith("o") || ord.startsWith("O"))) {
            this.m_ordinal = true;
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Enum)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        if (this.m_ordinal) {
            int ord = rs.getInt(names[0]);
            if (rs.wasNull()) {
                return null;
            }
            return this.m_enumClass.getEnumConstants()[ord];
        }
        String name = rs.getString(names[0]);
        return rs.wasNull() ? null : Enum.valueOf(this.m_enumClass, name);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            int i = this.m_enumClass.getEnumConstants().length;
            while (--i >= 0) {
                if (this.m_enumClass.getEnumConstants()[i] != value) continue;
                st.setString(index, ((Enum)value).name());
                return;
            }
            throw new IllegalStateException("Cannot convert enum value " + value + " to a valid label for enum=" + this.m_enumClass);
        }
        st.setNull(index, 12);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<? extends Enum<?>> returnedClass() {
        return this.m_enumClass;
    }

    public int[] sqlTypes() {
        return this.m_ordinal ? T_ORD : T_NAME;
    }

    public Object fromXMLString(String xmlValue) {
        return Enum.valueOf(this.m_enumClass, xmlValue);
    }

    public String objectToSQLString(Object value) {
        return '\'' + ((Enum)value).name() + '\'';
    }

    public String toXMLString(Object value) {
        return ((Enum)value).name();
    }
}

