/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import to.etc.domui.hibernate.types.IDatabaseCodeEnum;

public class MappedEnumType
implements UserType,
ParameterizedType {
    private static final int[] SQLTYPES = new int[]{12};
    private Class<?> m_enumClass;

    public int[] sqlTypes() {
        return SQLTYPES;
    }

    public boolean isMutable() {
        return false;
    }

    public Class<?> returnedClass() {
        return Enum.class;
    }

    public void setParameterValues(Properties parameters) {
        if (parameters == null) {
            return;
        }
        String name = parameters.getProperty("propertyType");
        if (name == null) {
            throw new HibernateException("Missing 'propertyType' parameter on type object: you must call HibernateUtil.enhanceConfig() before using this type");
        }
        try {
            this.m_enumClass = this.getClass().getClassLoader().loadClass(name);
            if (!IDatabaseCodeEnum.class.isAssignableFrom(this.m_enumClass)) {
                throw new HibernateException("the class " + name + " does not implement IDatabaseCodeEnum");
            }
            if (!this.m_enumClass.isEnum()) {
                throw new HibernateException("the class " + name + " is not an enum class");
            }
        }
        catch (Exception x) {
            throw new HibernateException("The class=" + name + " cannot be loaded: " + x);
        }
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Enum[] ar;
        String value = (String)Hibernate.STRING.nullSafeGet(rs, names[0]);
        if (value == null) {
            return null;
        }
        for (Enum label : ar = (Enum[])this.getEnumClass().getEnumConstants()) {
            if (!(label instanceof IDatabaseCodeEnum)) {
                throw new IllegalStateException("*Now* the label does not implement IDatabaseCodeEnum?!!?");
            }
            String code = ((IDatabaseCodeEnum)((Object)label)).getCode();
            if (!value.equalsIgnoreCase(code)) continue;
            return label;
        }
        throw new HibernateException("The database-column value '" + value + "' cannot be mapped onto a label of " + this.m_enumClass);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            try {
                st.setString(index, ((IDatabaseCodeEnum)value).getCode());
            }
            catch (SQLException | HibernateException ex) {
                System.err.println("value: >" + value + "< can not be cased to IDatabaseCodeEnum, at index: " + index);
                System.err.println("raised at " + this.getClass() + ", " + this);
                throw ex;
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    private Class<?> getEnumClass() {
        if (this.m_enumClass == null) {
            throw new HibernateException("Missing parameters on type object: you must call HibernateUtil.enhanceConfig() before using this type");
        }
        return this.m_enumClass;
    }
}

