/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.types;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.collection.PersistentBag;
import org.hibernate.engine.SessionImplementor;
import to.etc.domui.databinding.IChangeListener;
import to.etc.domui.databinding.list2.IListChangeListener;
import to.etc.domui.databinding.observables.IObservableList;
import to.etc.domui.databinding.observables.ObservableList;
import to.etc.util.StringTool;

public class PersistentObservableList<T>
extends PersistentBag
implements IObservableList {
    private String m_from;
    @Nonnull
    private static final IListChangeListener<?>[] NONE = new IListChangeListener[0];
    @Nonnull
    private IListChangeListener<T>[] m_listeners = NONE;

    public PersistentObservableList() {
        this.m_from = "Parameterless constructor called at " + StringTool.getLocation();
    }

    public PersistentObservableList(SessionImplementor session, List<T> coll) {
        super(session);
        this.m_from = "2 param constructor called at " + StringTool.getLocation();
        if (coll instanceof IObservableList) {
            this.bag = coll;
        } else {
            this.bag = new ObservableList();
            Iterator<T> iter = coll.iterator();
            while (iter.hasNext()) {
                this.bag.add(iter.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public PersistentObservableList(SessionImplementor session) {
        super(session);
        this.m_from = "1 param constructor called at " + StringTool.getLocation();
    }

    private IObservableList instance() {
        return (IObservableList)this.bag;
    }

    public void addChangeListener(IChangeListener listener) {
        this.instance().addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.instance().removeChangeListener(listener);
    }
}

