/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.jsmodel;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.jsmodel.ClassInfo;
import to.etc.domui.jsmodel.InstanceInfo;
import to.etc.domui.jsmodel.JsModel;
import to.etc.domui.jsmodel.JsRenderBase;
import to.etc.domui.util.DomUtil;

public class JsDeltaRenderer
extends JsRenderBase {
    private final Appendable m_destination;
    private final String m_modelRoot;
    private final Set<InstanceInfo> m_refRenderedSet = new HashSet<InstanceInfo>();

    public JsDeltaRenderer(Appendable output, JsModel jsModel, String modelRoot) {
        super(new StringBuilder(), new StringBuilder(), jsModel);
        this.m_destination = output;
        this.m_modelRoot = modelRoot;
    }

    public void render() throws Exception {
        Set<InstanceInfo> currentSet = this.m_model.collectAllInstances(this.m_model.getRootObject());
        Set<InstanceInfo> oldSet = this.m_model.getReachableSet();
        HashSet<InstanceInfo> addedSet = new HashSet<InstanceInfo>(currentSet);
        addedSet.removeAll(oldSet);
        HashSet<InstanceInfo> removedSet = new HashSet<InstanceInfo>(oldSet);
        removedSet.removeAll(currentSet);
        HashSet<InstanceInfo> retainedSet = new HashSet<InstanceInfo>(currentSet);
        retainedSet.retainAll(oldSet);
        for (InstanceInfo ii : retainedSet) {
            this.renderPropertyDeltas(ii);
        }
        this.m_destination.append("function() {\n");
        this.m_destination.append((StringBuilder)this.getRefSb());
        this.m_destination.append((StringBuilder)this.getSetSb());
        this.m_destination.append("\n}();\n");
    }

    private String renderRef(InstanceInfo ii) throws Exception {
        if (this.m_refRenderedSet.add(ii)) {
            this.m_refSb.append("var v").append(ii.getId()).append("=").append(this.m_modelRoot).append(".byId('").append(ii.getId()).append("');\n");
        }
        return "v" + ii.getId();
    }

    private void renderPropertyDeltas(InstanceInfo ii) throws Exception {
        ClassInfo ci = ii.getClassInfo();
        boolean done = false;
        for (ClassInfo.Simple<?> simple : ci.getSimpleProperties().values()) {
            done = this.renderPropertyDelta(simple, ii, done);
        }
        for (PropertyMetaModel propertyMetaModel : ci.getValueProperties()) {
            if (!this.hasValueObjectChanged(ii, propertyMetaModel)) continue;
            if (!done) {
                String var = this.renderRef(ii);
                this.m_setSb.append(var).append(".updateProperties({");
            } else {
                this.m_setSb.append(",");
            }
            done = true;
            this.renderValueObject(ii, propertyMetaModel);
        }
        for (PropertyMetaModel propertyMetaModel : ci.getParentProperties()) {
            done = this.renderSimpleParent(propertyMetaModel, ii, done);
        }
        if (done) {
            this.m_setSb.append("});\n");
        }
    }

    private <T> boolean hasValueObjectChanged(InstanceInfo ii, PropertyMetaModel<T> property) throws Exception {
        Map<String, Object> valueMap = ii.getPropertyMap();
        return this.hasValueObjectChanged(ii.getInstance(), valueMap, property);
    }

    private <T> boolean hasValueObjectChanged(Object instance, Map<String, Object> valueMap, PropertyMetaModel<T> property) throws Exception {
        Map propertyValueMap = (Map)valueMap.get(property.getName());
        Object value = property.getValue(instance);
        if (null == value) {
            return propertyValueMap == null || propertyValueMap.size() != 0;
        }
        ClassInfo valueCi = this.m_model.getInfo(value.getClass());
        if (valueCi == null) {
            throw new IllegalStateException("No class info for " + value.getClass());
        }
        if (valueCi.getParentProperties().size() > 0) {
            throw new IllegalStateException("Value object " + valueCi + " has identifyable parent properties which is not supported");
        }
        if (valueCi.getChildProperties().size() > 0) {
            throw new IllegalStateException("Value object " + valueCi + " has child list values which is not supported");
        }
        for (ClassInfo.Simple<?> simple : valueCi.getSimpleProperties().values()) {
            if (!this.hasPropertyChanged(value, propertyValueMap, simple)) continue;
            return true;
        }
        for (PropertyMetaModel propertyMetaModel : valueCi.getValueProperties()) {
            if (!this.hasValueObjectChanged(value, propertyValueMap, propertyMetaModel)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean hasPropertyChanged(Object instance, Map<String, Object> valueMap, ClassInfo.Simple<T> simple) throws Exception {
        Object oldValue;
        Object value = simple.getProperty().getValue(instance);
        return !DomUtil.isEqual((Object)value, (Object)(oldValue = valueMap.get(simple.getProperty().getName())));
    }

    private <T> boolean renderSimpleParent(PropertyMetaModel<T> pm, InstanceInfo ii, boolean done) throws Exception {
        Class actualType = pm.getActualType();
        ClassInfo parentCi = this.m_model.getInfo(actualType);
        if (null == parentCi) {
            throw new IllegalStateException("Cannot get class info for " + pm);
        }
        Object value = pm.getValue(ii.getInstance());
        if (parentCi.getIdProperty() == null || !ii.updateValue(pm, value)) {
            // empty if block
        }
        return false;
    }

    private <T> boolean renderPropertyDelta(ClassInfo.Simple<T> simple, InstanceInfo ii, boolean inited) throws Exception {
        Object value = simple.getProperty().getValue(ii.getInstance());
        if (ii.updateValue(simple.getProperty(), value)) {
            return inited;
        }
        if (!inited) {
            String var = this.renderRef(ii);
            this.m_setSb.append(var).append(".updateProperties({");
        } else {
            this.m_setSb.append(",");
        }
        this.m_setSb.append(simple.getProperty().getName()).append(":");
        if (value == null) {
            this.m_setSb.append("null");
        } else {
            simple.getRenderer().render(this.m_setSb, value);
        }
        return true;
    }
}

