/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.jsmodel;

import java.util.List;
import java.util.Map;
import java.util.Set;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.jsmodel.ClassInfo;
import to.etc.domui.jsmodel.InstanceInfo;
import to.etc.domui.jsmodel.JsClass;
import to.etc.domui.jsmodel.JsModel;
import to.etc.domui.jsmodel.JsRenderBase;

public class JsInitialRenderer
extends JsRenderBase {
    public JsInitialRenderer(Appendable output, JsModel model) {
        super(output, output, model);
    }

    public void render() throws Exception {
        this.appendSet("function() {");
        Object rootObject = this.m_model.getRootObject();
        ClassInfo ci = this.m_model.getInfo(rootObject.getClass());
        if (null == ci) {
            throw new IllegalStateException("The root Javascript model object is not annotated with " + JsClass.class.getName());
        }
        Set<InstanceInfo> instances = this.m_model.collectAllInstances(rootObject);
        for (InstanceInfo ii : instances) {
            this.renderInstanceCreate(ii);
        }
        for (InstanceInfo ii : instances) {
            this.renderRelations(ii);
        }
        this.appendSet("\n}();\n");
        this.m_model.setReachableSet(instances);
    }

    private void renderRelations(InstanceInfo ii) throws Exception {
        this.renderChildRelations(ii);
        this.renderParentRelations(ii);
    }

    private void renderParentRelations(InstanceInfo ii) throws Exception {
        ClassInfo ci = ii.getClassInfo();
        for (PropertyMetaModel<?> pp : ci.getParentProperties()) {
            this.renderParentProperty(ii, pp);
        }
    }

    private void renderParentProperty(InstanceInfo ii, PropertyMetaModel<?> pp) throws Exception {
        Object value = pp.getValue(ii.getInstance());
        if (null == value) {
            return;
        }
        InstanceInfo parii = this.m_model.findInstance(value);
        if (null == parii) {
            ClassInfo ci = this.m_model.getInfo(value.getClass());
            if (ci.getIdProperty() != null) {
                throw new IllegalStateException("Cannot re-find instance " + MetaManager.identify((Object)value));
            }
            this.appendSet("v").append(ii.getId()).append("._").append(pp.getName()).append("= new ").append(ci.getSimpleName()).append("({");
            this.renderSimpleProperties(ci, value);
            this.appendSet("});\n");
            return;
        }
        this.appendSet("v").append(ii.getId()).append("._").append(pp.getName()).append("=v").append(parii.getId()).append(";\n");
    }

    private void renderChildRelations(InstanceInfo ii) throws Exception {
        ClassInfo ci = ii.getClassInfo();
        for (PropertyMetaModel<?> cp : ci.getChildProperties()) {
            this.renderChildList(ii, cp);
        }
    }

    private void renderChildList(InstanceInfo ii, PropertyMetaModel<?> cp) throws Exception {
        Object value = cp.getValue(ii.getInstance());
        if (null == value) {
            return;
        }
        if (!(value instanceof List)) {
            throw new IllegalStateException("The child model is not returning List.");
        }
        List list = (List)value;
        this.appendSet("v").append(ii.getId()).append("._").append(cp.getName()).append(" = [");
        int count = 0;
        for (Object item : list) {
            InstanceInfo chii;
            if (count % 10 == 9) {
                this.appendSet("\n");
            }
            if (count++ != 0) {
                this.appendSet(",");
            }
            if (null == (chii = this.m_model.findInstance(item))) {
                ClassInfo ci = this.m_model.getInfo(item.getClass());
                if (ci.getIdProperty() != null) {
                    throw new IllegalStateException("Cannot find list child instance " + MetaManager.identify(item));
                }
                this.appendSet("new ").append(ci.getSimpleName()).append("({");
                this.renderSimpleProperties(ci, item);
                this.appendSet("})");
                continue;
            }
            this.appendSet("v").append(chii.getId());
        }
        this.appendSet("];\n");
    }

    private void renderInstanceCreate(InstanceInfo ii) throws Exception {
        String name = ii.getClassInfo().getSimpleName();
        this.appendSet("var v").append(ii.getId()).append("=new ").append(name).append("({");
        this.renderSimpleProperties(ii);
        this.appendSet("});\n");
    }

    private void renderSimpleProperties(InstanceInfo ii) throws Exception {
        boolean comma = false;
        ClassInfo ci = ii.getClassInfo();
        for (Map.Entry<PropertyMetaModel<?>, ClassInfo.Simple<?>> entry : ci.getSimpleProperties().entrySet()) {
            if (comma) {
                this.appendSet(",");
            }
            this.renderSimpleProperty(ii, entry.getValue());
            comma = true;
        }
        for (PropertyMetaModel propertyMetaModel : ci.getValueProperties()) {
            if (comma) {
                this.appendSet(",");
            }
            this.renderValueObject(ii, propertyMetaModel);
            comma = true;
        }
    }

    private boolean renderSimpleProperties(ClassInfo ci, Object instance) throws Exception {
        boolean comma = false;
        for (Map.Entry<PropertyMetaModel<?>, ClassInfo.Simple<?>> me : ci.getSimpleProperties().entrySet()) {
            if (comma) {
                this.appendSet(",");
            }
            this.renderSimpleProperty(instance, me.getValue());
            comma = true;
        }
        return comma;
    }

    private <T> void renderSimpleProperty(Object instance, ClassInfo.Simple<T> simple) throws Exception {
        this.appendSet(simple.getProperty().getName()).append(":");
        Object value = simple.getProperty().getValue(instance);
        if (null == value) {
            this.appendSet("null");
            return;
        }
        simple.getRenderer().render(this.getSetSb(), value);
    }

    private <T> void renderSimpleProperty(InstanceInfo ii, ClassInfo.Simple<T> simple) throws Exception {
        this.appendSet(simple.getProperty().getName()).append(":");
        Object value = simple.getProperty().getValue(ii.getInstance());
        ii.updateValue(simple.getProperty(), value);
        if (null == value) {
            this.appendSet("null");
            return;
        }
        simple.getRenderer().render(this.getSetSb(), value);
    }
}

