/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.jsmodel;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.jsmodel.ClassInfo;
import to.etc.domui.jsmodel.IRenderType;
import to.etc.domui.jsmodel.InstanceInfo;
import to.etc.domui.jsmodel.JsClass;
import to.etc.domui.jsmodel.JsDeltaRenderer;
import to.etc.domui.jsmodel.JsInitialRenderer;
import to.etc.util.StringTool;

public class JsModel {
    private final Map<String, InstanceInfo> m_idMap = new HashMap<String, InstanceInfo>();
    private final Map<Object, InstanceInfo> m_instanceMap = new HashMap<Object, InstanceInfo>();
    private final String m_modelRoot;
    private final Object m_rootObject;
    private static Map<Class<?>, IRenderType<?>> m_simpleTypeRendererMap = new HashMap();
    private Map<Class<?>, ClassInfo> m_classInfoMap = new HashMap();
    @Nullable
    private Set<InstanceInfo> m_reachableSet;
    private static Class<?>[] SIMPLETYPEAR = new Class[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Boolean.class, Double.class, Float.class};
    private static final Set<Class<?>> SIMPLETYPESET = new HashSet(Arrays.asList(SIMPLETYPEAR));

    public JsModel(String modelRoot, Object rootObject) {
        this.m_modelRoot = modelRoot;
        this.m_rootObject = rootObject;
    }

    @Nullable
    public Set<InstanceInfo> getReachableSet() {
        return this.m_reachableSet;
    }

    public void setReachableSet(@Nullable Set<InstanceInfo> reachableSet) {
        this.m_reachableSet = reachableSet;
    }

    public void renderFull(Appendable output) throws Exception {
        JsInitialRenderer r = new JsInitialRenderer(output, this);
        r.render();
    }

    public void renderDelta(Appendable output) throws Exception {
        JsDeltaRenderer r = new JsDeltaRenderer(output, this, "vroot");
        r.render();
    }

    Set<InstanceInfo> collectAllInstances(Object root) throws Exception {
        HashMap<Object, InstanceInfo> newMap = new HashMap<Object, InstanceInfo>();
        this.collectAllInstances(newMap, root);
        return new HashSet<InstanceInfo>(newMap.values());
    }

    private void collectAllInstances(Map<Object, InstanceInfo> list, Object instance) throws Exception {
        Object val;
        if (list.containsKey(instance)) {
            return;
        }
        InstanceInfo ii = this.m_instanceMap.get(instance);
        if (ii == null) {
            ClassInfo ci = this.getInfo(instance.getClass());
            if (null == ci) {
                throw new IllegalStateException("Cannot get class info for " + instance);
            }
            if (ci.getIdProperty() == null) {
                return;
            }
            ii = this.createInstanceInfo(ci, instance);
        }
        list.put(instance, ii);
        for (PropertyMetaModel<?> pp : ii.getClassInfo().getParentProperties()) {
            val = pp.getValue(instance);
            if (null == val) continue;
            this.collectAllInstances(list, val);
        }
        for (PropertyMetaModel<?> cp : ii.getClassInfo().getChildProperties()) {
            val = cp.getValue(instance);
            if (val == null) continue;
            if (!(val instanceof List)) {
                throw new IllegalStateException("Instance " + MetaManager.identify((Object)instance) + " property " + cp.getName() + " does not return List");
            }
            List chlist = (List)val;
            for (Object li : chlist) {
                this.collectAllInstances(list, li);
            }
        }
    }

    private InstanceInfo createInstanceInfo(Object instance) throws Exception {
        ClassInfo ci = this.getInfo(instance.getClass());
        if (null == ci) {
            throw new IllegalStateException("Cannot get class info for " + instance);
        }
        return this.createInstanceInfo(ci, instance);
    }

    private InstanceInfo createInstanceInfo(ClassInfo ci, Object instance) throws Exception {
        if (null == ci) {
            throw new IllegalStateException("Null classinfo?");
        }
        PropertyMetaModel<String> idProperty = ci.getIdProperty();
        if (null == idProperty) {
            throw new IllegalStateException("Attempt to create instance ref for idless instance " + MetaManager.identify((Object)instance));
        }
        String id = (String)idProperty.getValue(instance);
        if (null == id) {
            throw new IllegalStateException("The instance " + MetaManager.identify((Object)instance) + " has a null id property");
        }
        InstanceInfo ii = new InstanceInfo(ci, instance, id);
        this.m_idMap.put(id, ii);
        this.m_instanceMap.put(instance, ii);
        return ii;
    }

    InstanceInfo findInstance(Object instance) {
        InstanceInfo ii = this.m_instanceMap.get(instance);
        return ii;
    }

    private static <T> void registerRender(IRenderType<T> renderer, Class<?> ... clz) {
        for (Class<?> c : clz) {
            m_simpleTypeRendererMap.put(c, renderer);
        }
    }

    public static <T> IRenderType<T> findRenderer(PropertyMetaModel<T> property) {
        IRenderType<?> rt = m_simpleTypeRendererMap.get(property.getActualType());
        return rt;
    }

    @Nullable
    ClassInfo getInfo(Class<?> clzin) {
        ClassInfo ci = this.m_classInfoMap.get(clzin);
        if (null != ci) {
            return ci;
        }
        if (this.m_classInfoMap.containsKey(clzin)) {
            return null;
        }
        JsClass jcl = clzin.getAnnotation(JsClass.class);
        if (null == jcl) {
            this.m_classInfoMap.put(clzin, null);
            return null;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(clzin);
        PropertyMetaModel idProp = cmm.findProperty("id");
        ci = new ClassInfo(clzin.getSimpleName(), (PropertyMetaModel<String>)idProp);
        this.m_classInfoMap.put(clzin, ci);
        HashMap simpleProps = new HashMap();
        ArrayList childProps = new ArrayList();
        ArrayList parentProps = new ArrayList();
        ArrayList valueProps = new ArrayList();
        for (PropertyMetaModel property : cmm.getProperties()) {
            ClassInfo dadci;
            ClassInfo.Simple simple = this.createSimple(property);
            if (null != simple) {
                simpleProps.put(property, simple);
                continue;
            }
            if (List.class.isAssignableFrom(property.getActualType())) {
                Class collectionType = MetaManager.findCollectionType((Type)property.getGenericActualType());
                if (null == collectionType || null == (jcl = collectionType.getAnnotation(JsClass.class))) continue;
                childProps.add(property);
                continue;
            }
            jcl = property.getActualType().getAnnotation(JsClass.class);
            if (null == jcl || (dadci = this.getInfo(property.getActualType())) == null) continue;
            if (dadci.getIdProperty() == null) {
                valueProps.add(property);
                continue;
            }
            parentProps.add(property);
        }
        ci.update(simpleProps, parentProps, childProps, valueProps);
        return ci;
    }

    @Nullable
    private <T> ClassInfo.Simple<T> createSimple(PropertyMetaModel<T> pmm) {
        IRenderType<T> renderer = JsModel.findRenderer(pmm);
        if (null != renderer) {
            return new ClassInfo.Simple<T>(pmm, renderer);
        }
        return null;
    }

    public Object getRootObject() {
        return this.m_rootObject;
    }

    static {
        JsModel.registerRender(new IRenderType<Object>(){

            @Override
            public void render(Appendable a, Object value) throws Exception {
                a.append(String.valueOf(value));
            }
        }, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Character.class, Character.TYPE, Boolean.class, Boolean.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE);
        JsModel.registerRender(new IRenderType<String>(){

            @Override
            public void render(Appendable a, String value) throws Exception {
                StringTool.strToJavascriptString((Appendable)a, (String)value, (boolean)true);
            }
        }, String.class);
    }
}

