/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.jsmodel;

import java.util.HashMap;
import java.util.Map;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.jsmodel.ClassInfo;
import to.etc.domui.jsmodel.InstanceInfo;
import to.etc.domui.jsmodel.JsModel;

class JsRenderBase {
    protected final Appendable m_refSb;
    protected final Appendable m_setSb;
    protected final JsModel m_model;

    public JsRenderBase(Appendable refSb, Appendable setSb, JsModel model) {
        this.m_refSb = refSb;
        this.m_setSb = setSb;
        this.m_model = model;
    }

    protected void renderValueObject(InstanceInfo ii, PropertyMetaModel<?> property) throws Exception {
        Map<String, Object> valueMap = ii.getPropertyMap();
        this.renderValueObject(ii.getInstance(), valueMap, property);
    }

    private <T> void renderValueObject(Object instance, Map<String, Object> valueMap, PropertyMetaModel<T> property) throws Exception {
        ClassInfo valueCi;
        this.m_setSb.append(property.getName()).append(":");
        Object value = property.getValue(instance);
        if (null == value) {
            this.m_setSb.append("null");
            return;
        }
        HashMap<String, Object> propertyValueMap = (HashMap<String, Object>)valueMap.get(property.getName());
        if (null == propertyValueMap) {
            propertyValueMap = new HashMap<String, Object>();
            valueMap.put(property.getName(), propertyValueMap);
        }
        if (null == (valueCi = this.m_model.getInfo(value.getClass()))) {
            throw new IllegalStateException("No clss info for " + value.getClass());
        }
        if (valueCi.getParentProperties().size() > 0) {
            throw new IllegalStateException("Value object " + valueCi + " has identifyable parent properties which is not supported");
        }
        if (valueCi.getChildProperties().size() > 0) {
            throw new IllegalStateException("Value object " + valueCi + " has child list values which is not supported");
        }
        this.m_setSb.append("new ").append(value.getClass().getSimpleName()).append("({");
        boolean done = false;
        for (ClassInfo.Simple<?> simple : valueCi.getSimpleProperties().values()) {
            if (done) {
                this.m_setSb.append(",");
            }
            done = true;
            this.renderSimple(value, simple, propertyValueMap);
        }
        for (PropertyMetaModel propertyMetaModel : valueCi.getValueProperties()) {
            if (!done) {
                this.m_setSb.append(',');
            }
            done = true;
            this.renderValueObject(value, propertyValueMap, propertyMetaModel);
        }
        this.m_setSb.append("})\n");
    }

    protected <I, V> void renderSimple(I instance, ClassInfo.Simple<V> simple, Map<String, Object> valueMap) throws Exception {
        Object value = simple.getProperty().getValue(instance);
        valueMap.put(simple.getProperty().getName(), value);
        this.m_setSb.append(simple.getProperty().getName()).append(":");
        if (null == value) {
            this.m_setSb.append("null");
            return;
        }
        simple.getRenderer().render(this.m_setSb, value);
    }

    protected Appendable appendRef(String what) throws Exception {
        this.m_refSb.append(what);
        return this.m_refSb;
    }

    protected Appendable appendSet(String what) throws Exception {
        this.m_setSb.append(what);
        return this.m_setSb;
    }

    public Appendable getRefSb() {
        return this.m_refSb;
    }

    public Appendable getSetSb() {
        return this.m_setSb;
    }
}

