/*
 * DomUI Java User Interface library
 * Copyright (c) 2010 by Frits Jalvingh, Itris B.V.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * See the "sponsors" file for a list of supporters.
 *
 * The latest version of DomUI and related code, support and documentation
 * can be found at http://www.domui.org/
 * The contact for the project is Frits Jalvingh <jal@etc.to>.
 */
package to.etc.domui.dom.header;

import javax.annotation.*;

import to.etc.domui.dom.*;
import to.etc.domui.dom.html.*;

final class CssContributor extends HeaderContributor {
	private String m_path;

	CssContributor(@Nonnull String path) {
		if(path == null || path.length() == 0)
			throw new IllegalArgumentException("Null path not allowed");
		m_path = path;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + m_path.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if(this == obj)
			return true;
		if(obj == null)
			return false;
		if(getClass() != obj.getClass())
			return false;
		CssContributor other = (CssContributor) obj;
		if(m_path == null) {
			if(other.m_path != null)
				return false;
		} else if(!m_path.equals(other.m_path))
			return false;
		return true;
	}

	@Override
	public void contribute(HtmlFullRenderer r) throws Exception {
		r.renderLoadCSS(m_path);
	}

	@Override
	public void contribute(OptimalDeltaRenderer r) throws Exception {
		r.renderLoadCSS(m_path);
	}
}
