/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import to.etc.domui.component.lookup.filter.BigIntegerTranslator;
import to.etc.domui.component.lookup.filter.BooleanTranslator;
import to.etc.domui.component.lookup.filter.DateFromTo;
import to.etc.domui.component.lookup.filter.DateFromToTranslator;
import to.etc.domui.component.lookup.filter.EnumTranslator;
import to.etc.domui.component.lookup.filter.IntegerTranslator;
import to.etc.domui.component.lookup.filter.LookupFilterTranslator;
import to.etc.domui.component.lookup.filter.SetTranslator;
import to.etc.domui.component.lookup.filter.StringTranslator;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.util.DateUtil;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.testsupport.TestDataContextStub;
import to.etc.xml.XmlWriter;

public class LookupFilterTranslatorTest {
    private static QDataContext m_dc;

    @BeforeClass
    public static void prepareTest() {
        m_dc = new TestDataContextStub();
    }

    @Test
    public void testSerializeString() throws Exception {
        HashMap<String, String> filterValues = new HashMap<String, String>();
        String title = "Ticket 1234";
        filterValues.put("title", title);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        String serializedFilter = this.getXMLString(StringTranslator.class.getCanonicalName(), "title", title);
        Assert.assertEquals((Object)serializedFilter, (Object)serialize);
    }

    @Test
    public void testDeserializeString() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter><item><value>Ticket 1234</value><metaData key=\"title\" type=\"" + StringTranslator.class.getCanonicalName() + "\"></metaData></item></Filter>"));
        Assert.assertEquals((long)1L, (long)keyValues.size());
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"title", entry.getKey());
            Assert.assertEquals((Object)"Ticket 1234", entry.getValue());
        }
    }

    @Test
    public void testSerializeBoolean() throws Exception {
        HashMap<String, Boolean> filterValues = new HashMap<String, Boolean>();
        Boolean priority = Boolean.TRUE;
        filterValues.put("priority", priority);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        String serializedFilter = this.getXMLString(BooleanTranslator.class.getCanonicalName(), "priority", priority.toString());
        Assert.assertEquals((Object)serializedFilter, (Object)serialize);
    }

    @Test
    public void testDeserializeBoolean() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter><item><value>true</value><metaData key=\"priority\" type=\"" + BooleanTranslator.class.getCanonicalName() + "\"></metaData></item></Filter>"));
        Assert.assertEquals((long)1L, (long)keyValues.size());
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"priority", entry.getKey());
            Assert.assertEquals((Object)Boolean.TRUE, entry.getValue());
        }
    }

    @Test
    public void testSerializeInteger() throws Exception {
        HashMap<String, Integer> filterValues = new HashMap<String, Integer>();
        Integer count = new Integer("1234");
        filterValues.put("count", count);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        String serializedFilter = this.getXMLString(IntegerTranslator.class.getCanonicalName(), "count", count.toString());
        Assert.assertEquals((Object)serializedFilter, (Object)serialize);
    }

    @Test
    public void testDeserializeInteger() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter><item><value>1234</value><metaData key=\"count\" type=\"" + IntegerTranslator.class.getCanonicalName() + "\"></metaData></item></Filter>"));
        Assert.assertTrue((keyValues.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"count", entry.getKey());
            Assert.assertEquals((Object)Integer.valueOf("1234"), entry.getValue());
        }
    }

    @Test
    public void testSerializeBigInteger() throws Exception {
        HashMap<String, BigInteger> filterValues = new HashMap<String, BigInteger>();
        BigInteger count = new BigInteger("1234");
        filterValues.put("count", count);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        String serializedFilter = this.getXMLString(BigIntegerTranslator.class.getCanonicalName(), "count", count.toString());
        Assert.assertEquals((Object)serializedFilter, (Object)serialize);
    }

    @Test
    public void testDeserializeBigInteger() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter><item><value>1234</value><metaData key=\"count\" type=\"" + BigIntegerTranslator.class.getCanonicalName() + "\" /></item></Filter>"));
        Assert.assertTrue((keyValues.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"count", entry.getKey());
            Assert.assertEquals((Object)new BigInteger("1234"), entry.getValue());
        }
    }

    @Test
    public void testSerializeDateFromTo() throws Exception {
        HashMap<String, DateFromTo> filterValues = new HashMap<String, DateFromTo>();
        DateFromTo dateFromTo = new DateFromTo(DateUtil.dateFor((int)2016, (int)2, (int)1), DateUtil.dateFor((int)2016, (int)4, (int)20));
        filterValues.put("dateBetween", dateFromTo);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        String serializedFilter = "<Filter>\n  <item>\n    <value>\n      <dateFrom>01-03-2016</dateFrom>\n      <dateTo>20-05-2016</dateTo>\n    </value>\n    <metaData key=\"dateBetween\" type=\"" + DateFromToTranslator.class.getCanonicalName() + "\" />\n  </item>\n</Filter>\n";
        Assert.assertEquals((Object)serializedFilter, (Object)serialize);
    }

    @Test
    public void testDeserializeDateFromTo() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter><item><value><dateFrom>01-03-2016</dateFrom><dateTo>20-05-2016</dateTo></value><metaData key=\"dateBetween\" type=\"" + DateFromToTranslator.class.getCanonicalName() + "\" /></item></Filter>"));
        Assert.assertTrue((keyValues.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"dateBetween", entry.getKey());
            DateFromTo dateFromToActual = (DateFromTo)entry.getValue();
            DateFromTo dateFromToExpected = new DateFromTo(DateUtil.dateFor((int)2016, (int)2, (int)1), DateUtil.dateFor((int)2016, (int)4, (int)20));
            Assert.assertEquals((Object)dateFromToExpected.getDateFrom(), (Object)dateFromToActual.getDateFrom());
            Assert.assertEquals((Object)dateFromToExpected.getDateTo(), (Object)dateFromToActual.getDateTo());
        }
    }

    @Test
    public void testSerializeSetEnum() throws Exception {
        HashMap filterValues = new HashMap();
        HashSet<PropertyRelationType> testSet = new HashSet<PropertyRelationType>();
        testSet.add(PropertyRelationType.UP);
        testSet.add(PropertyRelationType.DOWN);
        filterValues.put("testEnums", testSet);
        String serialize = LookupFilterTranslator.serialize(filterValues);
        Assert.assertTrue((boolean)serialize.contains("<value class=\"" + PropertyRelationType.class.getCanonicalName() + "\">UP</value>"));
        Assert.assertTrue((boolean)serialize.contains("<value class=\"" + PropertyRelationType.class.getCanonicalName() + "\">DOWN</value>"));
    }

    @Test
    public void testDeserializeSetEnum() throws Exception {
        Map keyValues = LookupFilterTranslator.deserialize((QDataContext)m_dc, (String)("<Filter>\n  <item>\n    <value>\n      <item>\n        <value class=\"" + PropertyRelationType.class.getCanonicalName() + "\">UP</value>\n        <metaData type=\"" + EnumTranslator.class.getCanonicalName() + "\" />\n      </item>\n      <item>\n        <value class=\"" + PropertyRelationType.class.getCanonicalName() + "\">DOWN</value>\n        <metaData type=\"" + EnumTranslator.class.getCanonicalName() + "\" />\n      </item>\n    </value>\n    <metaData key=\"testEnums\" type=\"" + SetTranslator.class.getCanonicalName() + "\" />\n  </item>\n</Filter>\n"));
        Assert.assertTrue((keyValues.size() == 1 ? 1 : 0) != 0);
        for (Map.Entry entry : keyValues.entrySet()) {
            Assert.assertEquals((Object)"testEnums", entry.getKey());
            Assert.assertTrue((boolean)(entry.getValue() instanceof Set));
            Set testEnumSet = (Set)entry.getValue();
            Assert.assertEquals((long)2L, (long)testEnumSet.size());
            Assert.assertTrue((boolean)testEnumSet.contains(PropertyRelationType.DOWN));
            Assert.assertTrue((boolean)testEnumSet.contains(PropertyRelationType.UP));
        }
    }

    @Nonnull
    private String getXMLString(String ... keyValues) throws IOException {
        StringWriter serializedFilter = new StringWriter();
        XmlWriter w = new XmlWriter((Writer)serializedFilter);
        w.tag("Filter");
        for (int i = 0; i < keyValues.length; i += 3) {
            w.tag("item");
            w.tag("value");
            w.write(keyValues[i + 2]);
            w.tagendnl();
            w.tagonly("metaData", new String[]{"key", keyValues[i + 1], "type", keyValues[i]});
        }
        w.tagendnl();
        w.close();
        return serializedFilter.toString();
    }
}

