/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.converters;

import java.util.Locale;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import to.etc.domui.converter.MinutesConverter;
import to.etc.webapp.nls.NlsContext;

public class TestMinutesConverter {
    private static final String[] BAD_VALUES = new String[]{"1..", "1..2", "1,,", "1,,2", "1.123", "1,123", "a", ".6", ",6", ".61", ",61", "2.", "2,", "1.1", "1,1"};
    private static final String[] GOOD_VALUES = new String[]{"0.02", "0.25", "1.12", "0,02", "0,25", "1,12", "2.01", "2,01", "2.09", "2,09"};
    private static final Integer[] GOOD_VALUES_RAW = new Integer[]{new Integer(2), new Integer(25), new Integer(72), new Integer(2), new Integer(25), new Integer(72), new Integer(121), new Integer(121), new Integer(129), new Integer(129)};

    @BeforeClass
    public static void setUp() {
        Locale nl = new Locale("nl", "NL");
        NlsContext.setCurrencyLocale((Locale)nl);
        NlsContext.setLocale((Locale)nl);
    }

    @Test
    public void checkGoodValues() {
        MinutesConverter mc = new MinutesConverter();
        Integer minsFromString = null;
        for (int i = 0; i < GOOD_VALUES.length; ++i) {
            String mins = GOOD_VALUES[i];
            Integer minsRaw = GOOD_VALUES_RAW[i];
            String minsFromObject = mc.convertObjectToString(NlsContext.getLocale(), minsRaw);
            try {
                minsFromString = mc.convertStringToObject(NlsContext.getLocale(), mins);
            }
            catch (Exception x) {
                Assert.fail((String)("Minutes could not be converted:" + mins));
            }
            Assert.assertEquals((Object)minsFromObject, (Object)mins.replace(".", ","));
            Assert.assertEquals((Object)minsFromString, (Object)minsRaw);
        }
    }

    @Test
    public void checkBadTimes() {
        MinutesConverter mc = new MinutesConverter();
        for (int i = 0; i < BAD_VALUES.length; ++i) {
            String mins = BAD_VALUES[i];
            try {
                mc.convertStringToObject(NlsContext.getLocale(), mins);
                Assert.fail((String)("It's a good time ??? " + mins));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

