/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.converters;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import to.etc.domui.converter.MiniScanner;
import to.etc.domui.converter.MoneyUtil;
import to.etc.domui.trouble.ValidationException;
import to.etc.webapp.nls.NlsContext;

public class TestMoneyConverter {
    @Before
    public void setUp() {
        Locale nl = new Locale("nl", "NL");
        NlsContext.setCurrencyLocale((Locale)nl);
        NlsContext.setLocale((Locale)nl);
    }

    @Test
    public void checkBigDecimalRendering() {
        BigDecimal bd = BigDecimal.valueOf(0.0);
        String s = bd.setScale(2, RoundingMode.HALF_EVEN).toString();
        Assert.assertEquals((Object)"0.00", (Object)s);
    }

    @Test
    public void checkProperRounding() {
        Assert.assertEquals((Object)((Object)RoundingMode.HALF_EVEN), (Object)((Object)MoneyUtil.getRoundingMode()));
    }

    @Test
    public void checkProperScale() {
        Assert.assertEquals((long)2L, (long)MoneyUtil.getMoneyScale());
    }

    public void check(String in, String out) {
        MiniScanner ms = MiniScanner.getInstance();
        ms.scanLaxWithCurrencySign(in, 2, false);
        String res = ms.getStringResult();
        System.out.println("  ... " + in + " -> " + res);
        Assert.assertEquals((Object)out, (Object)res);
    }

    public void bad(String in) {
        block2: {
            try {
                MiniScanner ms = MiniScanner.getInstance();
                System.out.println(" ... " + in + " (bad)");
                ms.scanLaxWithCurrencySign(in, 2, false);
            }
            catch (ValidationException vx) {
                if (!vx.getCode().equals("v.bad.amount")) break block2;
                return;
            }
        }
        Assert.fail((String)("Validated an invalid amount: '" + in + "'"));
    }

    @Test
    public void testBadConversions() {
        System.out.println("Testen van ONgeldige bedrag invoer-formaten");
        this.bad("\u20ac");
        this.bad("abc");
        this.bad("1,00,000");
        this.bad("1.00.000");
        this.bad("1.000.000.00");
        this.bad("1,000,000,00");
        this.bad("1,00.00");
        this.bad("1.00,00");
        this.bad("1..000");
        this.bad("1,,000");
        this.bad("1.,000");
        this.bad("1,.000");
        this.bad("1,000000,000.00");
        this.bad("1-100");
        this.bad("1000,-10,000.00");
    }

    @Test
    public void testMoneyConversions() throws Exception {
        System.out.println("Testen van geldige bedrag invoer-formaten");
        this.check("", "");
        this.check("\u20ac 1000", "1000");
        this.check("  \u20ac 1000.89", "1000.89");
        this.check("1000", "1000");
        this.check("1000.", "1000");
        this.check("1000.0", "1000.0");
        this.check("1000.00", "1000.00");
        this.check("1000.99", "1000.99");
        this.check("1000.89", "1000.89");
        this.check("1000.8", "1000.8");
        this.check("1000,", "1000");
        this.check("1000,0", "1000.0");
        this.check("1000,00", "1000.00");
        this.check("1000,99", "1000.99");
        this.check("1000,89", "1000.89");
        this.check("1000,8", "1000.8");
        this.check("1.000", "1000");
        this.check("1.000.000", "1000000");
        this.check("1.000.000.000", "1000000000");
        this.check("1,000", "1000");
        this.check("1,000,000", "1000000");
        this.check("1,000,000,000", "1000000000");
        this.check("1,000,000.", "1000000");
        this.check("1,000,000.9", "1000000.9");
        this.check("1,000,786.76", "1000786.76");
        this.check("1.000.000,", "1000000");
        this.check("1.000.000,9", "1000000.9");
        this.check("1.000.786,76", "1000786.76");
        this.check("1.000,00", "1000.00");
        this.check("1,000.00", "1000.00");
        this.check("-1000", "-1000");
        this.check("-1000.99", "-1000.99");
        this.check("1000-", "-1000");
        this.check("1000.99-", "-1000.99");
    }

    @Deprecated
    private void testSimple(double v, String exp) {
        String res = MoneyUtil.renderAsSimpleDotted((double)v);
        System.out.println("  ... " + v + " -> " + res);
        Assert.assertEquals((Object)exp, (Object)res);
    }

    private void testFullSign(double v, String exp) {
        String res = MoneyUtil.renderFullWithSign((double)v);
        System.out.println("  ... " + v + " -> " + res);
        Assert.assertEquals((Object)exp, (Object)res);
    }

    private void testMoney(double v, boolean thou, boolean curr, boolean trunk, String exp) {
        String res = MoneyUtil.render((BigDecimal)BigDecimal.valueOf(v), (boolean)thou, (boolean)curr, (boolean)trunk);
        System.out.println("  ... " + v + " -> " + res);
        Assert.assertEquals((Object)exp, (Object)res);
    }

    @Test
    public void testToString() {
        System.out.println("double naar string representatie: simpel");
        this.testSimple(0.0, "0.00");
        this.testSimple(1.0, "1.00");
        this.testSimple(1.0, "1.00");
        this.testSimple(1.0001, "1.00");
        this.testSimple(1.0049999, "1.00");
        this.testSimple(1.0, "1.00");
        this.testSimple(9.999999999999988E13, "99999999999999.88");
        System.out.println("double naar string representatie: full format");
        this.testFullSign(1234567.89, "\u20ac\u00a01.234.567,89");
        this.testFullSign(1234567.0, "\u20ac\u00a01.234.567,00");
        this.testFullSign(1234567.01, "\u20ac\u00a01.234.567,01");
        this.testFullSign(1234567.1, "\u20ac\u00a01.234.567,10");
        this.testFullSign(0.0, "\u20ac\u00a00,00");
        this.testFullSign(-1234567.89, "\u20ac\u00a0-1.234.567,89");
        this.testFullSign(-1234567.0, "\u20ac\u00a0-1.234.567,00");
        this.testFullSign(-1234567.01, "\u20ac\u00a0-1.234.567,01");
        this.testFullSign(-1234567.1, "\u20ac\u00a0-1.234.567,10");
    }

    @Test
    public void testOtherLocales() {
        this.testMoney(1234.45, false, true, true, "\u20ac\u00a01234,45");
        this.testMoney(1234.45111, false, true, true, "\u20ac\u00a01234,45");
        this.testMoney(1234.0, false, true, true, "\u20ac\u00a01234");
        this.testMoney(1234.0, false, true, false, "\u20ac\u00a01234,00");
        this.testMoney(1234.45, false, false, true, "1234,45");
        this.testMoney(1234.45111, false, false, true, "1234,45");
        this.testMoney(1234.0, false, false, true, "1234");
        this.testMoney(1234.0, false, false, false, "1234,00");
        Locale jp = Locale.JAPAN;
        NlsContext.setLocale((Locale)jp);
        NlsContext.setCurrencyLocale((Locale)jp);
        this.testMoney(1234.45, false, true, true, "\uffe5\u00a01234");
        this.testMoney(1234.45111, false, true, true, "\uffe5\u00a01234");
        this.testMoney(1234.0, false, true, true, "\uffe5\u00a01234");
        this.testMoney(1234.0, false, true, false, "\uffe5\u00a01234");
        this.check("\u20ac 1000", "1000");
        this.check("\uffe5 1000", "1000");
    }
}

