/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.converters;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.NumericUtil;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;

public class TestNumberConverter {
    private static final String[] BAD_NUMBER = new String[]{"\u20ac", "\u20ac 1,000.00", "abc", "1,00,000", "1.00.000", "1.000.000.00", "1,000,000,00", "1,00.00", "1.00,00", "1..000", "1,,000", "1.,000", "1,.000", "1,000000,000.00", "1-100", "1000,-10,000.00"};
    private static final String[] BAD_MONEY = new String[]{"\u20ac", "abc", "1,00,000", "1.00.000", "1.000.000.00", "1,000,000,00", "1,00.00", "1.00,00", "1..000", "1,,000", "1.,000", "1,.000", "1,000000,000.00", "1-100", "1000,-10,000.00"};

    @BeforeClass
    public static void setUp() {
        Locale nl = new Locale("nl", "NL");
        NlsContext.setCurrencyLocale((Locale)nl);
        NlsContext.setLocale((Locale)nl);
    }

    public <T extends Number> void check(IConverter<T> nc, String in, String out, NumericPresentation np, int scale, int minScale, boolean monetary) {
        if (monetary && !NumericPresentation.isMonetary((NumericPresentation)np)) {
            this.bad(nc, in, false);
        } else if (minScale > scale) {
            this.bad(nc, in, NumericPresentation.isMonetary((NumericPresentation)np));
        } else {
            this.good(nc, in, out);
        }
    }

    public <T extends Number> void checkT(IConverter<T> nc, String in, String out, NumericPresentation np, int scale, int minScale, boolean monetary) {
        if (monetary && !NumericPresentation.isMonetary((NumericPresentation)np)) {
            this.bad(nc, in, false);
        } else if (minScale != scale) {
            this.bad(nc, in, NumericPresentation.isMonetary((NumericPresentation)np));
        } else {
            this.good(nc, in, out);
        }
    }

    public <T extends Number> void good(IConverter<T> nc, String in, String out) {
        System.out.print("good\t");
        System.out.print(in + "\t");
        System.out.println(out);
        Number object = (Number)nc.convertStringToObject(NlsContext.getLocale(), in);
        String converted = nc.convertObjectToString(NlsContext.getLocale(), (Object)object);
        Assert.assertEquals((Object)out, (Object)converted);
    }

    public <T extends Number> void bad(IConverter<T> nc, String in, boolean monetary) {
        String badAsConverted = null;
        try {
            System.out.print("bad \t");
            System.out.println(in);
            Number object = (Number)nc.convertStringToObject(NlsContext.getLocale(), in);
            badAsConverted = nc.convertObjectToString(NlsContext.getLocale(), (Object)object);
        }
        catch (ValidationException vx) {
            if (vx.getCode().equals("v.bad.amount") && monetary) {
                return;
            }
            if (vx.getCode().equals("v.invalid") && !monetary) {
                return;
            }
            Assert.fail((String)("Unexpected ValidationException!? " + vx.getLocalizedMessage()));
        }
        Assert.fail((String)("Validated an invalid amount: '" + in + "', '" + badAsConverted + "'"));
    }

    public void testBadConversions(NumericPresentation np, int scale, String[] badFormats) {
        IConverter nc = NumericUtil.createNumberConverter(BigDecimal.class, (NumericPresentation)np, (int)scale);
        System.out.println("Testen van ONgeldige bedrag invoer-formaten(" + np.name() + ", scale = " + scale + "):");
        boolean monetary = NumericPresentation.isMonetary((NumericPresentation)np);
        for (String badFormat : badFormats) {
            this.bad(nc, badFormat, monetary);
        }
    }

    public <T extends Number> void testNumericPresentation(NumericPresentation np, int scale, Class<T> classType) {
        try {
            NumericUtil.createNumberConverter(BigDecimal.class, (NumericPresentation)np, (int)scale);
        }
        catch (IllegalArgumentException e) {
            if (DomUtil.isIntegerType(classType) && scale != 0) {
                return;
            }
            Assert.fail((String)"Should be possible to make instance of NumberConverter using non-monetary presentation!");
        }
    }

    @Test
    public void testBadConversions() {
        NumericPresentation[] npl1;
        for (NumericPresentation np : npl1 = new NumericPresentation[]{NumericPresentation.NUMBER, NumericPresentation.NUMBER_SCALED, NumericPresentation.NUMBER_FULL, NumericPresentation.NUMBER_SCIENTIFIC}) {
            for (int i = 0; i <= 6; ++i) {
                this.testBadConversions(np, i, BAD_NUMBER);
            }
        }
    }

    @Test
    public void testNumericPresentations() {
        for (NumericPresentation np : NumericPresentation.values()) {
            if (NumericPresentation.UNKNOWN == np) continue;
            for (int i = 0; i <= 6; ++i) {
                this.testNumericPresentation(np, i, BigDecimal.class);
                this.testNumericPresentation(np, i, Double.class);
                this.testNumericPresentation(np, i, Integer.class);
                this.testNumericPresentation(np, i, Double.TYPE);
                this.testNumericPresentation(np, i, Integer.TYPE);
            }
        }
    }

    private String add0(int count) {
        String res = "";
        for (int i = 0; i < count; ++i) {
            res = res + "0";
        }
        return res;
    }

    private String f(String in) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(NlsContext.getLocale());
        char ds = dfs.getDecimalSeparator();
        char ts = dfs.getGroupingSeparator();
        in = in.replaceAll("\\.", "D");
        in = in.replace(",", "T");
        in = in.replaceAll("D", ds + "");
        in = in.replaceAll("T", ts + "");
        return in;
    }

    public <T extends Number> void testConversions(NumericPresentation np, int scale, Class<T> classType) {
        IConverter nc;
        block15: {
            nc = null;
            try {
                nc = NumericUtil.createNumberConverter(classType, (NumericPresentation)np, (int)scale);
            }
            catch (IllegalArgumentException ex) {
                if (!DomUtil.isIntegerType(classType) || scale == 0) break block15;
                return;
            }
        }
        boolean truncateTrailingZero = NumericPresentation.isStripTrailingZeros((NumericPresentation)np);
        System.out.println("SETTINGS: classType=" + classType.getName() + ", NP=" + np.name() + ", scale=" + scale);
        if (DomUtil.isIntegerType(classType)) {
            this.bad(nc, "", false);
        } else {
            this.good(nc, "", "");
        }
        if (classType != BigDecimal.class) {
            this.check(nc, "\u20ac 1000", "\u20ac 1000", np, scale, 0, true);
            this.check(nc, "  \u20ac 1000.89", this.f("\u20ac 1000.89"), np, scale, 2, true);
        }
        this.check(nc, "1000", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1000.", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1000.0", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 1, false);
        this.check(nc, "1000.00", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 2, false);
        this.check(nc, "1000.99", truncateTrailingZero ? this.f("1000.99") : this.f("1000.99") + this.add0(scale - 2), np, scale, 2, false);
        if (scale < 3) {
            this.check(nc, "1000.896", "1000896" + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.check(nc, "1000.896", truncateTrailingZero ? this.f("1000.896") : this.f("1000.896") + this.add0(scale - 3), np, scale, 3, false);
        }
        this.check(nc, "1000.8965", truncateTrailingZero ? this.f("1000.8965") : this.f("1000.8965") + this.add0(scale - 4), np, scale, 4, false);
        this.check(nc, "1000", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1000,", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1000,0", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 1, false);
        this.check(nc, "1000,00", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 2, false);
        this.check(nc, "1000,99", truncateTrailingZero ? this.f("1000.99") : this.f("1000.99") + this.add0(scale - 2), np, scale, 2, false);
        if (scale < 3) {
            this.check(nc, "1000,896", "1000896" + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.check(nc, "1000,896", truncateTrailingZero ? this.f("1000.896") : this.f("1000.896") + this.add0(scale - 3), np, scale, 3, false);
        }
        this.check(nc, "1000,8965", truncateTrailingZero ? this.f("1000.8965") : this.f("1000.8965") + this.add0(scale - 4), np, scale, 4, false);
        if (scale < 3) {
            this.check(nc, "1.000", "1000" + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.check(nc, "1.000", truncateTrailingZero ? "1" : this.f("1.") + this.add0(scale), np, scale, 3, false);
        }
        this.check(nc, "1.000.000", truncateTrailingZero || scale == 0 ? "1000000" : this.f("1000000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1.000.000.000", truncateTrailingZero || scale == 0 ? "1000000000" : this.f("1000000000.") + this.add0(scale), np, scale, 0, false);
        if (scale < 3) {
            this.check(nc, "1,000", "1000" + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.check(nc, "1,000", truncateTrailingZero ? "1" : this.f("1.") + this.add0(scale), np, scale, 3, false);
        }
        this.check(nc, "1,000,000", truncateTrailingZero || scale == 0 ? "1000000" : this.f("1000000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1,000,000,000", truncateTrailingZero || scale == 0 ? "1000000000" : this.f("1000000000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1,000,000.", truncateTrailingZero || scale == 0 ? "1000000" : this.f("1000000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1,000,000.9", this.f("1000000.9") + (truncateTrailingZero ? "" : this.add0(scale - 1)), np, scale, 1, false);
        this.check(nc, "1,000,786.76", this.f("1000786.76") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.check(nc, "1,000,786.765", this.f("1000786.765") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        this.check(nc, "1,000,786.7654", this.f("1000786.7654") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
        this.check(nc, "1,000,786.76543", this.f("1000786.76543") + (truncateTrailingZero ? "" : this.add0(scale - 5)), np, scale, 5, false);
        this.check(nc, "1,000,786.765432", this.f("1000786.765432") + (truncateTrailingZero ? "" : this.add0(scale - 6)), np, scale, 6, false);
        this.check(nc, "1.000.000,", truncateTrailingZero || scale == 0 ? "1000000" : this.f("1000000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1.000.000,9", this.f("1000000.9") + (truncateTrailingZero ? "" : this.add0(scale - 1)), np, scale, 1, false);
        this.check(nc, "1.000.786,76", this.f("1000786.76") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.check(nc, "1.000.786,765", this.f("1000786.765") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        this.check(nc, "1.000.786,7654", this.f("1000786.7654") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
        this.check(nc, "1.000.786,76543", this.f("1000786.76543") + (truncateTrailingZero ? "" : this.add0(scale - 5)), np, scale, 5, false);
        this.check(nc, "1.000.786,765432", this.f("1000786.765432") + (truncateTrailingZero ? "" : this.add0(scale - 6)), np, scale, 6, false);
        this.check(nc, "1.000,00", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 2, false);
        this.check(nc, "1,000.00", truncateTrailingZero || scale == 0 ? "1000" : this.f("1000.") + this.add0(scale), np, scale, 2, false);
        this.check(nc, "-1000", truncateTrailingZero || scale == 0 ? "-1000" : this.f("-1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "-1000.99", this.f("-1000.99") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.check(nc, "1000-", truncateTrailingZero || scale == 0 ? "-1000" : this.f("-1000.") + this.add0(scale), np, scale, 0, false);
        this.check(nc, "1000.99-", this.f("-1000.99") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        if (scale < 3) {
            this.check(nc, "1000.997-", truncateTrailingZero || scale == 0 ? "-1000997" : this.f("-1000997.") + this.add0(scale), np, scale, 0, false);
        } else {
            this.check(nc, "1000.997-", this.f("-1000.997") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        }
        this.check(nc, "1000.9978-", this.f("-1000.9978") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
    }

    public <T extends Number> void testConversionsThousandSepUsed(NumericPresentation np, int scale, Class<T> classType) {
        IConverter nc;
        block14: {
            nc = null;
            try {
                nc = NumericUtil.createNumberConverter(classType, (NumericPresentation)np, (int)scale);
            }
            catch (IllegalArgumentException ex) {
                if (!DomUtil.isIntegerType(classType) || scale == 0) break block14;
                return;
            }
        }
        boolean truncateTrailingZero = NumericPresentation.isStripTrailingZeros((NumericPresentation)np);
        System.out.println("SETTINGS: classType=" + classType.getName() + ", NP=" + np.name() + ", scale=" + scale);
        if (DomUtil.isIntegerType(classType)) {
            this.bad(nc, "", false);
        } else {
            this.good(nc, "", "");
        }
        if (classType != BigDecimal.class) {
            this.check(nc, "\u20ac 1000", this.f("\u20ac 1,000"), np, scale, 0, true);
            this.check(nc, "  \u20ac 1000.89", this.f("\u20ac 1,000.89"), np, scale, 2, true);
        }
        if (scale != 3) {
            this.checkT(nc, "1,000", this.f("1,000") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.good(nc, "1,000", this.f("1.000"));
        }
        this.checkT(nc, "1,000.", this.f("1,000") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        this.checkT(nc, "1,000.0", this.f("1,000") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 1, false);
        this.checkT(nc, "1,000.00", this.f("1,000") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 2, false);
        this.checkT(nc, "1,000.99", truncateTrailingZero ? this.f("1,000.99") : this.f("1,000.99") + this.add0(scale - 2), np, scale, 2, false);
        if (scale < 3) {
            this.checkT(nc, "10.896", this.f("10,896") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.checkT(nc, "10.896", truncateTrailingZero ? this.f("10.896") : this.f("10.896") + this.add0(scale - 3), np, scale, 3, false);
        }
        this.checkT(nc, "1,000.8965", truncateTrailingZero ? this.f("1,000.8965") : this.f("1,000.8965") + this.add0(scale - 4), np, scale, 4, false);
        if (scale != 3) {
            this.checkT(nc, "1.000", this.f("1,000") + (truncateTrailingZero || scale == 0 ? "" : this.f(".") + this.add0(scale)), np, scale, 0, false);
        } else {
            this.good(nc, "1.000", this.f("1.000"));
        }
        this.checkT(nc, "1.000.000", truncateTrailingZero || scale == 0 ? this.f("1,000,000") : this.f("1,000,000.") + this.add0(scale), np, scale, 0, false);
        this.checkT(nc, "1.000.000.000", truncateTrailingZero || scale == 0 ? this.f("1,000,000,000") : this.f("1,000,000,000.") + this.add0(scale), np, scale, 0, false);
        this.checkT(nc, "1,000,000.", truncateTrailingZero || scale == 0 ? this.f("1,000,000") : this.f("1,000,000.") + this.add0(scale), np, scale, 0, false);
        this.checkT(nc, "1,000,000.9", this.f("1,000,000.9") + (truncateTrailingZero ? "" : this.add0(scale - 1)), np, scale, 1, false);
        this.checkT(nc, "1,000,786.76", this.f("1,000,786.76") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.checkT(nc, "1,000,786.765", this.f("1,000,786.765") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        this.checkT(nc, "1,000,786.7654", this.f("1,000,786.7654") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
        this.checkT(nc, "1,000,786.76543", this.f("1,000,786.76543") + (truncateTrailingZero ? "" : this.add0(scale - 5)), np, scale, 5, false);
        this.checkT(nc, "1,000,786.765432", this.f("1,000,786.765432") + (truncateTrailingZero ? "" : this.add0(scale - 6)), np, scale, 6, false);
        this.checkT(nc, "1.000.000,", truncateTrailingZero || scale == 0 ? this.f("1,000,000") : this.f("1,000,000.") + this.add0(scale), np, scale, 0, false);
        this.checkT(nc, "1.000.000,9", this.f("1,000,000.9") + (truncateTrailingZero ? "" : this.add0(scale - 1)), np, scale, 1, false);
        this.checkT(nc, "1.000.786,76", this.f("1,000,786.76") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.checkT(nc, "1.000.786,765", this.f("1,000,786.765") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        this.checkT(nc, "1.000.786,7654", this.f("1,000,786.7654") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
        this.checkT(nc, "1.000.786,76543", this.f("1,000,786.76543") + (truncateTrailingZero ? "" : this.add0(scale - 5)), np, scale, 5, false);
        this.checkT(nc, "1.000.786,765432", this.f("1,000,786.765432") + (truncateTrailingZero ? "" : this.add0(scale - 6)), np, scale, 6, false);
        this.checkT(nc, "1.000,00", truncateTrailingZero || scale == 0 ? this.f("1,000") : this.f("1,000.") + this.add0(scale), np, scale, 2, false);
        this.checkT(nc, "1,000.00", truncateTrailingZero || scale == 0 ? this.f("1,000") : this.f("1,000.") + this.add0(scale), np, scale, 2, false);
        if (scale != 3) {
            this.checkT(nc, "-1.000", this.f("-1,000") + (truncateTrailingZero || scale == 0 ? "" : this.add0(scale)), np, scale, 0, false);
            this.checkT(nc, "-1,000", this.f("-1,000") + (truncateTrailingZero || scale == 0 ? "" : this.add0(scale)), np, scale, 0, false);
            this.checkT(nc, "1.000-", this.f("-1,000") + (truncateTrailingZero || scale == 0 ? "" : this.add0(scale)), np, scale, 0, false);
        } else {
            this.good(nc, "-1.000", this.f("-1.000"));
            this.good(nc, "-1,000", this.f("-1.000"));
            this.good(nc, "1.000-", this.f("-1.000"));
        }
        this.checkT(nc, "-1,000.99", this.f("-1,000.99") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        this.checkT(nc, "1,000.99-", this.f("-1,000.99") + (truncateTrailingZero ? "" : this.add0(scale - 2)), np, scale, 2, false);
        if (scale >= 3) {
            this.checkT(nc, "1,000.997-", this.f("-1,000.997") + (truncateTrailingZero ? "" : this.add0(scale - 3)), np, scale, 3, false);
        }
        this.checkT(nc, "1,000.9978-", this.f("-1,000.9978") + (truncateTrailingZero ? "" : this.add0(scale - 4)), np, scale, 4, false);
    }

    @Test
    public void testGenerateConversionsSetResource() {
        NumericPresentation[] npl2;
        NumericPresentation[] npl1;
        for (NumericPresentation np : npl1 = new NumericPresentation[]{NumericPresentation.NUMBER, NumericPresentation.NUMBER_SCALED}) {
            for (int i = 0; i <= 6; ++i) {
                this.testConversions(np, i, BigDecimal.class);
                this.testConversions(np, i, Double.class);
                this.testConversions(np, i, Integer.class);
                this.testConversions(np, i, Double.TYPE);
                this.testConversions(np, i, Integer.TYPE);
            }
        }
        for (NumericPresentation np : npl2 = new NumericPresentation[]{NumericPresentation.NUMBER_FULL}) {
            for (int i = 0; i <= 6; ++i) {
                this.testConversionsThousandSepUsed(np, i, BigDecimal.class);
                this.testConversionsThousandSepUsed(np, i, Double.class);
                this.testConversionsThousandSepUsed(np, i, Integer.class);
                this.testConversionsThousandSepUsed(np, i, Double.TYPE);
                this.testConversionsThousandSepUsed(np, i, Integer.TYPE);
            }
        }
    }

    @Test
    public void testConversionsFromResourceFiles() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("test_number_cont_data1.resource");
        if (null == is) {
            throw new IllegalStateException("Missing resource");
        }
        try {
            this.testResourceFile(is);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResourceFile(InputStream fi) throws IOException {
        String linebuf = null;
        try (BufferedReader br = null;){
            DataInputStream in = new DataInputStream(fi);
            br = new BufferedReader(new InputStreamReader(in));
            NumericPresentation np = NumericPresentation.NUMBER;
            int scale = 0;
            Class<Number> classType = Double.TYPE;
            IConverter nc = null;
            while ((linebuf = br.readLine()) != null) {
                if (linebuf.startsWith("SETTINGS:")) {
                    String[] parts;
                    linebuf = linebuf.substring(9);
                    for (String part : parts = linebuf.split(",")) {
                        String[] vals = part.split("=");
                        if (vals == null || vals.length != 2) {
                            throw new IOException("invalid SETTINGS part, must be key=value, but found: " + part);
                        }
                        if ("NP".equals(vals[0].trim())) {
                            np = NumericPresentation.valueOf((String)vals[1].trim());
                            continue;
                        }
                        if ("scale".equals(vals[0].trim())) {
                            scale = Integer.parseInt(vals[1].trim());
                            continue;
                        }
                        if (!"classType".equals(vals[0].trim())) continue;
                        try {
                            classType = Class.forName(vals[1].trim());
                        }
                        catch (ClassNotFoundException e) {
                            if ("double".equals(vals[1].trim())) {
                                classType = Double.TYPE;
                                continue;
                            }
                            if ("int".equals(vals[1].trim())) {
                                classType = Integer.TYPE;
                                continue;
                            }
                            throw new IOException("unexpected classType value found: " + part);
                        }
                    }
                    nc = NumericUtil.createNumberConverter(classType, (NumericPresentation)np, (int)scale);
                    continue;
                }
                if (nc == null) {
                    throw new IOException("SETTINGS are not initialized properly!\nUse syntax as: SETTINGS: classType=java.math.BigDecimal, NP=NUMBER, scale=0");
                }
                if (linebuf.startsWith("bad")) {
                    String input = linebuf.substring(3).trim();
                    this.bad(nc, input, NumericPresentation.isMonetary((NumericPresentation)np));
                    continue;
                }
                if (!linebuf.startsWith("good\t")) continue;
                if ("\t".equals(linebuf = linebuf.substring(5))) {
                    this.good(nc, "", "");
                    continue;
                }
                String[] splits = linebuf.split("\\t");
                if (splits == null || splits.length != 2) {
                    throw new IOException("Line params with expected sucessful conversion must be delimited using TAB (\\t) character! Has to have 2 values (input and expected).");
                }
                this.good(nc, splits[0].trim(), splits[1].trim());
            }
        }
    }
}

