/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.converters;

import java.util.Locale;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import to.etc.domui.converter.TimeToSecondsConverter;
import to.etc.webapp.nls.NlsContext;

public class TestTimeConvertor {
    private static final String[] BAD_TIMES = new String[]{"24:00", ":00", "abc", "10.00", "22", ":1", "111:10", ":60", "1:61", "23:60", "10::00", "10: 1", "1 :00", "1266", "12", "2401"};
    private static final String[] GOOD_TIMES = new String[]{"", "9:00", "20:00", "23:00", "0:10", "0:20", "0:03", "12:23"};
    private static final String[] GOOD_TIMES_NO_COLON = new String[]{"944", "012", "1355"};
    private static final Integer[] GOOD_TIMESRAW = new Integer[]{null, new Integer(32400), new Integer(72000), new Integer(82800), new Integer(600), new Integer(1200), new Integer(180), new Integer(44580)};
    private static final Integer[] GOOD_TIMESRAW_NO_COLON = new Integer[]{new Integer(35040), new Integer(720), new Integer(50100)};

    @BeforeClass
    public static void setUp() {
        Locale nl = new Locale("nl", "NL");
        NlsContext.setCurrencyLocale((Locale)nl);
        NlsContext.setLocale((Locale)nl);
    }

    @Test
    public void checkGoodTimes() {
        TimeToSecondsConverter tc = new TimeToSecondsConverter();
        Integer timeFromString = null;
        for (int j = 0; j < GOOD_TIMES.length; ++j) {
            String time = GOOD_TIMES[j];
            Integer timeRaw = GOOD_TIMESRAW[j];
            String timeFromObject = tc.convertObjectToString(NlsContext.getLocale(), timeRaw);
            try {
                timeFromString = tc.convertStringToObject(NlsContext.getLocale(), time);
            }
            catch (Exception x) {
                Assert.fail((String)("Time could not be converted:" + time));
            }
            Assert.assertEquals((Object)timeFromObject, (Object)time);
            Assert.assertEquals((Object)timeFromString, (Object)timeRaw);
        }
    }

    @Test
    public void checkGoodTimesNoColon() {
        TimeToSecondsConverter tc = new TimeToSecondsConverter();
        Integer timeFromString = null;
        for (int j = 0; j < GOOD_TIMES_NO_COLON.length; ++j) {
            String time = GOOD_TIMES_NO_COLON[j];
            Integer timeRaw = GOOD_TIMESRAW_NO_COLON[j];
            String timeFromObject = tc.convertObjectToString(NlsContext.getLocale(), timeRaw);
            try {
                timeFromString = tc.convertStringToObject(NlsContext.getLocale(), time);
            }
            catch (Exception x) {
                Assert.fail((String)("Time could not be converted:" + time));
            }
            time = new StringBuffer(time).insert(time.length() - 2, ":").toString();
            Assert.assertEquals((Object)timeFromObject, (Object)time);
            Assert.assertEquals((Object)timeFromString, (Object)timeRaw);
        }
    }

    @Test
    public void checkBadTimes() {
        TimeToSecondsConverter tc = new TimeToSecondsConverter();
        for (int j = 0; j < BAD_TIMES.length; ++j) {
            String time = BAD_TIMES[j];
            try {
                tc.convertStringToObject(NlsContext.getLocale(), time);
                Assert.fail((String)("It's a good time ??? " + time));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

