/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.delta;

import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.PrettyXmlOutputWriter;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.MsgDiv;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.OptimalDeltaRenderer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.test.DirtyNodeChecker;
import to.etc.domui.testsupport.TUtilDomUI;
import to.etc.domui.testsupport.TestRequestContext;

public class TestDelta {
    private Page createPage() throws Exception {
        Page p = TUtilDomUI.createPage(UrlPage.class);
        for (int i = 0; i < 10; ++i) {
            Div d2 = new Div();
            d2.setText("This is line " + i);
            p.getBody().add((NodeBase)d2);
        }
        return p;
    }

    private Page createRenderedPage() throws Exception {
        Page p = this.createPage();
        this.getFullRenderText(p);
        return p;
    }

    @Test
    public void testSingleDelete() throws Exception {
        Page p = TUtilDomUI.createPage(UrlPage.class);
        for (int i = 0; i < 10; ++i) {
            Div d2 = new Div();
            d2.setText("This is line " + i);
            p.getBody().add((NodeBase)d2);
        }
        String full = this.getFullRenderText(p);
        p.getBody().visit((INodeVisitor)new DirtyNodeChecker());
        System.out.println("Rendered: " + full);
        p.getBody().getChild(5).remove();
        String render = this.getDeltaRenderText(p);
        System.out.println("\n\n---- Render after remove node 5 in child list ----\n" + render);
        p.getBody().visit((INodeVisitor)new DirtyNodeChecker());
        Assert.assertEquals((Object)render, (Object)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<delta>\n  <remove select=\"#_C\"/>\n  <eval>WebUI.cancelPolling();</eval>\n</delta>\n");
        p.getBody().getChild(1).remove();
        render = this.getDeltaRenderText(p);
        System.out.println("\n\n---- Render after remove node 1 in child list ----\n" + render);
        p.getBody().visit((INodeVisitor)new DirtyNodeChecker());
    }

    public BrowserVersion getBrowserVersion() {
        return BrowserVersion.parseUserAgent((String)"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)");
    }

    public String getFullRenderText(Page pg) throws Exception {
        return this.getFullRenderText(this.getBrowserVersion(), pg);
    }

    public HtmlFullRenderer getFullRenderer(IBrowserOutput o) throws Exception {
        BrowserVersion bv = this.getBrowserVersion();
        return TUtilDomUI.getApplication().findRendererFor(bv, o);
    }

    public String getFullRenderText(BrowserVersion bv, Page pg) throws Exception {
        StringWriter sw = new StringWriter();
        PrettyXmlOutputWriter ro = new PrettyXmlOutputWriter((Writer)sw);
        HtmlFullRenderer hr = this.getFullRenderer((IBrowserOutput)ro);
        pg.internalFullBuild();
        TestRequestContext ctx = new TestRequestContext();
        hr.render((IRequestContext)ctx, pg);
        pg.internalClearDeltaFully();
        return sw.getBuffer().toString();
    }

    public String getDeltaRenderText(Page pg) throws Exception {
        return this.getDeltaRenderText(this.getBrowserVersion(), pg);
    }

    public String getDeltaRenderText(BrowserVersion bv, Page pg) throws Exception {
        StringWriter sw = new StringWriter();
        PrettyXmlOutputWriter ro = new PrettyXmlOutputWriter((Writer)sw);
        TestRequestContext ctx = new TestRequestContext();
        HtmlFullRenderer hr = this.getFullRenderer((IBrowserOutput)ro);
        pg.internalDeltaBuild();
        OptimalDeltaRenderer odr = new OptimalDeltaRenderer(hr, (IRequestContext)ctx, pg);
        odr.render();
        return sw.getBuffer().toString();
    }

    private static Div getIntDiv(Page p) {
        return p.getBody();
    }

    @Test
    public void testSingleAdd() throws Exception {
        Page p = this.createRenderedPage();
        Div d = new Div();
        d.setText("new@5");
        TestDelta.getIntDiv(p).add(5, (NodeBase)d);
        String render = this.getDeltaRenderText(p);
        System.out.println("\n\n---- Render after adding node@5 in child list ----\n" + render);
    }

    @Test
    public void testHellFreeze1() throws Exception {
        Page p = TUtilDomUI.createPage(UrlPage.class);
        UrlPage up = p.getBody();
        Div root = new Div();
        up.add((NodeBase)root);
        Div popin = new Div();
        root.add((NodeBase)popin);
        popin.add((NodeBase)new MsgDiv("Fixed content"));
        MsgDiv content = new MsgDiv("Blabla");
        popin.add((NodeBase)content);
        System.out.println("root=" + root.getActualID() + ", popin=" + popin.getActualID() + ", content=" + content.getActualID());
        this.getFullRenderText(p);
        for (String s : p.internalNodeMap().keySet()) {
            System.out.println("INITIAL key=" + s);
        }
        System.out.println("------- step 2: remove popin ---------");
        popin.remove();
        this.getDeltaRenderText(p);
        System.out.println("------- step 3: add popin, then remove contents ---------");
        root.add((NodeBase)popin);
        content.remove();
        this.getDeltaRenderText(p);
        System.out.println("------- step 4: add back contents and die ---------");
        popin.add((NodeBase)content);
        this.getDeltaRenderText(p);
    }
}

