/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.test.upload;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import to.etc.domui.util.upload.MultipartStream;
import to.etc.domui.util.upload.UploadItem;
import to.etc.domui.util.upload.UploadParser;

public class TestUploadParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGood() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("good.bin");
        try {
            UploadParser up = new UploadParser();
            List res = up.parseRequest(is, "utf-8", "multipart/form-data; boundary=---------------------------761455922829130801673802772", 999);
            for (UploadItem it : res) {
                System.out.println("item: " + it.getName());
            }
            Assert.assertEquals((long)2L, (long)res.size());
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Test(expected=MultipartStream.MalformedStreamException.class)
    public void testBad() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("bad.bin");
        try {
            UploadParser up = new UploadParser();
            up.parseRequest(is, "utf-8", "multipart/form-data; boundary=--boun-da-ry-0xababaeaGfHdNarcolethe-mumble-to-content-eNCoDer-gxixmar-rennes-le-chateau124a098aa8eetc", 999);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

