/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.ajax;

import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import to.etc.domui.ajax.AjaxRequestHandler;
import to.etc.domui.ajax.IRpcCallContext;
import to.etc.domui.ajax.RpcCallHandler;
import to.etc.domui.ajax.RpcException;
import to.etc.domui.ajax.URLParameterProvider;
import to.etc.domui.annotations.ResponseFormat;
import to.etc.domui.login.IUser;
import to.etc.domui.server.HttpServerRequestResponse;
import to.etc.domui.server.IRequestResponse;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.UIContext;

public class AjaxRequestContext
implements IRpcCallContext {
    private final RequestContextImpl m_rctx;
    private final AjaxRequestHandler m_rh;
    private final RpcCallHandler m_callHandler;

    public AjaxRequestContext(AjaxRequestHandler ajaxRequestHandler, RpcCallHandler ch, RequestContextImpl ctx) {
        this.m_rh = ajaxRequestHandler;
        this.m_rctx = ctx;
        this.m_callHandler = ch;
    }

    public RequestContextImpl getRctx() {
        return this.m_rctx;
    }

    private HttpServletResponse getResponse() {
        IRequestResponse rr = this.m_rctx.getRequestResponse();
        if (rr instanceof HttpServerRequestResponse) {
            return ((HttpServerRequestResponse)rr).getResponse();
        }
        throw new IllegalStateException("Cannot get response object from a " + rr);
    }

    @Override
    public <T> T createHandlerClass(Class<T> clz) throws Exception {
        return this.m_rh.makeCallClass(clz, this);
    }

    @Override
    public boolean hasRight(String role) {
        IUser user = UIContext.getCurrentUser();
        if (user == null) {
            return false;
        }
        return user.hasRight(role);
    }

    @Override
    public <T> T allocateOutput(Class<T> oc, ResponseFormat rf) throws Exception {
        return null;
    }

    @Override
    public void outputCompleted(Object output) throws Exception {
    }

    @Override
    public Writer getResponseWriter(ResponseFormat format, String callname) throws Exception {
        switch (format) {
            default: {
                throw new IllegalStateException("Unknown response format: " + (Object)((Object)format));
            }
            case JSON: {
                this.getResponse().setContentType("text/html");
                this.getResponse().setCharacterEncoding("utf-8");
                this.getResponse().addHeader("X-ETC-AJAX-CALL", callname);
                return this.getResponse().getWriter();
            }
            case XML: 
        }
        this.getResponse().setContentType("text/xml");
        this.getResponse().setCharacterEncoding("utf-8");
        this.getResponse().addHeader("X-ETC-AJAX-CALL", callname);
        return this.getResponse().getWriter();
    }

    void execute(String rurl) throws Exception {
        try {
            String call;
            int pos;
            if (rurl == null) {
                throw new RpcException("Missing url segment");
            }
            int sx = 0;
            int ex = rurl.length();
            if (rurl.startsWith("/")) {
                sx = 1;
            }
            if (rurl.endsWith("/")) {
                --ex;
            }
            if ((pos = rurl.lastIndexOf(46)) != -1) {
                ex = pos;
            }
            if ((call = rurl.substring(sx, ex)).equals("bulk")) {
                this.executeBulkRequest();
                return;
            }
            String s = this.m_rctx.getParameter("_format");
            ResponseFormat rf = null;
            if (s != null) {
                rf = ResponseFormat.valueOf(s);
            }
            URLParameterProvider pp = new URLParameterProvider(this.m_rctx);
            this.m_callHandler.executeSingleCall(this, pp, call, rf);
        }
        catch (RpcException sx) {
            sx.setUrl(this.getRctx().getRequestResponse().getRequestURI());
            throw sx;
        }
    }

    private void executeBulkRequest() throws Exception {
        String json = this.m_rctx.getParameter("json");
        if (json != null) {
            this.m_callHandler.executeBulkJSON(this, json);
            return;
        }
        throw new RuntimeException("Bulk calls implemented for JSON only (and no json= parameter found).");
    }
}

