/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.ajax;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.ajax.AjaxRequestContext;
import to.etc.domui.ajax.RpcCallHandler;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestInterceptor;
import to.etc.domui.server.RequestContextImpl;
import to.etc.iocular.Container;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.def.ContainerDefinition;

public class AjaxRequestHandler
implements IFilterRequestHandler {
    private static final String CONT_KEY = "ajax.ioc";
    private final DomApplication m_application;
    private List<IRequestInterceptor> m_interceptorList = new ArrayList<IRequestInterceptor>();
    private Container m_applicationContainer;
    private ContainerDefinition m_sessionContainerDef;
    private ContainerDefinition m_requestContainerDef;
    private final RpcCallHandler m_callHandler;

    public AjaxRequestHandler(DomApplication domApplication) {
        this.m_application = domApplication;
        this.m_callHandler = new RpcCallHandler();
    }

    @Override
    public boolean accepts(@Nonnull IRequestContext ctx) throws Exception {
        return ctx.getExtension().equals("xaja");
    }

    public DomApplication getApplication() {
        return this.m_application;
    }

    public synchronized void addInterceptor(IRequestInterceptor r) {
        ArrayList<IRequestInterceptor> l = new ArrayList<IRequestInterceptor>(this.m_interceptorList);
        l.add(r);
        this.m_interceptorList = l;
    }

    public synchronized List<IRequestInterceptor> getInterceptorList() {
        return this.m_interceptorList;
    }

    public Container getApplicationContainer() {
        return this.m_applicationContainer;
    }

    public void setApplicationContainer(Container applicationContainer) {
        this.m_applicationContainer = applicationContainer;
    }

    public ContainerDefinition getSessionContainerDef() {
        return this.m_sessionContainerDef;
    }

    public void setSessionContainerDef(ContainerDefinition sessionContainerDef) {
        this.m_sessionContainerDef = sessionContainerDef;
    }

    public ContainerDefinition getRequestContainerDef() {
        return this.m_requestContainerDef;
    }

    public void setRequestContainerDef(ContainerDefinition requestContainerDef) {
        this.m_requestContainerDef = requestContainerDef;
    }

    private Container getRequestContainer(RequestContextImpl ci) {
        Container dad;
        Object v = ci.getAttribute(CONT_KEY);
        if (v != null) {
            return (Container)v;
        }
        if (this.getSessionContainerDef() == null) {
            dad = this.getApplicationContainer();
        } else {
            dad = (Container)ci.getSession().getAttribute(CONT_KEY);
            if (dad == null) {
                dad = new BasicContainer(this.getSessionContainerDef(), this.getApplicationContainer());
                ci.getSession().setAttribute(CONT_KEY, dad);
                dad.start();
            }
        }
        BasicContainer rq = new BasicContainer(this.getRequestContainerDef(), dad);
        ci.setAttribute("arq.bc", rq);
        rq.start();
        return rq;
    }

    <T> T makeCallClass(Class<T> clz, AjaxRequestContext ctx) throws Exception {
        Container bc = this.getRequestContainer(ctx.getRctx());
        bc.setParameter((Object)ctx.getRctx());
        return (T)bc.getObject(clz);
    }

    private void requestCompleted(RequestContextImpl ctx) {
        Container co = (Container)ctx.getAttribute(CONT_KEY);
        if (co == null) {
            return;
        }
        ctx.setAttribute(CONT_KEY, null);
        co.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(@Nonnull RequestContextImpl ctx) throws Exception {
        AjaxRequestContext ax = new AjaxRequestContext(this, this.m_callHandler, ctx);
        String rurl = ctx.getInputPath();
        boolean ok = false;
        try {
            ax.execute(rurl);
            ok = true;
        }
        finally {
            try {
                this.requestCompleted(ctx);
            }
            catch (Exception x) {
                if (ok) {
                    throw x;
                }
                x.printStackTrace();
            }
        }
    }
}

