/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.ajax;

import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.ajax.IParameterProvider;
import to.etc.domui.ajax.IRpcCallContext;
import to.etc.domui.ajax.JsonParameterProvider;
import to.etc.domui.ajax.RpcClassDefinition;
import to.etc.domui.ajax.RpcException;
import to.etc.domui.ajax.RpcMethodDefinition;
import to.etc.domui.annotations.AjaxHandler;
import to.etc.domui.annotations.AjaxParam;
import to.etc.domui.annotations.ResponseFormat;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;
import to.etc.webapp.ajax.renderer.JSONParser;
import to.etc.webapp.ajax.renderer.StructuredWriter;
import to.etc.webapp.ajax.renderer.json.JSONRegistry;
import to.etc.webapp.ajax.renderer.json.JSONRenderer;
import to.etc.webapp.ajax.renderer.json.JSONStructuredWriter;
import to.etc.webapp.ajax.renderer.xml.XMLStructuredWriter;
import to.etc.webapp.ajax.renderer.xml.XmlRegistry;
import to.etc.webapp.ajax.renderer.xml.XmlRenderer;
import to.etc.xml.XmlWriter;

public class RpcCallHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RpcCallHandler.class);
    private final Map<String, RpcClassDefinition> m_classDefMap = new HashMap<String, RpcClassDefinition>();
    private final XmlRegistry m_xmlRegistry = new XmlRegistry();
    private final JSONRegistry m_JSONRegistry = new JSONRegistry();
    private ResponseFormat m_defaultFormat = ResponseFormat.XML;

    private Class<?> findClass(String basename) {
        ClassLoader ldr = this.getClass().getClassLoader();
        try {
            return ldr.loadClass(basename);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcClassDefinition getServiceClassDefinition(String basename) throws Exception {
        RpcClassDefinition hi = null;
        RpcCallHandler rpcCallHandler = this;
        synchronized (rpcCallHandler) {
            hi = this.m_classDefMap.get(basename);
            if (hi != null) {
                return hi;
            }
            Class<?> cl = this.findClass(basename);
            if (cl == null) {
                throw new RpcException("Unknown class '" + basename + "'");
            }
            AjaxHandler am = cl.getAnnotation(AjaxHandler.class);
            if (am == null) {
                throw new RpcException("The class '" + cl.getCanonicalName() + "' is not annotated as an @AjaxHandler");
            }
            hi = new RpcClassDefinition(cl);
            this.m_classDefMap.put(basename, hi);
            this.m_classDefMap.put(cl.getCanonicalName(), hi);
            return hi;
        }
    }

    @Nonnull
    RpcClassDefinition resolveHandler(String name) throws Exception {
        String basename = name.replace('/', '.');
        RpcClassDefinition hi = this.getServiceClassDefinition(basename);
        hi.initialize();
        return hi;
    }

    private RpcMethodDefinition findHandlerMethod(IRpcCallContext cb, String rurl) throws Exception {
        int pos = rurl.lastIndexOf(46);
        if (pos == -1) {
            throw new RpcException("Invalid call: need [package].[class].[method] like to.etc.test.AClass.getThingy");
        }
        String cn = rurl.substring(0, pos);
        String mn = rurl.substring(pos + 1);
        RpcClassDefinition hi = this.resolveHandler(cn);
        String[] roles = hi.getRoles();
        if (roles.length > 0 && !this.hasAnyRole(cb, roles)) {
            throw new RpcException(hi.getHandlerClass() + ": handler class is not allowed for the user's roles");
        }
        RpcMethodDefinition mi = hi.getMethod(mn);
        roles = mi.getRoles();
        if (roles.length > 0 && !this.hasAnyRole(cb, roles)) {
            throw new RpcException(mi.getMethod().toString() + ": handler method is not allowed for the user's roles");
        }
        return mi;
    }

    private boolean hasAnyRole(IRpcCallContext cb, String[] roles) throws Exception {
        for (String s : roles) {
            if (!cb.hasRight(s)) continue;
            return true;
        }
        return false;
    }

    private Object allocateHandler(IRpcCallContext cb, RpcMethodDefinition mi) throws Exception {
        if (mi.isStatic()) {
            return null;
        }
        return cb.createHandlerClass(mi.getServiceClassDefinition().getHandlerClass());
    }

    public void executeSingleCall(IRpcCallContext cb, IParameterProvider pv, String callsign, ResponseFormat formatoverride) throws Exception {
        RpcMethodDefinition mi = this.findHandlerMethod(cb, callsign);
        Object handler = this.allocateHandler(cb, mi);
        if (!(formatoverride != null && formatoverride != ResponseFormat.UNDEFINED || (formatoverride = mi.getResponseFormat()) != null && formatoverride != ResponseFormat.UNDEFINED)) {
            formatoverride = this.getDefaultFormat();
        }
        if (mi.getOutputClass() == null) {
            Object result = this.executeMethod(cb, mi, handler, pv, null);
            Writer ow = cb.getResponseWriter(formatoverride, mi.getMethod().getName());
            this.renderResponseObject(ow, formatoverride, result);
            return;
        }
        Object oo = cb.allocateOutput(mi.getOutputClass(), formatoverride);
        if (oo == null) {
            oo = this.allocateOutput(cb, mi.getOutputClass(), formatoverride);
        }
        this.executeMethod(cb, mi, handler, pv, oo);
        cb.outputCompleted(oo);
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annar, Class<T> clz) {
        for (Annotation ann : annar) {
            if (ann.annotationType() != clz) continue;
            return (T)ann;
        }
        return null;
    }

    private Object executeMethod(IRpcCallContext cb, RpcMethodDefinition mi, Object handler, IParameterProvider papro, Object output) throws Exception {
        Object result;
        long ts = System.nanoTime();
        StringBuilder sb = new StringBuilder();
        sb.append("SVC: call ");
        sb.append(mi.toString());
        try {
            Class<?>[] formals = mi.getMethod().getParameterTypes();
            Object[] args = new Object[formals.length];
            Annotation[][] argannar = mi.getMethod().getParameterAnnotations();
            int oix = 0;
            int ix = 0;
            if (output != null) {
                args[0] = output;
                oix = 1;
            }
            while (oix < formals.length) {
                AjaxParam apm = RpcCallHandler.findAnnotation(argannar[oix], AjaxParam.class);
                if (apm == null) {
                    throw new RpcException("Parameter " + oix + " of method " + mi.getMethod() + " is missing an @AjaxParam annotation.");
                }
                args[oix] = papro.findParameterValue(formals[oix], argannar[oix], ix, apm);
                if (args[oix] == "$*$novalue") {
                    throw new RpcException("Parameter " + oix + " of method " + mi.getMethod() + " has no value.");
                }
                ++oix;
            }
            result = mi.getMethod().invoke(handler, args);
            sb.append(": okay, result=");
            if (result == null) {
                sb.append("null");
            } else {
                sb.append(result.getClass().getName());
            }
        }
        catch (InvocationTargetException ix) {
            Throwable x = ix.getCause();
            sb.append(": exception ");
            sb.append(x.toString());
            throw new RpcException(x, x.getMessage());
        }
        finally {
            ts = System.nanoTime() - ts;
            sb.append(" (");
            sb.append(StringTool.strNanoTime((long)ts));
            sb.append(")");
            LOG.info(sb.toString());
        }
        return result;
    }

    private void renderResponseObject(Writer ow, ResponseFormat rf, Object result) throws Exception {
        XmlWriter xw = new XmlWriter(ow);
        switch (rf) {
            default: {
                XmlRenderer xr = new XmlRenderer(this.getXmlRegistry(), xw);
                xr.render(result);
                break;
            }
            case JSON: {
                JSONRenderer jr = new JSONRenderer(this.getJSONRegistry(), (IndentWriter)xw, true);
                jr.render(result);
            }
        }
    }

    private <T> T allocateOutput(IRpcCallContext ctx, Class<T> oc, ResponseFormat rf) throws Exception {
        if (oc.isAssignableFrom(StructuredWriter.class)) {
            Writer ow = ctx.getResponseWriter(rf, "undefined");
            switch (rf) {
                default: {
                    throw new RpcException("Unknown response format " + (Object)((Object)rf));
                }
                case JSON: {
                    JSONRenderer jr = new JSONRenderer(this.getJSONRegistry(), new IndentWriter(ow), true);
                    return (T)new JSONStructuredWriter(jr);
                }
                case XML: 
            }
            XmlRenderer xr = new XmlRenderer(this.getXmlRegistry(), new XmlWriter(ow));
            return (T)new XMLStructuredWriter(xr);
        }
        if (oc.isAssignableFrom(Writer.class)) {
            return (T)ctx.getResponseWriter(rf, "undefined");
        }
        throw new RpcException("The output class '" + oc.toString() + "' is not acceptable.");
    }

    public void executeBulkJSON(IRpcCallContext cb, String json) throws Exception {
        LOG.info("SVC: JSON bulk call: " + json);
        Object jsonds = JSONParser.parseJSON((String)json);
        if (!(jsonds instanceof List)) {
            throw new RpcException("The bulk call JSON data must be an array");
        }
        ArrayList<Object> reslist = new ArrayList<Object>();
        boolean cancelled = false;
        int ix = 0;
        for (Object o : (List)jsonds) {
            if (!(o instanceof Map)) {
                throw new RpcException("The bulk call's list member type of item# " + ix + " is not a JSON object");
            }
            if (cancelled) {
                reslist.add(new HashMap());
            } else {
                Object res = this.executeSingleJSON(cb, (Map)o, ix);
                reslist.add(res);
            }
            ++ix;
        }
        Writer ow = cb.getResponseWriter(ResponseFormat.JSON, "bulk");
        this.renderResponseObject(ow, ResponseFormat.JSON, reslist);
    }

    private Object executeSingleJSON(IRpcCallContext cb, Map<Object, Object> callmap, int index) throws Exception {
        String name = (String)callmap.get("method");
        if (name == null) {
            throw new RpcException("Missing 'method' property in list item #" + index);
        }
        Object o = callmap.get("id");
        String id = o == null ? null : o.toString();
        o = callmap.get("cancelonerror");
        o = callmap.get("parameters");
        if (o != null && !(o instanceof Map)) {
            throw new RpcException("The 'parameters' item is not a Map in list item #" + index);
        }
        HashMap<Object, Object> parameters = o == null ? new HashMap() : (Map)o;
        RpcMethodDefinition mi = this.findHandlerMethod(cb, name);
        Object handler = this.allocateHandler(cb, mi);
        JsonParameterProvider pp = new JsonParameterProvider(parameters);
        Object result = this.executeMethod(cb, mi, handler, pp, null);
        HashMap<String, Object> resmap = new HashMap<String, Object>();
        if (id != null) {
            resmap.put("id", id);
        }
        resmap.put("result", result);
        return resmap;
    }

    public XmlRegistry getXmlRegistry() {
        return this.m_xmlRegistry;
    }

    public ResponseFormat getDefaultFormat() {
        return this.m_defaultFormat;
    }

    public void setDefaultResponseFormat(ResponseFormat rf) {
        this.m_defaultFormat = rf;
    }

    public JSONRegistry getJSONRegistry() {
        return this.m_JSONRegistry;
    }
}

