/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.ajax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import to.etc.domui.ajax.RpcException;
import to.etc.domui.ajax.RpcMethodDefinition;
import to.etc.domui.annotations.AjaxHandler;
import to.etc.domui.annotations.ResponseFormat;

public class RpcClassDefinition {
    private final Class<?> m_handlerClass;
    private boolean m_initialized;
    private Exception m_errorException;
    private String[] m_roles;
    private ResponseFormat m_responseFormat;
    private final Map<String, RpcMethodDefinition> m_methodMap = new HashMap<String, RpcMethodDefinition>();

    public RpcClassDefinition(Class<?> cl) {
        this.m_handlerClass = cl;
    }

    public synchronized void initialize() throws Exception {
        if (this.m_errorException != null) {
            throw this.m_errorException;
        }
        if (this.m_initialized) {
            return;
        }
        try {
            this.checkAnnotations();
            this.m_initialized = true;
        }
        catch (Exception x) {
            this.m_errorException = x;
            throw x;
        }
    }

    private void checkAnnotations() throws Exception {
        if (!this.m_handlerClass.isAnnotationPresent(AjaxHandler.class)) {
            throw new RpcException("The class " + this.m_handlerClass.getCanonicalName() + " is not annotated with @AjaxHandler");
        }
        AjaxHandler ah = this.m_handlerClass.getAnnotation(AjaxHandler.class);
        StringTokenizer st = new StringTokenizer(ah.roles(), " \t,");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            l.add(s);
        }
        this.m_roles = l.toArray(new String[l.size()]);
        this.m_responseFormat = ah.response();
    }

    public String[] getRoles() {
        return this.m_roles;
    }

    public Class<?> getHandlerClass() {
        return this.m_handlerClass;
    }

    public synchronized RpcMethodDefinition getMethod(String name) throws Exception {
        RpcMethodDefinition mi = this.m_methodMap.get(name);
        if (mi == null) {
            mi = new RpcMethodDefinition(this, name);
            this.m_methodMap.put(name, mi);
        }
        mi.initialize();
        return mi;
    }

    public final ResponseFormat getResponseFormat() {
        return this.m_responseFormat;
    }
}

