/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.ajax;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import to.etc.domui.ajax.RpcClassDefinition;
import to.etc.domui.ajax.RpcException;
import to.etc.domui.annotations.AjaxMethod;
import to.etc.domui.annotations.ResponseFormat;

public class RpcMethodDefinition {
    private final RpcClassDefinition m_ServiceClassDefinition;
    private Method m_method;
    private final String m_name;
    private Exception m_exc;
    private String[] m_roles;
    private boolean m_static;
    private boolean m_initialized;
    private ResponseFormat m_responseFormat;
    private Class<?> m_outputClass;

    RpcMethodDefinition(RpcClassDefinition hi, String name) {
        this.m_name = name;
        this.m_ServiceClassDefinition = hi;
    }

    void initialize() throws Exception {
        if (this.m_exc != null) {
            throw this.m_exc;
        }
        if (this.m_initialized) {
            return;
        }
        try {
            this.m_method = this.findMethod(this.m_name);
            if (this.m_method == null) {
                throw new RpcException(this.m_ServiceClassDefinition.getHandlerClass() + " does not have a method called '" + this.m_name + "'");
            }
            this.checkReturnMethod();
            this.checkAnnotations(this.m_method);
        }
        catch (Exception x) {
            this.m_exc = x;
            throw x;
        }
    }

    private void checkReturnMethod() throws Exception {
        Class<?> rv = this.m_method.getReturnType();
        if (rv != Void.TYPE) {
            this.m_outputClass = null;
            return;
        }
        Class<?>[] par = this.m_method.getParameterTypes();
        if (par.length == 0) {
            throw new RpcException("The method '" + this.m_method + "' returns void and does not have an output parameter; it cannot be called.");
        }
        this.m_outputClass = par[0];
    }

    private Method findMethod(String name) throws Exception {
        Class<?> cl = this.m_ServiceClassDefinition.getHandlerClass();
        Method foundm = null;
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals(name)) continue;
            if (foundm != null) {
                throw new RpcException("The method '" + name + "' occurs 2ce [" + foundm.toGenericString() + " and " + m.toGenericString() + "]");
            }
            foundm = m;
        }
        return foundm;
    }

    private void checkAnnotations(Method m) throws Exception {
        this.m_static = Modifier.isStatic(m.getModifiers());
        AjaxMethod am = m.getAnnotation(AjaxMethod.class);
        ArrayList<String> l = new ArrayList<String>();
        if (am == null) {
            throw new RpcException(m.getName() + ": The method is not annotated with @AjaxMethod");
        }
        if (am.roles() != null) {
            StringTokenizer st = new StringTokenizer(am.roles(), " \t,");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                l.add(s);
            }
        }
        this.m_roles = l.toArray(new String[l.size()]);
        this.m_responseFormat = am.response() != ResponseFormat.UNDEFINED ? am.response() : this.m_ServiceClassDefinition.getResponseFormat();
    }

    public final ResponseFormat getResponseFormat() {
        return this.m_responseFormat;
    }

    public String[] getRoles() {
        return this.m_roles;
    }

    boolean isStatic() {
        return this.m_static;
    }

    RpcClassDefinition getServiceClassDefinition() {
        return this.m_ServiceClassDefinition;
    }

    Method getMethod() {
        return this.m_method;
    }

    Class<?> getOutputClass() {
        return this.m_outputClass;
    }

    public String toString() {
        return this.m_method == null ? this.m_name : this.m_method.toGenericString();
    }
}

