/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.autotest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.autotest.IDomUITestInfo;
import to.etc.domui.autotest.PageData;
import to.etc.domui.autotest.TestConfigParameters;
import to.etc.domui.autotest.TestRequestResponse;
import to.etc.domui.autotest.TestServerSession;
import to.etc.domui.dom.html.Input;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.AbstractContextMaker;
import to.etc.domui.server.AppFilter;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IFilterRequestHandler;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.IRequestInterceptor;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.AppSession;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.util.StringTool;

public class DomuiPageTester
implements IDomUITestInfo {
    @Nonnull
    private final List<PageRef> m_pageList = new ArrayList<PageRef>();
    @Nonnull
    private String m_userAgent = "Mozilla/5.0 (Windows; U; MSIE 9.0; Windows NT 9.0; en-US)";
    @Nullable
    private static DomApplication m_appInstance;
    @Nullable
    private TestServerSession m_ssession;
    private Page m_lastPage;
    private IRequestContext m_lastContext;
    private Set<String> m_clickedNodeSet = new HashSet<String>();

    public static synchronized void initApplication(@Nonnull Class<? extends DomApplication> applicationClass, @Nonnull File webappFiles) throws Exception {
        AppFilter.initLogConfig(null, null);
        DomApplication da = m_appInstance;
        if (da != null) {
            if (applicationClass.isAssignableFrom(da.getClass())) {
                return;
            }
            throw new IllegalStateException("DomApplication already defined as " + da);
        }
        da = applicationClass.newInstance();
        HashMap<String, String> map = new HashMap<String, String>();
        TestConfigParameters cp = new TestConfigParameters(webappFiles, map);
        da.internalInitialize(cp, false);
        m_appInstance = da;
    }

    @Nonnull
    public static DomApplication app() {
        DomApplication da = m_appInstance;
        if (null == da) {
            throw new IllegalStateException("Call #initApplication() before you can run tests.");
        }
        return da;
    }

    private static void checkInit() {
        DomuiPageTester.app();
    }

    @Override
    @Nonnull
    public DomApplication getApplication() {
        return DomuiPageTester.app();
    }

    @Override
    @Nonnull
    public String getApplicationHost() {
        return "http://www.test.nl/";
    }

    @Override
    @Nonnull
    public String getWebappContext() {
        return "test";
    }

    @Nonnull
    public String getApplicationURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getApplicationHost());
        String wc = this.getWebappContext();
        if (wc.length() > 0) {
            sb.append(wc);
            sb.append('/');
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(@Nonnull String userAgent) {
        this.m_userAgent = userAgent;
    }

    @Override
    @Nullable
    public String getRemoteUser() {
        return "VPC";
    }

    public void addPage(@Nonnull Class<? extends UrlPage> page, @Nonnull PageParameters pp) {
        this.m_pageList.add(new PageRef(page, pp));
    }

    public void addPage(@Nonnull Class<? extends UrlPage> page, Object ... data) {
        PageParameters pp = new PageParameters(data);
        this.m_pageList.add(new PageRef(page, pp));
    }

    public void run() throws Exception {
        for (PageRef pr : this.m_pageList) {
            this.run(pr.getPageClass(), pr.getParameters());
        }
    }

    private void run(@Nonnull Class<? extends UrlPage> pageClass, @Nonnull PageParameters parameters) throws Exception {
        DomuiPageTester.checkInit();
        AppSession appSession = new AppSession(DomuiPageTester.app());
        this.setSvSession(new TestServerSession());
        this.m_clickedNodeSet.clear();
        TestRequestResponse rr = this.createRequestResponse(pageClass, parameters);
        this.interact(appSession, rr);
        for (int counter = 0; counter < 10; ++counter) {
            TestRequestResponse newrr = null;
            switch (rr.getResponseType()) {
                default: {
                    throw new IllegalStateException((Object)((Object)rr.getResponseType()) + ": not handled?");
                }
                case DOCUMENT: {
                    System.out.println("Responded with a DOCUMENT");
                    String doc = rr.getTextDocument();
                    if (null == doc) break;
                    System.out.println(StringTool.strTrunc((String)doc, (int)5120));
                    newrr = this.handleDocument(doc, rr);
                    break;
                }
                case REDIRECT: {
                    newrr = this.handleRedirect(rr);
                    break;
                }
                case ERROR: {
                    System.out.println("http error " + rr.getErrorCode() + ": " + rr.getErrorMessage());
                    return;
                }
                case NOTHING: {
                    throw new IllegalStateException("Page did nothing!?");
                }
            }
            if (newrr == null) {
                return;
            }
            rr = newrr;
            this.interact(appSession, rr);
        }
    }

    @Nullable
    private TestRequestResponse handleDocument(@Nonnull String doc, @Nonnull TestRequestResponse rr) throws Exception {
        String str = "location.replace(";
        int pos = doc.indexOf(str);
        if (pos > 0) {
            return this.handleDocumentRedirect(doc, pos + str.length());
        }
        RequestContextImpl rci = (RequestContextImpl)this.m_lastContext;
        if (null == rci) {
            throw new IllegalStateException("? No current context was set");
        }
        Page page = this.m_lastPage;
        if (null == page) {
            throw new IllegalStateException("? No current page was set");
        }
        System.out.println("Page class was " + page.getBody());
        PageData pageData = new PageData(page);
        this.scanPageData(pageData, page.getBody());
        System.out.println("Got " + pageData.getClickTargets().size() + " click targets");
        NodeBase nb = this.findClickTarget(pageData);
        if (null != nb) {
            return this.createClickRequest(pageData, nb);
        }
        return null;
    }

    @Nullable
    private NodeBase findClickTarget(@Nonnull PageData pinfo) {
        for (NodeBase nb : pinfo.getClickTargets()) {
            if (this.m_clickedNodeSet.contains(nb.getActualID())) continue;
            this.m_clickedNodeSet.add(nb.getActualID());
            return nb;
        }
        return null;
    }

    @Nonnull
    private TestRequestResponse createClickRequest(@Nonnull PageData pinfo, @Nonnull NodeBase nodeToClick) throws Exception {
        PageParameters pp = pinfo.getPage().getPageParameters().getUnlockedCopy();
        for (NodeBase nb : pinfo.getBaseInputs()) {
            if (!(nb instanceof Input)) continue;
            String id = nb.getActualID();
            String rv = ((Input)nb).getRawValue();
            if (null == rv) continue;
            pp.addParameter(id, rv);
        }
        pp.addParameter("webuia", "clicked");
        pp.addParameter("webuic", nodeToClick.getActualID());
        return this.createRequestResponse(pinfo.getPage(), pp);
    }

    private void scanPageData(@Nonnull PageData pageData, @Nonnull NodeBase body) {
        pageData.checkNode(body);
        if (body instanceof NodeContainer) {
            for (NodeBase nb : (NodeContainer)body) {
                this.scanPageData(pageData, nb);
            }
        }
    }

    @Nullable
    private TestRequestResponse handleDocumentRedirect(@Nonnull String doc, int pos) {
        char b;
        int end = doc.indexOf(41, pos);
        if (end == -1) {
            throw new IllegalStateException("No redirect statement found");
        }
        String sub = doc.substring(pos, end).trim();
        if (sub.length() < 2) {
            throw new IllegalStateException("Bad redirect statement found: " + sub);
        }
        char a = sub.charAt(0);
        if (a == (b = sub.charAt(sub.length() - 1)) && (a == '\'' || a == '\"')) {
            sub = sub.substring(1, sub.length() - 1);
        }
        return this.handleRedirectTo(sub);
    }

    @Nullable
    private TestRequestResponse handleRedirect(@Nonnull TestRequestResponse rr) {
        String redirectURL = rr.getRedirectURL();
        if (null == redirectURL) {
            throw new IllegalStateException("Null redirect URL in test response");
        }
        return this.handleRedirectTo(redirectURL);
    }

    @Nullable
    private TestRequestResponse handleRedirectTo(@Nonnull String redirectURL) {
        String webapp;
        System.out.println("URL redirect to: " + redirectURL);
        String app = this.getApplicationURL();
        if (redirectURL.contains(":")) {
            String host = this.getApplicationHost();
            if (!redirectURL.startsWith(host)) {
                System.out.println("Redirected ouside our host -> page test ends");
                return null;
            }
            if (!(redirectURL = redirectURL.substring(host.length() - 1)).startsWith("/")) {
                throw new IllegalStateException();
            }
        } else if (!redirectURL.startsWith("/")) {
            throw new IllegalStateException("Page-relative redirect URLs not supported: " + redirectURL);
        }
        if ((webapp = this.getWebappContext()).length() > 0 && !redirectURL.startsWith(webapp = "/" + webapp + "/")) {
            System.out.println("Redirected ouside our webapp context -> page test ends");
            return null;
        }
        String query = "";
        int qpos = redirectURL.indexOf(63);
        if (qpos >= 0) {
            query = redirectURL.substring(qpos + 1);
            redirectURL = redirectURL.substring(0, qpos);
        }
        TestRequestResponse rr = new TestRequestResponse(this.getSvSession(), (IDomUITestInfo)this, redirectURL, query);
        return rr;
    }

    @Nonnull
    private TestRequestResponse createRequestResponse(@Nonnull Class<? extends UrlPage> clz, @Nonnull PageParameters pp) {
        String requestURI = this.getClassURI(clz);
        TestRequestResponse rr = new TestRequestResponse(this.getSvSession(), (IDomUITestInfo)this, requestURI, pp);
        return rr;
    }

    @Nonnull
    private String getClassURI(@Nonnull Class<? extends UrlPage> clz) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        String webappContext = this.getWebappContext();
        if (webappContext.length() > 0) {
            sb.append(webappContext);
            sb.append('/');
        }
        sb.append(clz.getName());
        sb.append('.');
        sb.append(this.getApplication().getUrlExtension());
        return sb.toString();
    }

    @Nonnull
    private TestRequestResponse createRequestResponse(@Nonnull Page page, @Nonnull PageParameters pp) {
        String requestURI = this.getClassURI(page.getBody().getClass());
        ConversationContext internalGetConversation = page.internalGetConversation();
        if (null == internalGetConversation) {
            throw new IllegalStateException("Page conversation is null???");
        }
        pp.addParameter("$cid", internalGetConversation.getFullId());
        TestRequestResponse rr = new TestRequestResponse(this.getSvSession(), (IDomUITestInfo)this, requestURI, pp);
        return rr;
    }

    private void interact(@Nonnull AppSession session, @Nonnull TestRequestResponse rr) throws Exception {
        System.out.println("T: url: " + rr.getRequestURI() + rr.getQueryString());
        RequestContextImpl ctx = new RequestContextImpl(rr, this.getApplication(), session);
        List<IRequestInterceptor> il = ctx.getApplication().getInterceptorList();
        Exception xx = null;
        IFilterRequestHandler rh = null;
        try {
            UIContext.internalSet(ctx);
            AbstractContextMaker.callInterceptorsBegin(il, ctx);
            rh = ctx.getApplication().findRequestHandler(ctx);
            if (rh == null) {
                throw new IllegalStateException("Test DomUI request not a DomUI URL: " + ctx.getRequestResponse().getRequestURI());
            }
            rh.handleRequest(ctx);
            ctx.flush();
            rr.flush();
            this.m_lastPage = UIContext.internalGetPage();
            this.m_lastContext = UIContext.internalGetContext();
        }
        catch (ThingyNotFoundException x) {
            ctx.sendError(404, x.getMessage());
        }
        catch (Exception xxx) {
            xx = xxx;
            throw xxx;
        }
        finally {
            AbstractContextMaker.callInterceptorsAfter(il, ctx, xx);
            ctx.internalOnRequestFinished();
            try {
                ctx.discard();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            UIContext.internalClear();
        }
    }

    @Nonnull
    private TestServerSession getSvSession() {
        if (null != this.m_ssession) {
            return this.m_ssession;
        }
        throw new IllegalStateException("Null SvSession");
    }

    private void setSvSession(TestServerSession ssession) {
        this.m_ssession = ssession;
    }

    private static class PageRef {
        @Nonnull
        private final Class<? extends UrlPage> m_pageClass;
        @Nonnull
        private final PageParameters m_parameters;

        public PageRef(@Nonnull Class<? extends UrlPage> pageClass, @Nonnull PageParameters parameters) {
            this.m_pageClass = pageClass;
            this.m_parameters = parameters;
        }

        @Nonnull
        public Class<? extends UrlPage> getPageClass() {
            return this.m_pageClass;
        }

        @Nonnull
        public PageParameters getParameters() {
            return this.m_parameters;
        }
    }
}

