/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.autotest;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import to.etc.domui.autotest.IDomUITestInfo;
import to.etc.domui.autotest.TestResponseType;
import to.etc.domui.autotest.TestServerSession;
import to.etc.domui.server.IRequestResponse;
import to.etc.domui.server.IServerSession;
import to.etc.domui.state.PageParameters;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.upload.UploadItem;

public class TestRequestResponse
implements IRequestResponse {
    @Nonnull
    private final IDomUITestInfo m_testInfo;
    @Nonnull
    private final Map<String, Object> m_parameterMap = new HashMap<String, Object>();
    @Nonnull
    private String m_requestURI;
    @Nullable
    private ByteArrayOutputStream m_os;
    @Nullable
    private Writer m_writer;
    @Nullable
    private String m_outputEncoding;
    @Nullable
    private String m_outputContentType;
    @Nonnull
    private TestResponseType m_responseType = TestResponseType.NOTHING;
    @Nullable
    private String m_redirectURL;
    private int m_errorCode;
    @Nullable
    private String m_errorMessage;
    @Nonnull
    private final TestServerSession m_session;
    @Nonnull
    private final String m_queryString;

    public TestRequestResponse(@Nonnull TestServerSession session, @Nonnull IDomUITestInfo info, @Nonnull String requestURI, @Nonnull String queryString) {
        this.m_testInfo = info;
        this.m_requestURI = requestURI;
        this.m_session = session;
        this.m_queryString = queryString;
        PageParameters pp = PageParameters.decodeParameters(queryString);
        this.initParameters(pp);
    }

    public TestRequestResponse(@Nonnull TestServerSession session, @Nonnull IDomUITestInfo info, @Nonnull String requestURI, @Nonnull PageParameters parameters) {
        this.m_testInfo = info;
        this.m_requestURI = requestURI;
        this.m_session = session;
        this.initParameters(parameters);
        StringBuilder sb = new StringBuilder();
        DomUtil.addUrlParameters(sb, parameters, true);
        this.m_queryString = sb.toString();
    }

    private void initParameters(@Nonnull PageParameters parameters) {
        for (String name : parameters.getParameterNames()) {
            String[] vals = parameters.getStringArray(name);
            this.m_parameterMap.put(name, vals);
        }
    }

    @Override
    @Nonnull
    public String getRequestURI() {
        return this.m_requestURI;
    }

    @Override
    @Nonnull
    public String getQueryString() {
        return this.m_queryString;
    }

    public void setRequestURI(@Nonnull String requestURI) {
        this.m_requestURI = requestURI;
    }

    @Override
    @Nonnull
    public String getUserAgent() {
        return this.m_testInfo.getUserAgent();
    }

    @Override
    @Nonnull
    public String getApplicationURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_testInfo.getApplicationHost());
        String wc = this.m_testInfo.getWebappContext();
        if (wc.length() > 0) {
            sb.append(wc);
            sb.append('/');
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String[] getParameters(@Nonnull String name) {
        String[] vals = (String[])this.m_parameterMap.get(name);
        return null == vals ? new String[]{} : vals;
    }

    @Override
    @Nullable
    public String getParameter(@Nonnull String name) {
        String[] vals = this.getParameters(name);
        if (vals.length >= 1) {
            return vals[0];
        }
        return null;
    }

    @Override
    @Nonnull
    public String[] getParameterNames() {
        return this.m_parameterMap.keySet().toArray(new String[this.m_parameterMap.keySet().size()]);
    }

    @Override
    @Nonnull
    public String[] getFileParameters() {
        return new String[0];
    }

    @Override
    @Nonnull
    public UploadItem[] getFileParameter(@Nonnull String name) {
        throw new IllegalStateException("Unsupported");
    }

    @Override
    @Nonnull
    public Writer getOutputWriter(@Nonnull String contentType, @Nullable String encoding) throws Exception {
        if (this.m_writer != null) {
            throw new IllegalStateException("Duplicate request for output writer");
        }
        OutputStream os = this.getOutputStream(contentType, encoding, -1);
        this.m_writer = new OutputStreamWriter(os, encoding);
        OutputStreamWriter osw = this.m_writer;
        return osw;
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(@Nonnull String contentType, @Nullable String encoding, int contentLength) throws Exception {
        if (this.m_os != null) {
            throw new IllegalStateException("Duplicate request for output stream");
        }
        this.setType(TestResponseType.DOCUMENT);
        ByteArrayOutputStream os = this.m_os = new ByteArrayOutputStream();
        this.m_outputContentType = contentType;
        this.m_outputEncoding = encoding;
        return os;
    }

    public void flush() throws Exception {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
    }

    private void setType(@Nonnull TestResponseType type) {
        if (this.m_responseType != TestResponseType.NOTHING) {
            throw new IllegalStateException("Reassigning output from " + (Object)((Object)this.m_responseType) + " to ");
        }
        this.m_responseType = type;
    }

    @Override
    public void redirect(@Nonnull String newUrl) throws Exception {
        this.setType(TestResponseType.REDIRECT);
        this.m_redirectURL = newUrl;
    }

    @Override
    public void sendError(int httpErrorCode, @Nonnull String message) throws Exception {
        this.setType(TestResponseType.ERROR);
        this.m_errorCode = httpErrorCode;
        this.m_errorMessage = message;
    }

    @Override
    @Nonnull
    public String getWebappContext() {
        return this.m_testInfo.getWebappContext();
    }

    @Override
    public void addCookie(@Nonnull Cookie cookie) {
    }

    @Override
    @Nonnull
    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    @Override
    public void setExpiry(int cacheTime) {
    }

    @Override
    public void releaseUploads() {
    }

    @Override
    public void setNoCache() {
    }

    @Override
    public void addHeader(@Nonnull String name, @Nonnull String value) {
    }

    @Nonnull
    public TestResponseType getResponseType() {
        return this.m_responseType;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    @Nullable
    public String getRedirectURL() {
        return this.m_redirectURL;
    }

    @Nullable
    public String getOutputContentType() {
        return this.m_outputContentType;
    }

    @Nullable
    public String getTextDocument() throws Exception {
        ByteArrayOutputStream os = this.m_os;
        if (null == os) {
            return null;
        }
        String ct = this.m_outputContentType;
        String enc = this.m_outputEncoding;
        if (ct == null) {
            return null;
        }
        int pos = ct.indexOf(59);
        if (pos > 0) {
            String[] splits;
            String rest = ct.substring(pos + 1).trim();
            ct = ct.substring(0, pos).trim();
            for (String frag : splits = rest.split(";")) {
                int eq = frag.indexOf(61);
                String name = frag;
                String value = "";
                if (eq > 0) {
                    name = frag.substring(0, eq).trim().toLowerCase();
                    value = frag.substring(eq + 1).trim();
                }
                if (!"charset".equalsIgnoreCase(name)) continue;
                enc = value;
            }
        }
        if ((ct = ct.toLowerCase()).contains("text") || ct.contains("xml") || ct.contains("javascript")) {
            String str = new String(os.toByteArray(), enc);
            return str;
        }
        System.out.println("Unknown text document type: " + ct + " encoding " + enc);
        return null;
    }

    @Override
    @Nonnull
    public String getHostURL() {
        return "http://www.test.nl/";
    }

    @Override
    @Nullable
    public String getRemoteUser() {
        return this.m_testInfo.getRemoteUser();
    }

    @Override
    @Nullable
    public IServerSession getServerSession(boolean create) {
        return this.m_session;
    }
}

