/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.caches.FileImageReference;
import to.etc.domui.parts.CachedImagePart;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.images.IImageReference;
import to.etc.domui.util.images.IImageRetriever;
import to.etc.util.StringTool;

public class FileImageRetriever
implements IImageRetriever {
    private static final long MIN_LIVE_TIME = 300000L;
    private static final String KEY = "RqTf";

    public static String createFileURL(File what, String mime, String ... convs) {
        FileRef match;
        IRequestContext ctx = UIContext.getRequestContext();
        HashMap<String, FileRef> map = (HashMap<String, FileRef>)ctx.getSession().getAttribute(KEY);
        if (map == null) {
            map = new HashMap<String, FileRef>();
            ctx.getSession().setAttribute(KEY, map);
        }
        if ((match = FileImageRetriever.findAndClear((Map<String, FileRef>)map, what)) != null) {
            return CachedImagePart.getURL(KEY, match.m_key, new String[0]);
        }
        String key = StringTool.generateGUID();
        FileRef fr = new FileRef();
        fr.m_key = key;
        fr.m_file = what;
        fr.m_mime = mime;
        long ts = System.currentTimeMillis();
        fr.m_validTill = ts + 600000L;
        map.put(key, fr);
        return CachedImagePart.getURL(KEY, key, convs);
    }

    private static FileRef findAndClear(Map<String, FileRef> map, File what) {
        long ts = System.currentTimeMillis();
        long ets = ts + 300000L;
        FileRef match = null;
        for (FileRef fr : new ArrayList<FileRef>(map.values())) {
            if (fr.m_file.equals(what) && fr.m_validTill > ets) {
                match = fr;
            }
            if (fr.m_validTill >= ts) continue;
            map.remove(fr.m_key);
        }
        return match;
    }

    @Override
    public long getCheckInterval() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nonnull
    public String getRetrieverKey() {
        return KEY;
    }

    @Override
    public IImageReference loadImage(@Nonnull String key) throws Exception {
        IRequestContext ctx = UIContext.getRequestContext();
        Map map = (Map)ctx.getSession().getAttribute(KEY);
        if (map == null) {
            return null;
        }
        FileImageRetriever.findAndClear(map, null);
        FileRef ref = (FileRef)map.get(key);
        if (ref == null) {
            return null;
        }
        return new FileImageReference(ref.m_file, ref.m_mime);
    }

    private static class FileRef {
        public File m_file;
        public String m_mime;
        public String m_key;
        public long m_validTill;
    }
}

