/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.filecache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.domui.caches.filecache.FileCacheEntry;
import to.etc.domui.caches.filecache.FileCacheRef;

@SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="FindBugs definition is wrong for mkdirs, and delete() may fail in code here")
public class FileCache {
    private File m_cacheRoot;
    private long m_maxFileSize = 0x280000000L;
    private long m_currentFileSize = 0L;
    private Map<String, FileCacheEntry> m_refMap = new HashMap<String, FileCacheEntry>();
    private boolean m_reaperRunning;
    private String m_cacheRootPath;
    private static final int MAX_ENTRIES = 5000;
    private static final Comparator<ReapEntry> C_COMP = new Comparator<ReapEntry>(){

        @Override
        public int compare(ReapEntry o1, ReapEntry o2) {
            long r = o2.m_modified - o1.m_modified;
            if (r == 0L) {
                return 0;
            }
            return r < 0L ? -1 : 1;
        }
    };

    public FileCache(File cacheRoot, long maxFileSize) {
        this.m_cacheRoot = cacheRoot.getAbsoluteFile();
        this.m_maxFileSize = maxFileSize;
        this.m_cacheRootPath = this.m_cacheRoot.getAbsolutePath().replace('\\', '/');
        if (!this.m_cacheRootPath.endsWith("/")) {
            this.m_cacheRootPath = this.m_cacheRootPath + "/";
        }
    }

    File getCacheRoot() {
        return this.m_cacheRoot;
    }

    public void initialize() throws Exception {
        this.m_cacheRoot.mkdirs();
        if (!this.m_cacheRoot.exists() || !this.m_cacheRoot.isDirectory()) {
            throw new IOException(this.m_cacheRoot + ": file cache root cannot be created or is not a directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileCacheEntry getCacheEntry(String rpath) {
        if (rpath.contains("..")) {
            throw new IllegalStateException("Invalid path: cannot contain ..");
        }
        if (rpath.contains(":") || rpath.startsWith("/")) {
            throw new IllegalStateException("Invalid path: cannot be absolute");
        }
        File f = new File(this.getCacheRoot(), rpath);
        f.getParentFile().mkdirs();
        FileCache fileCache = this;
        synchronized (fileCache) {
            FileCacheEntry fe = this.m_refMap.get(rpath);
            if (fe == null) {
                fe = new FileCacheEntry(this, f, rpath);
                this.m_refMap.put(rpath, fe);
            } else {
                fe.inc();
            }
            return fe;
        }
    }

    public FileCacheRef getFile(String rpath) {
        FileCacheEntry ce = this.getCacheEntry(rpath);
        return new FileCacheRef(ce);
    }

    synchronized boolean inuse(String key) {
        return this.m_refMap.containsKey(key);
    }

    synchronized void incUse(FileCacheEntry ce) {
        if (ce.m_useCount <= 0) {
            throw new IllegalStateException("Internal: use count invalid");
        }
        ++ce.m_useCount;
    }

    synchronized void decUse(FileCacheEntry ce) {
        if (ce.m_useCount <= 0) {
            throw new IllegalStateException("Internal: use count invalid");
        }
        if (--ce.m_useCount > 0) {
            return;
        }
        this.m_refMap.remove(ce.getKey());
        try {
            if (ce.getFile().exists()) {
                ce.getFile().setLastModified(System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reaper() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.m_reaperRunning) {
                return;
            }
            this.m_reaperRunning = true;
        }
        try {
            do {
                this.reapOnce();
            } while (this.m_currentFileSize >= this.m_maxFileSize);
            return;
        }
        catch (Exception x) {
            System.out.println("FileCache: reaper got exception " + x);
            x.printStackTrace();
        }
        finally {
            FileCache fileCache2 = this;
            synchronized (fileCache2) {
                this.m_reaperRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reapOnce() throws Exception {
        ArrayList<ReapEntry> reaplist = new ArrayList<ReapEntry>(5000);
        this.m_currentFileSize = 0L;
        StringBuilder sb = new StringBuilder(128);
        this.appendReapList(this.m_cacheRoot, reaplist, sb);
        int reapix = 0;
        while (this.m_currentFileSize >= this.m_maxFileSize && reapix < reaplist.size()) {
            ReapEntry re = (ReapEntry)reaplist.get(reapix++);
            FileCache fileCache = this;
            synchronized (fileCache) {
                if (!this.inuse(re.m_key)) {
                    this.m_currentFileSize -= re.m_file.length();
                    re.m_file.delete();
                }
            }
        }
    }

    private void appendReapList(File dir, List<ReapEntry> reaplist, StringBuilder sb) {
        File[] far;
        int len = sb.length();
        for (File f : far = dir.listFiles()) {
            sb.setLength(len);
            if (len > 0) {
                sb.append('/');
            }
            sb.append(f.getName());
            if (f.isDirectory()) {
                this.appendReapList(f, reaplist, sb);
                continue;
            }
            this.m_currentFileSize += f.length();
            String key = sb.toString();
            if (this.inuse(key)) continue;
            long lm = f.lastModified();
            if (reaplist.size() >= 5000) {
                reaplist.remove(reaplist.size() - 1);
            }
            this.insertReapEntry(reaplist, new ReapEntry(f, sb.toString(), lm));
        }
    }

    private void insertReapEntry(List<ReapEntry> reaplist, ReapEntry reapentry) {
        int ix = Collections.binarySearch(reaplist, reapentry, C_COMP);
        if (ix < 0) {
            ix = -(ix + 1);
        }
        reaplist.add(ix, reapentry);
    }

    public synchronized long getCurrentFileSize() {
        return this.m_currentFileSize;
    }

    private static class ReapEntry {
        public File m_file;
        public String m_key;
        public long m_modified;

        public ReapEntry(File file, String key, long modified) {
            this.m_file = file;
            this.m_key = key;
            this.m_modified = modified;
        }
    }
}

