/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.caches.images.CachedImageFragment;

class CacheChange {
    private List<CachedImageFragment> m_usedFragmentList = new ArrayList<CachedImageFragment>();
    private List<CachedImageFragment> m_deletedFragmentList = new ArrayList<CachedImageFragment>();

    CacheChange() {
    }

    public void addUsedFragment(@Nonnull CachedImageFragment ii) {
        if (ii == null) {
            throw new IllegalArgumentException("Cannot pass null");
        }
        if (this.m_deletedFragmentList.contains(ii)) {
            throw new IllegalStateException("Trying to use an image that is marked as deleted: " + ii);
        }
        this.m_usedFragmentList.add(ii);
    }

    public void addDeletedFragment(@Nonnull CachedImageFragment ii) {
        if (ii == null) {
            throw new IllegalArgumentException("Cannot pass null");
        }
        this.m_usedFragmentList.remove(ii);
        this.m_deletedFragmentList.add(ii);
    }

    @Nonnull
    public List<CachedImageFragment> getUsedFragmentList() {
        return this.m_usedFragmentList;
    }

    @Nonnull
    public List<CachedImageFragment> getDeletedFragmentList() {
        return this.m_deletedFragmentList;
    }
}

