/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import java.io.File;
import javax.annotation.concurrent.GuardedBy;
import to.etc.domui.caches.filecache.FileCacheRef;
import to.etc.domui.caches.images.ImageCache;
import to.etc.domui.caches.images.ImageRoot;
import to.etc.domui.caches.images.InstanceCacheState;

class CachedImageFragment {
    private final ImageRoot m_imageRoot;
    private final String m_permutation;
    @GuardedBy(value="cache()")
    CachedImageFragment m_lruPrev;
    @GuardedBy(value="cache()")
    CachedImageFragment m_lruNext;
    @GuardedBy(value="cache()")
    InstanceCacheState m_cacheState = InstanceCacheState.NONE;
    @GuardedBy(value="getRoot()")
    private long m_memoryCacheSize;
    private FileCacheRef m_fileRef;

    CachedImageFragment(ImageRoot root, String perm, long sourceVersionLong, int memorysize, FileCacheRef ref) {
        this.m_imageRoot = root;
        this.m_permutation = perm;
        this.m_memoryCacheSize = memorysize;
        this.m_fileRef = ref;
    }

    final ImageRoot getRoot() {
        return this.m_imageRoot;
    }

    public final String getPermutation() {
        return this.m_permutation;
    }

    public final boolean isOriginal() {
        return this.m_permutation.length() == 0;
    }

    public final ImageCache cache() {
        return this.getRoot().getCache();
    }

    public long getMemoryCacheSize() {
        return this.m_memoryCacheSize;
    }

    public final File getFile() {
        return this.m_fileRef.getFile();
    }

    public final FileCacheRef getFileRef() {
        return this.m_fileRef;
    }
}

