/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.caches.FileImageRetriever;
import to.etc.domui.caches.filecache.FileCache;
import to.etc.domui.caches.filecache.FileCacheRef;
import to.etc.domui.caches.images.CachedImageData;
import to.etc.domui.caches.images.CachedImageFragment;
import to.etc.domui.caches.images.CachedImageInfo;
import to.etc.domui.caches.images.FileImageSource;
import to.etc.domui.caches.images.FullImage;
import to.etc.domui.caches.images.IImageStreamSource;
import to.etc.domui.caches.images.ImageKey;
import to.etc.domui.caches.images.ImageRoot;
import to.etc.domui.caches.images.ImageTask;
import to.etc.domui.caches.images.InstanceCacheState;
import to.etc.domui.caches.images.MemoryImageSource;
import to.etc.domui.util.images.IImageRetriever;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.machines.ImageInfo;

public class ImageCache {
    private static ImageCache m_instance;
    private FileCache m_fileCache;
    private long m_maxMemorySize = 0x2000000L;
    private long m_currentMemorySize;
    private int m_memoryFenceSize = 0x500000;
    private Map<String, IImageRetriever> m_factoryMap = new HashMap<String, IImageRetriever>();
    private Map<ImageKey, ImageRoot> m_cacheMap = new HashMap<ImageKey, ImageRoot>();
    private CachedImageFragment m_lruFirst;
    private CachedImageFragment m_lruLast;
    private static final ISpecTask C_GETORIGINALDATA;
    private static final ISpecTask C_GETORIGINALINFO;
    private static final ISpecTask C_GETCONVERTEDDATA;
    private static final ISpecTask C_GETCONVERTEDINFO;
    private static final ISpecTask C_GETFULLINFO;

    private ImageCache(long maxsize, long maxfilesize, File cachedir) {
        this.m_fileCache = new FileCache(cachedir, maxfilesize);
        this.m_maxMemorySize = maxsize;
    }

    public static synchronized ImageCache getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("The image cache has not been initialized. Call ImageCache.initialize() before using the thing.");
        }
        return m_instance;
    }

    public static synchronized void initialize(long maxsize, long maxfilesize, File cacheDir) throws Exception {
        m_instance = new ImageCache(maxsize, maxfilesize, cacheDir);
        m_instance.init();
    }

    private void init() throws Exception {
        this.m_fileCache.initialize();
        this.addRetriever(new FileImageRetriever());
    }

    public synchronized void addRetriever(IImageRetriever r) {
        IImageRetriever old = this.m_factoryMap.put(r.getRetrieverKey(), r);
        if (null != old) {
            throw new IllegalStateException("Duplicate image factory key: " + r.getRetrieverKey() + " for " + r + " and " + old);
        }
    }

    public synchronized IImageRetriever findRetriever(String key) {
        return this.m_factoryMap.get(key);
    }

    public ImageKey createImageKey(String retrieverkey, String instancekey) {
        IImageRetriever ir = this.findRetriever(retrieverkey);
        if (ir == null) {
            return null;
        }
        return new ImageKey(ir, instancekey);
    }

    int getMemoryFence() {
        return this.m_memoryFenceSize;
    }

    FileCache getFileCache() {
        return this.m_fileCache;
    }

    FileCacheRef getFileRef(String path) {
        return this.getFileCache().getFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private ImageTask getImageTask(ImageKey key) throws Exception {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            ImageRoot r = this.m_cacheMap.get(key);
            if (r == null) {
                r = new ImageRoot(this, key);
                this.m_cacheMap.put(key, r);
                r.m_cacheUseCount = 1;
            }
            ImageTask task = new ImageTask(key, r);
            return task;
        }
    }

    static void d(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeTask(ImageKey key, ISpecTask t, Object args) throws Exception {
        ImageTask it = this.getImageTask(key);
        try {
            ImageRoot imageRoot = it.getRoot();
            synchronized (imageRoot) {
                Object object = t.executeTask(it, args);
                return object;
            }
        }
        finally {
            try {
                it.close();
            }
            catch (Exception exception) {}
            this.updateCacheDetails(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheDetails(ImageTask it) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            for (CachedImageFragment cif : it.getDeletedFragmentList()) {
                this.unlink(cif);
                --cif.getRoot().m_cacheUseCount;
            }
            for (CachedImageFragment cif : it.getUsedFragmentList()) {
                this.registerAndLink(cif);
            }
            if (it.getRoot().m_cacheUseCount == 0) {
                this.m_cacheMap.remove(it.getRoot().getKey());
            }
        }
    }

    static IImageStreamSource convert(CachedImageData cid) {
        if (cid.getBuffers() != null) {
            return new MemoryImageSource(cid);
        }
        return new FileImageSource(cid);
    }

    public IImageStreamSource getOriginalData(ImageKey k) throws Exception {
        CachedImageData cid = (CachedImageData)this.executeTask(k, C_GETORIGINALDATA, null);
        return ImageCache.convert(cid);
    }

    public ImageInfo getOriginalInfo(ImageKey k) throws Exception {
        return ((CachedImageInfo)this.executeTask(k, C_GETORIGINALINFO, null)).getImageInfo();
    }

    public IImageStreamSource getImageData(ImageKey k, List<IImageConversionSpecifier> convlist) throws Exception {
        CachedImageData cid = (CachedImageData)this.executeTask(k, C_GETCONVERTEDDATA, convlist);
        return ImageCache.convert(cid);
    }

    public ImageInfo getImageInfo(ImageKey k, List<IImageConversionSpecifier> convlist) throws Exception {
        CachedImageInfo cid = (CachedImageInfo)this.executeTask(k, C_GETCONVERTEDINFO, convlist);
        return cid.getImageInfo();
    }

    public FullImage getFullImage(ImageKey k, List<IImageConversionSpecifier> convlist) throws Exception {
        return (FullImage)this.executeTask(k, C_GETFULLINFO, convlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAndLink(CachedImageFragment ii) {
        ArrayList<CachedImageFragment> dellist = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (ii.m_cacheState != InstanceCacheState.NONE) {
                return;
            }
            this.link(ii);
            this.m_currentMemorySize += ii.getMemoryCacheSize();
            ii.m_cacheState = InstanceCacheState.LINKED;
            if (this.m_currentMemorySize <= this.m_maxMemorySize) {
                return;
            }
            dellist = new ArrayList<CachedImageFragment>();
            int count = 0;
            long size = 0L;
            while (this.m_lruLast != this.m_lruFirst && this.m_currentMemorySize > this.m_maxMemorySize) {
                CachedImageFragment itd = this.m_lruLast;
                this.unlink(itd);
                dellist.add(itd);
                this.m_currentMemorySize -= itd.getMemoryCacheSize();
                size += itd.getMemoryCacheSize();
                ++count;
                ImageRoot ir = itd.getRoot();
                if (ir.m_cacheUseCount <= 0 || --ir.m_cacheUseCount != 0) continue;
                this.m_cacheMap.remove(ir.getKey());
            }
            System.out.println("ImageCache: reaped " + count + " image instances totalling " + size + " bytes");
        }
        for (CachedImageFragment cif : dellist) {
            cif.getRoot().lruInstanceDeleted(cif);
        }
    }

    public synchronized long getUsedMemory() {
        return this.m_currentMemorySize;
    }

    public long getUsedFilespace() {
        return this.m_fileCache.getCurrentFileSize();
    }

    private void link(CachedImageFragment e) {
        this.unlink(e);
        if (this.m_lruFirst == null) {
            this.m_lruFirst = e;
            this.m_lruLast = e;
            e.m_lruNext = e;
            e.m_lruPrev = e;
            return;
        }
        e.m_lruPrev = this.m_lruFirst;
        e.m_lruNext = this.m_lruLast;
        this.m_lruLast.m_lruPrev = e;
        this.m_lruFirst.m_lruNext = e;
        this.m_lruFirst = e;
    }

    private void unlink(CachedImageFragment e) {
        if (e.m_lruNext == null) {
            return;
        }
        if (e.m_lruNext == e.m_lruPrev) {
            this.m_lruFirst = null;
            this.m_lruLast = null;
            e.m_lruNext = null;
            e.m_lruPrev = null;
            return;
        }
        if (this.m_lruFirst == e) {
            this.m_lruFirst = e.m_lruPrev;
        }
        if (this.m_lruLast == e) {
            this.m_lruLast = e.m_lruNext;
        }
        e.m_lruPrev.m_lruNext = e.m_lruNext;
        e.m_lruNext.m_lruPrev = e.m_lruPrev;
        e.m_lruPrev = null;
        e.m_lruNext = null;
    }

    static {
        C_GETORIGINALDATA = new ISpecTask(){

            @Override
            public Object executeTask(ImageTask task, Object args) throws Exception {
                return task.getOriginalData();
            }
        };
        C_GETORIGINALINFO = new ISpecTask(){

            @Override
            public Object executeTask(ImageTask task, Object args) throws Exception {
                return task.getOriginalInfo();
            }
        };
        C_GETCONVERTEDDATA = new ISpecTask(){

            @Override
            public Object executeTask(ImageTask task, Object args) throws Exception {
                return task.getImageData((List)args);
            }
        };
        C_GETCONVERTEDINFO = new ISpecTask(){

            @Override
            public Object executeTask(ImageTask task, Object args) throws Exception {
                return task.getImageInfo((List)args);
            }
        };
        C_GETFULLINFO = new ISpecTask(){

            @Override
            public Object executeTask(ImageTask task, Object args) throws Exception {
                return task.getFullImage((List)args);
            }
        };
    }

    private static interface ISpecTask {
        public Object executeTask(ImageTask var1, Object var2) throws Exception;
    }
}

