/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import javax.annotation.Nonnull;
import to.etc.domui.util.images.IImageRetriever;

public final class ImageKey {
    private IImageRetriever m_retriever;
    private String m_instanceKey;

    public ImageKey(@Nonnull IImageRetriever retriever, @Nonnull String instanceKey) {
        if (retriever == null || instanceKey == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.m_retriever = retriever;
        this.m_instanceKey = instanceKey;
        int i = instanceKey.length();
        while (--i >= 0) {
            char c = instanceKey.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '$' || c == '_' || c == '-') continue;
            throw new IllegalArgumentException("The image key '" + instanceKey + "' contains invalid character(s): " + c + ". Allowed are letters, digits, -$_");
        }
    }

    @Nonnull
    public IImageRetriever getRetriever() {
        return this.m_retriever;
    }

    @Nonnull
    public String getInstanceKey() {
        return this.m_instanceKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_instanceKey.hashCode();
        result = 31 * result + this.m_retriever.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageKey o = (ImageKey)obj;
        if (!this.m_instanceKey.equals(o.m_instanceKey)) {
            return false;
        }
        return this.m_retriever == o.m_retriever;
    }
}

