/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import to.etc.domui.caches.images.CacheChange;
import to.etc.domui.caches.images.CachedImageData;
import to.etc.domui.caches.images.CachedImageFragment;
import to.etc.domui.caches.images.CachedImageInfo;
import to.etc.domui.caches.images.ImageCache;
import to.etc.domui.caches.images.ImageKey;

final class ImageRoot {
    @Nonnull
    private ImageCache m_cache;
    @GuardedBy(value="getCache()")
    int m_cacheUseCount;
    @Nonnull
    private ImageKey m_imageKey;
    private long m_tsLastCheck;
    private long m_versionLong;
    @GuardedBy(value="this")
    private List<CachedImageData> m_dataList = new ArrayList<CachedImageData>();
    @GuardedBy(value="this")
    private List<CachedImageInfo> m_infoList = new ArrayList<CachedImageInfo>();

    ImageRoot(@Nonnull ImageCache ic, @Nonnull ImageKey key) {
        if (ic == null || key == null) {
            throw new IllegalArgumentException("Args cannot be null");
        }
        this.m_cache = ic;
        this.m_imageKey = key;
    }

    @Nonnull
    public ImageKey getKey() {
        return this.m_imageKey;
    }

    @GuardedBy(value="this")
    synchronized long getTSLastCheck() {
        return this.m_tsLastCheck;
    }

    @GuardedBy(value="this")
    synchronized void setTSLastCheck(long ts) {
        this.m_tsLastCheck = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CachedImageData findOriginalData() {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            for (CachedImageData ii : this.m_dataList) {
                if (ii.getPermutation().length() != 0) continue;
                return ii;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CachedImageInfo findOriginalInfo() {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            for (CachedImageInfo ii : this.m_infoList) {
                if (ii.getPermutation().length() != 0) continue;
                return ii;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CachedImageData findPermutationData(String perm) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            for (CachedImageData ii : this.m_dataList) {
                if (!perm.equals(ii.getPermutation())) continue;
                return ii;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedImageInfo findPermutationInfo(String perm) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            for (CachedImageInfo ii : this.m_infoList) {
                if (!perm.equals(ii.getPermutation())) continue;
                return ii;
            }
            return null;
        }
    }

    @Nonnull
    final ImageCache getCache() {
        return this.m_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInstance(CachedImageData id) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            this.m_dataList.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInstance(CachedImageInfo id) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            this.m_infoList.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unregisterInstance(CachedImageData ii) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            this.m_dataList.remove(ii);
            return this.m_dataList.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unregisterInstance(CachedImageInfo ii) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            this.m_infoList.remove(ii);
            return this.m_infoList.size() == 0;
        }
    }

    @GuardedBy(value="this")
    synchronized void checkVersionLong(CacheChange cc, long currentversion) {
        if (this.m_versionLong == currentversion) {
            return;
        }
        this.m_versionLong = currentversion;
        List<CachedImageData> old = this.m_dataList;
        this.m_dataList = new ArrayList<CachedImageData>();
        for (CachedImageData ii : old) {
            try {
                cc.addDeletedFragment(ii);
            }
            catch (Exception x) {
                System.err.println("Exception while release()ing " + ii + ": " + x);
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lruInstanceDeleted(CachedImageFragment cif) {
        ImageRoot imageRoot = this;
        synchronized (imageRoot) {
            boolean deleted = cif instanceof CachedImageData ? this.m_dataList.remove(cif) : this.m_infoList.remove(cif);
            if (!deleted) {
                return;
            }
            if (cif.getFileRef() != null) {
                cif.getFileRef().close();
            }
        }
    }
}

