/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.caches.images;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import to.etc.domui.caches.filecache.FileCacheRef;
import to.etc.domui.caches.images.CacheChange;
import to.etc.domui.caches.images.CachedImageData;
import to.etc.domui.caches.images.CachedImageInfo;
import to.etc.domui.caches.images.FullImage;
import to.etc.domui.caches.images.ImageCache;
import to.etc.domui.caches.images.ImageKey;
import to.etc.domui.caches.images.ImageRoot;
import to.etc.domui.util.images.IImageReference;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.converters.ImageConverterHelper;
import to.etc.domui.util.images.converters.ImageSpec;
import to.etc.domui.util.images.machines.ImageInfo;
import to.etc.domui.util.images.machines.ImageManipulator;
import to.etc.util.FileTool;

@SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="FindBugs definition is wrong for mkdirs, and delete() may fail in code here")
public class ImageTask
extends CacheChange {
    private ImageRoot m_root;
    private ImageKey m_key;
    private IImageReference m_imageSource;
    @GuardedBy(value="getRoot()")
    private boolean m_currentVersionGotten;
    @GuardedBy(value="getRoot()")
    private long m_currentVersionLong;
    @GuardedBy(value="getRoot()")
    private boolean m_outdatedChecked;

    ImageTask(ImageKey key, ImageRoot root) {
        this.m_key = key;
        this.m_root = root;
    }

    public ImageKey getKey() {
        if (this.m_key == null) {
            throw new IllegalStateException("The image task has already been closed");
        }
        return this.m_key;
    }

    public ImageRoot getRoot() {
        return this.m_root;
    }

    ImageCache cache() {
        return this.getRoot().getCache();
    }

    void close() {
        if (this.m_key == null) {
            return;
        }
        try {
            if (this.m_imageSource != null) {
                this.m_imageSource.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_imageSource = null;
    }

    IImageReference getImageSource() throws Exception {
        if (this.m_imageSource == null) {
            this.m_imageSource = this.getKey().getRetriever().loadImage(this.getKey().getInstanceKey());
        }
        return this.m_imageSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutdatedVersions() throws Exception {
        ImageRoot imageRoot = this.getRoot();
        synchronized (imageRoot) {
            if (this.m_outdatedChecked) {
                return;
            }
            long dts = this.getKey().getRetriever().getCheckInterval();
            if (dts > 0L) {
                long ct = System.currentTimeMillis();
                if (ct < this.getRoot().getTSLastCheck() + dts) {
                    this.m_outdatedChecked = true;
                    return;
                }
                this.getRoot().setTSLastCheck(ct);
            }
            long versionlong = this.getCurrentVersionLong();
            this.getRoot().checkVersionLong(this, versionlong);
            this.m_outdatedChecked = true;
        }
    }

    protected long getCurrentVersionLong() throws Exception {
        if (!this.m_currentVersionGotten) {
            this.m_currentVersionLong = this.getImageSource().getVersionLong();
            this.m_currentVersionGotten = true;
        }
        return this.m_currentVersionLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    CachedImageData getOriginalData() throws Exception {
        CachedImageData cachedImageData;
        FileOutputStream os;
        InputStream is;
        block6: {
            this.removeOutdatedVersions();
            CachedImageData cid = this.getRoot().findOriginalData();
            if (cid != null) {
                this.addUsedFragment(cid);
                return cid;
            }
            long cts = this.getCurrentVersionLong();
            String cachename = this.getKey().getRetriever().getRetrieverKey() + "/" + this.getKey().getInstanceKey() + "-" + Long.toHexString(cts) + ".data";
            FileCacheRef ref = this.cache().getFileRef(cachename);
            is = null;
            os = null;
            boolean ok = false;
            try {
                int len = 0;
                if (!ref.getFile().exists() || ref.getFile().length() == 0L) {
                    is = this.getImageSource().getInputStream();
                    os = new FileOutputStream(ref.getFile());
                    FileTool.copyFile((OutputStream)os, (InputStream)is);
                    ((OutputStream)os).close();
                    os = null;
                    is.close();
                    is = null;
                }
                len = (int)ref.getFile().length();
                int memload = 64;
                byte[][] bufs = null;
                if (len < this.cache().getMemoryFence()) {
                    bufs = FileTool.loadByteBuffers((File)ref.getFile());
                    memload += len;
                }
                CachedImageData ii = new CachedImageData(this.getRoot(), "", cts, ref, len, bufs, memload);
                this.addUsedFragment(ii);
                this.getRoot().registerInstance(ii);
                ok = true;
                cachedImageData = ii;
                if (ok) break block6;
                ref.getFile().delete();
            }
            catch (Throwable throwable) {
                if (!ok) {
                    ref.getFile().delete();
                    ref.close();
                }
                FileTool.closeAll((Object[])new Object[]{is, os});
                throw throwable;
            }
            ref.close();
        }
        FileTool.closeAll((Object[])new Object[]{is, os});
        return cachedImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CachedImageInfo getOriginalInfo() throws Exception {
        CachedImageInfo cachedImageInfo;
        Object os;
        Object is;
        block8: {
            this.removeOutdatedVersions();
            CachedImageInfo cii = this.getRoot().findOriginalInfo();
            if (cii != null) {
                this.addUsedFragment(cii);
                return cii;
            }
            long cts = this.getCurrentVersionLong();
            String cachename = this.getKey().getRetriever().getRetrieverKey() + "/" + this.getKey().getInstanceKey() + "-" + Long.toHexString(cts) + ".meta";
            FileCacheRef ref = this.cache().getFileRef(cachename);
            is = null;
            os = null;
            boolean ok = false;
            try {
                ImageInfo oid = null;
                try {
                    oid = (ImageInfo)FileTool.loadSerialized((File)ref.getFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (oid == null) {
                    CachedImageData cid = this.getOriginalData();
                    oid = ImageManipulator.identify(cid.getFile());
                    if (oid.getMime() == null) {
                        oid.setMime(this.getImageSource().getMimeType());
                    }
                    FileTool.saveSerialized((File)ref.getFile(), (Serializable)oid);
                }
                CachedImageInfo ii = this.addNewInfo("", cts, ref, oid);
                ok = true;
                cachedImageInfo = ii;
                if (ok) break block8;
                ref.getFile().delete();
            }
            catch (Throwable throwable) {
                if (!ok) {
                    ref.getFile().delete();
                    ref.close();
                }
                FileTool.closeAll((Object[])new Object[]{is, os});
                throw throwable;
            }
            ref.close();
        }
        FileTool.closeAll((Object[])new Object[]{is, os});
        return cachedImageInfo;
    }

    private CachedImageInfo addNewInfo(String perm, long cts, FileCacheRef ref, ImageInfo info) {
        int memload = 64 + info.getPageCount() * 32;
        CachedImageInfo ii = new CachedImageInfo(this.getRoot(), perm, cts, ref, info, memload);
        this.addUsedFragment(ii);
        this.getRoot().registerInstance(ii);
        return ii;
    }

    private static List<IImageConversionSpecifier> convertArray(IImageConversionSpecifier[] conversions) {
        ArrayList<IImageConversionSpecifier> l = new ArrayList<IImageConversionSpecifier>();
        for (IImageConversionSpecifier s : conversions) {
            l.add(s);
        }
        return l;
    }

    private static String getPermutationKey(List<IImageConversionSpecifier> conversions) {
        StringBuilder sb = new StringBuilder(128);
        for (IImageConversionSpecifier ic : conversions) {
            sb.append(ic.getConversionKey());
        }
        return sb.toString();
    }

    public CachedImageData getImageData(IImageConversionSpecifier[] conversions) throws Exception {
        return this.getImageData(ImageTask.convertArray(conversions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedImageData getImageData(List<IImageConversionSpecifier> conversions) throws Exception {
        CachedImageData cachedImageData;
        Object os;
        Object is;
        block11: {
            if (conversions == null || conversions.size() == 0) {
                return this.getOriginalData();
            }
            this.removeOutdatedVersions();
            String perm = ImageTask.getPermutationKey(conversions);
            CachedImageData cid = this.getRoot().findPermutationData(perm);
            if (cid != null) {
                this.addUsedFragment(cid);
                return cid;
            }
            long cts = this.getCurrentVersionLong();
            String datacachename = this.getKey().getRetriever().getRetrieverKey() + "/" + this.getKey().getInstanceKey() + "-" + perm + "-" + Long.toHexString(cts) + ".data";
            String infocachename = this.getKey().getRetriever().getRetrieverKey() + "/" + this.getKey().getInstanceKey() + "-" + perm + "-" + Long.toHexString(cts) + ".info";
            FileCacheRef dataref = this.cache().getFileRef(datacachename);
            FileCacheRef inforef = this.cache().getFileRef(infocachename);
            is = null;
            os = null;
            boolean ok = false;
            try {
                CachedImageInfo oldci;
                ImageInfo info = null;
                if (inforef.getFile().exists() && inforef.getFile().length() > 0L) {
                    try {
                        info = (ImageInfo)FileTool.loadSerialized((File)inforef.getFile());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int len = 0;
                if (!dataref.getFile().exists() || dataref.getFile().length() == 0L || info == null) {
                    info = this.generatePermutation(dataref, conversions);
                    FileTool.saveSerialized((File)inforef.getFile(), (Serializable)info);
                }
                if ((oldci = this.getRoot().findPermutationInfo(perm)) != null) {
                    this.addDeletedFragment(oldci);
                    this.getRoot().unregisterInstance(oldci);
                }
                this.addNewInfo(perm, cts, inforef, info);
                len = (int)dataref.getFile().length();
                int memload = 64;
                byte[][] bufs = null;
                if (len < this.cache().getMemoryFence()) {
                    bufs = FileTool.loadByteBuffers((File)dataref.getFile());
                    memload += len;
                }
                CachedImageData ii = new CachedImageData(this.getRoot(), perm, cts, dataref, len, bufs, memload);
                this.addUsedFragment(ii);
                this.getRoot().registerInstance(ii);
                ok = true;
                cachedImageData = ii;
                if (ok) break block11;
                dataref.getFile().delete();
            }
            catch (Throwable throwable) {
                if (!ok) {
                    dataref.getFile().delete();
                    dataref.close();
                }
                FileTool.closeAll((Object[])new Object[]{is, os});
                throw throwable;
            }
            dataref.close();
        }
        FileTool.closeAll((Object[])new Object[]{is, os});
        return cachedImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageInfo generatePermutation(FileCacheRef targetref, List<IImageConversionSpecifier> conversions) throws Exception {
        CachedImageData origd = this.getOriginalData();
        CachedImageInfo origi = this.getOriginalInfo();
        ImageConverterHelper ich = new ImageConverterHelper();
        try {
            ImageSpec sis = new ImageSpec(origd.getFile(), origi.getImageInfo());
            ich.executeConversionChain(sis, new ArrayList<IImageConversionSpecifier>(conversions));
            FileTool.copyFile((File)targetref.getFile(), (File)ich.getTarget().getSource());
            ImageInfo imageInfo = ich.getTarget().getInfo();
            return imageInfo;
        }
        finally {
            ich.destroy();
        }
    }

    public CachedImageInfo getImageInfo(List<IImageConversionSpecifier> conversions) throws Exception {
        if (conversions == null || conversions.size() == 0) {
            return this.getOriginalInfo();
        }
        this.removeOutdatedVersions();
        String perm = ImageTask.getPermutationKey(conversions);
        CachedImageInfo cii = this.getRoot().findPermutationInfo(perm);
        if (cii != null) {
            this.addUsedFragment(cii);
            return cii;
        }
        this.getImageData(conversions);
        cii = this.getRoot().findPermutationInfo(perm);
        if (cii == null) {
            throw new IllegalStateException("? Image transformation did not create an ImageInfo instance in the cache?");
        }
        return cii;
    }

    public Object getFullImage(List<IImageConversionSpecifier> conversions) throws Exception {
        this.removeOutdatedVersions();
        CachedImageData cid = this.getImageData(conversions);
        CachedImageInfo cii = this.getImageInfo(conversions);
        return new FullImage(ImageCache.convert(cid), cii.getImageInfo());
    }
}

