/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.agenda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import to.etc.domui.component.agenda.BasicScheduleWorkHour;
import to.etc.domui.component.agenda.ScheduleHoliday;
import to.etc.domui.component.agenda.ScheduleItem;
import to.etc.domui.component.agenda.ScheduleModel;
import to.etc.domui.component.agenda.ScheduleModelChangedListener;
import to.etc.domui.component.agenda.ScheduleWorkHour;

public class BasicScheduleModel<T extends ScheduleItem>
implements ScheduleModel<T> {
    private List<ScheduleHoliday> m_holidays = new ArrayList<ScheduleHoliday>();
    private List<T> m_items = new ArrayList<T>();
    private List<ScheduleWorkHour> m_workHours = new ArrayList<ScheduleWorkHour>();
    private List<ScheduleModelChangedListener<T>> m_listeners = Collections.EMPTY_LIST;

    @Override
    public List<ScheduleHoliday> getScheduleHolidays(Date start, Date end) throws Exception {
        ArrayList<ScheduleHoliday> l = new ArrayList<ScheduleHoliday>();
        for (ScheduleHoliday h : this.m_holidays) {
            if (h.getDate().getTime() < start.getTime() || h.getDate().getTime() >= end.getTime()) continue;
            l.add(h);
        }
        return l;
    }

    @Override
    public List<T> getScheduleItems(Date start, Date end) throws Exception {
        ArrayList<ScheduleItem> l = new ArrayList<ScheduleItem>();
        for (ScheduleItem h : this.m_items) {
            if (h.getEnd().getTime() < start.getTime() || h.getStart().getTime() >= end.getTime()) continue;
            l.add(h);
        }
        return this.m_items;
    }

    @Override
    public List<ScheduleWorkHour> getScheduleWorkHours(Date start, Date end) throws Exception {
        return this.m_workHours;
    }

    public void addHoliday(ScheduleHoliday h) throws Exception {
        this.m_holidays.add(h);
        this.fireModelChanged();
    }

    public void addItem(T i) throws Exception {
        this.m_items.add(i);
        this.fireItemAdded(i);
    }

    public void deleteItem(T i) throws Exception {
        if (this.m_items.remove(i)) {
            this.fireItemDeleted(i);
        }
    }

    public void changeItem(T i) throws Exception {
        this.fireItemChanged(i);
    }

    public void addWorkHour(ScheduleWorkHour h) throws Exception {
        this.m_workHours.add(h);
        this.fireModelChanged();
    }

    public void addWorkHour(Date start, Date end) throws Exception {
        this.m_workHours.add(new BasicScheduleWorkHour(start, end));
        this.fireModelChanged();
    }

    @Override
    public synchronized void addScheduleListener(ScheduleModelChangedListener<T> chl) {
        if (this.m_listeners.contains(chl)) {
            return;
        }
        this.m_listeners = new ArrayList<ScheduleModelChangedListener<T>>(this.m_listeners);
        this.m_listeners.add(chl);
    }

    @Override
    public synchronized void removeScheduleListener(ScheduleModelChangedListener<T> chl) {
        this.m_listeners = new ArrayList<ScheduleModelChangedListener<T>>(this.m_listeners);
        this.m_listeners.remove(chl);
    }

    protected synchronized List<ScheduleModelChangedListener<T>> getListeners() {
        return this.m_listeners;
    }

    protected void fireModelChanged() throws Exception {
        List<ScheduleModelChangedListener<T>> list = this.getListeners();
        int i = list.size();
        while (--i >= 0) {
            list.get(i).scheduleModelChanged();
        }
    }

    protected void fireItemAdded(T si) throws Exception {
        List<ScheduleModelChangedListener<T>> list = this.getListeners();
        int i = list.size();
        while (--i >= 0) {
            list.get(i).scheduleItemAdded(si);
        }
    }

    protected void fireItemDeleted(T si) throws Exception {
        List<ScheduleModelChangedListener<T>> list = this.getListeners();
        int i = list.size();
        while (--i >= 0) {
            list.get(i).scheduleItemDeleted(si);
        }
    }

    protected void fireItemChanged(T si) throws Exception {
        List<ScheduleModelChangedListener<T>> list = this.getListeners();
        int i = list.size();
        while (--i >= 0) {
            list.get(i).scheduleItemChanged(si);
        }
    }
}

