/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.agenda;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nonnull;
import to.etc.domui.component.agenda.IDayClicked;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.util.DateUtil;
import to.etc.webapp.nls.NlsContext;

public class MonthPanel
extends Div {
    private Date m_date;
    private int m_firstDay = 2;
    private int m_month;
    private IDayClicked m_dayClicked;
    private Date m_firstDayDate;
    private IClicked<TD> m_clickHandler;
    private TBody m_body;

    @Override
    public void createContent() throws Exception {
        TBody b;
        this.setCssClass("ui-mp");
        this.getDate();
        Calendar cal = Calendar.getInstance(NlsContext.getLocale());
        cal.setTime(this.m_firstDayDate);
        Table t = new Table();
        this.add(t);
        t.setCssClass("ui-mp");
        t.setCellPadding("0");
        t.setCellSpacing("0");
        this.m_body = b = t.getBody();
        this.createTopRow(b);
        if (this.getDayClicked() != null && this.m_clickHandler == null) {
            this.m_clickHandler = new IClicked<TD>(){

                @Override
                public void clicked(@Nonnull TD bx) throws Exception {
                    MonthPanel.this.handleClick(bx);
                }
            };
        }
        do {
            this.createWeekRow(b, cal);
        } while (cal.get(2) == this.m_month);
    }

    void handleClick(TD cell) throws Exception {
        if (null == this.getDayClicked()) {
            return;
        }
        TR row = cell.getParent(TR.class);
        int cellix = row.findChildIndex(cell);
        if (cellix <= 0) {
            return;
        }
        Date start = (Date)row.getRowData();
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(5, --cellix);
        start = cal.getTime();
        this.getDayClicked().dayClicked(this, start);
    }

    private void createWeekRow(TBody b, Calendar cal) {
        int wd = cal.get(7);
        if (wd != this.m_firstDay) {
            throw new IllegalStateException("Internal logic error");
        }
        TR row = b.addRow();
        row.setRowData(cal.getTime());
        TD td = b.addCell();
        td.setCssClass("ui-mp-w");
        int wn = cal.get(3);
        td.setText(Integer.toString(wn));
        String cssinm = this.getDayClicked() == null ? "ui-mp-d" : "ui-mp-d ui-mp-ch";
        String cssexm = this.getDayClicked() == null ? "ui-mp-xd" : "ui-mp-xd ui-mp-ch";
        for (int i = 0; i < 7; ++i) {
            td = b.addCell();
            int dn = cal.get(5);
            int mn = cal.get(2);
            td.setText(Integer.toString(dn));
            td.setCssClass(mn == this.m_month ? cssinm : cssexm);
            if (this.getDayClicked() != null) {
                td.setClicked(this.m_clickHandler);
            }
            cal.add(5, 1);
        }
    }

    private void createTopRow(TBody b) {
        DateFormatSymbols dfs = new DateFormatSymbols(NlsContext.getLocale());
        TR tr = b.addRow();
        tr.setCssClass("ui-mp-mn");
        TD td = b.addCell();
        td.setColspan(8);
        td.setText(dfs.getMonths()[this.m_month]);
        tr = b.addRow();
        tr.setCssClass("ui-mp-top");
        td = b.addCell();
        td.setCssClass("ui-mp-e");
        int cday = this.m_firstDay;
        for (int i = 0; i < 7; ++i) {
            String day = dfs.getShortWeekdays()[cday];
            td = b.addCell();
            td.setCssClass("ui-mp-d");
            td.setText(day);
            if (++cday <= 7) continue;
            cday = 1;
        }
    }

    public Date getDate() {
        if (this.m_date == null) {
            this.setDate(new Date());
        }
        return this.m_date;
    }

    public void setDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateUtil.clearTime((Calendar)cal);
        cal.set(5, 1);
        Date then = cal.getTime();
        if (this.m_date != null && then.getTime() == this.m_date.getTime()) {
            return;
        }
        this.m_date = then;
        this.m_month = cal.get(2);
        DateUtil.clearTime((Calendar)cal);
        cal.set(5, 1);
        int cnt = 7;
        while (true) {
            if (cnt-- < 0) {
                throw new IllegalStateException("?? Cannot reach weekday=" + this.m_firstDay);
            }
            int weekday = cal.get(7);
            if (weekday == this.m_firstDay) break;
            cal.add(5, -1);
        }
        this.m_firstDayDate = cal.getTime();
        this.forceRebuild();
    }

    public int getFirstDay() {
        return this.m_firstDay;
    }

    public void setFirstDay(int firstDay) {
        if (this.m_firstDay == firstDay) {
            return;
        }
        this.forceRebuild();
        this.m_firstDay = firstDay;
        this.setDate(this.getDate());
    }

    public IDayClicked getDayClicked() {
        return this.m_dayClicked;
    }

    public void setDayClicked(IDayClicked dayClicked) {
        if (dayClicked == null && this.m_dayClicked != null || dayClicked != null && this.m_dayClicked == null) {
            this.forceRebuild();
        }
        this.m_dayClicked = dayClicked;
    }

    public void setMarked(Date dt, String css) throws Exception {
        this.mark(dt, css, true);
    }

    public void setUnmarked(Date dt, String css) throws Exception {
        this.mark(dt, css, false);
    }

    public void unmarkAll(String css) {
        if (this.m_body == null) {
            return;
        }
        for (NodeBase row : this.m_body) {
            TR tr = (TR)row;
            for (NodeBase b2 : tr) {
                TD td = (TD)b2;
                td.removeCssClass(css);
            }
        }
    }

    private void mark(Date dt, String css, boolean on) throws Exception {
        if (dt == null) {
            return;
        }
        if (dt.getTime() < this.m_firstDayDate.getTime()) {
            return;
        }
        if (css == null) {
            css = "mp-ui-mrk";
        }
        this.build();
        for (NodeBase row : this.m_body) {
            TR tr = (TR)row;
            Date rd = (Date)tr.getRowData();
            if (rd == null) continue;
            long ets = rd.getTime() + 604800000L;
            if (dt.getTime() < rd.getTime() || dt.getTime() >= ets) continue;
            int cellix = (int)((dt.getTime() - rd.getTime()) / 86400000L) + 1;
            TD cell = (TD)tr.getChild(cellix);
            if (on) {
                cell.addCssClass(css);
                continue;
            }
            cell.removeCssClass(css);
        }
    }
}

