/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.agenda;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.component.agenda.DefaultScheduleItemRenderer;
import to.etc.domui.component.agenda.INewAppointment;
import to.etc.domui.component.agenda.ScheduleHoliday;
import to.etc.domui.component.agenda.ScheduleItem;
import to.etc.domui.component.agenda.ScheduleMode;
import to.etc.domui.component.agenda.ScheduleModel;
import to.etc.domui.component.agenda.ScheduleModelChangedListener;
import to.etc.domui.component.agenda.ScheduleWorkHour;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.DateUtil;
import to.etc.webapp.nls.NlsContext;

public class WeekAgendaComponent<T extends ScheduleItem>
extends Div
implements ScheduleModelChangedListener<T> {
    private ScheduleModel<T> m_model;
    private ScheduleMode m_mode = ScheduleMode.WORKWEEK;
    private Date m_date;
    private Date m_end;
    private List<ScheduleHoliday> m_holidays;
    private List<ScheduleWorkHour> m_workhours;
    private List<T> m_items;
    private int m_startHour;
    private int m_endHour;
    private NodeContainer m_itemBase;
    private INodeContentRenderer<T> m_itemRenderer;
    private int m_days;
    private Map<String, Div> m_renderMap = new HashMap<String, Div>();
    private INodeContentRenderer<T> m_actualItemRenderer;
    private INewAppointment m_newAppointmentListener;
    private static final long MINS = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private DateFormat m_timef;

    @Override
    public void onForceRebuild() {
        super.onForceRebuild();
        this.m_renderMap.clear();
    }

    private void initDateBounds() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_date);
        DateUtil.clearTime((Calendar)cal);
        switch (this.m_mode) {
            default: {
                throw new IllegalStateException((Object)((Object)this.m_mode) + ": unhandled mode");
            }
            case DAY: {
                this.m_date = cal.getTime();
                this.m_end = DateUtil.tomorrow((Date)this.m_date);
                this.m_days = 1;
                break;
            }
            case WEEK: {
                while (cal.get(7) != 1) {
                    cal.add(5, -1);
                }
                this.m_date = cal.getTime();
                cal.add(5, 7);
                this.m_end = cal.getTime();
                this.m_days = 7;
                break;
            }
            case WORKWEEK: {
                while (cal.get(7) != 2) {
                    cal.add(5, -1);
                }
                this.m_date = cal.getTime();
                cal.add(5, 5);
                this.m_end = cal.getTime();
                this.m_days = 5;
                break;
            }
            case MONTH: {
                cal.set(5, 1);
                this.m_date = cal.getTime();
                cal.add(2, 1);
                this.m_end = cal.getTime();
                this.m_days = 31;
            }
        }
    }

    private void initModel() throws Exception {
        if (this.m_model == null) {
            throw new IllegalStateException("Missing 'model' on WeekAgendaComponent");
        }
        if (this.m_mode == null) {
            this.m_mode = ScheduleMode.DAY;
        }
        if (this.m_date == null) {
            this.setDate(new Date());
        }
        this.m_holidays = this.m_model.getScheduleHolidays(this.m_date, this.m_end);
        this.m_workhours = this.m_model.getScheduleWorkHours(this.m_date, this.m_end);
        this.m_startHour = -1;
        this.m_endHour = -1;
        Calendar cal = Calendar.getInstance();
        for (ScheduleWorkHour h : this.m_workhours) {
            cal.setTime(h.getStart());
            int sh = cal.get(11) * 60 + cal.get(12);
            if (this.m_startHour == -1 || sh < this.m_startHour) {
                this.m_startHour = sh;
            }
            cal.setTime(h.getEnd());
            sh = cal.get(11) * 60 + cal.get(12);
            if (this.m_endHour != -1 && sh <= this.m_endHour) continue;
            this.m_endHour = sh;
        }
        if (this.m_startHour == -1) {
            this.m_startHour = 480;
            this.m_endHour = 1080;
        } else {
            this.m_startHour = this.m_startHour % 60 != 0 ? (this.m_startHour -= this.m_startHour % 60) : (this.m_startHour -= 60);
            this.m_endHour = this.m_endHour % 60 != 0 ? (this.m_endHour += 60 - this.m_endHour % 60) : (this.m_endHour += 60);
        }
        this.m_startHour /= 60;
        this.m_endHour /= 61;
        this.m_items = this.m_model.getScheduleItems(this.m_date, this.m_end);
    }

    private void initBase() {
        Div d = new Div();
        this.m_itemBase = d;
        this.add(d);
        d.setPosition(PositionType.ABSOLUTE);
        d.setTop("0px");
        d.setLeft(0);
        d.setOverflow(Overflow.HIDDEN);
        d.setWidth("100%");
        d.setHeight("500px");
        d.setCssClass("ui-wa-f");
    }

    @Override
    public void createContent() throws Exception {
        this.initModel();
        this.setPosition(PositionType.RELATIVE);
        this.setTop("0px");
        this.setLeft(0);
        this.setOverflow(Overflow.HIDDEN);
        if (this.getWidth() == null) {
            this.setWidth("100%");
        }
        if (this.getHeight() == null) {
            this.setHeight("500px");
        }
        this.setCssClass("ui-wa ui-wa-" + this.m_mode.name());
        this.initBase();
        switch (this.m_mode) {
            default: {
                throw new IllegalStateException((Object)((Object)this.m_mode) + ": mode not implemented yet");
            }
            case DAY: {
                this.renderWeek(1);
                break;
            }
            case WORKWEEK: {
                this.renderWeek(5);
                break;
            }
            case WEEK: {
                this.renderWeek(7);
            }
        }
        this.renderItems();
    }

    public static String renderDate(Date in) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(in);
        StringBuilder sb = new StringBuilder(32);
        sb.append(cal.get(1));
        sb.append(',');
        sb.append(cal.get(2) + 1);
        sb.append(',');
        sb.append(cal.get(5));
        sb.append(',');
        sb.append(cal.get(11));
        sb.append(',');
        sb.append(cal.get(12));
        return sb.toString();
    }

    private void renderWeek(int days) throws Exception {
        Div div = new Div();
        this.add(div);
        this.setSpecialAttribute("startDate", WeekAgendaComponent.renderDate(this.m_date));
        this.setSpecialAttribute("endDate", WeekAgendaComponent.renderDate(this.m_end));
        this.setSpecialAttribute("days", Integer.toString(this.m_days));
        this.setSpecialAttribute("hourstart", Integer.toString(this.m_startHour));
        this.setSpecialAttribute("hourend", Integer.toString(this.m_endHour));
        div.setCssClass("ui-wa-bg");
        Table t = new Table();
        div.add(t);
        t.setCssClass("ui-wa-bgtbl");
        t.setBorder(0);
        t.setCellPadding("0");
        t.setCellSpacing("1");
        t.setTableWidth("100%");
        t.setHeight("100%");
        TBody b = new TBody();
        t.add(b);
        TR tr = new TR();
        b.add(tr);
        tr.setCssClass("ui-wa-hd");
        TD td = new TD();
        tr.add(td);
        td.setCssClass("ui-wa-gt ui-wa-empty");
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.m_date);
        DateFormat df = DateFormat.getDateInstance(2, NlsContext.getLocale());
        for (int day = 0; day < days; ++day) {
            td = new TD();
            tr.add(td);
            td.setValign(TableVAlign.TOP);
            td.setWidth(100 / days + "%");
            Date d = cal.getTime();
            ScheduleHoliday h = this.findHoliday(d.getTime());
            if (h != null && h.getImageURL() != null) {
                Img i = new Img();
                td.add(i);
                i.setBorder(0);
                i.setCssClass("ui-wa-img");
                i.setSrc(h.getImageURL());
            }
            td.add(df.format(d));
            if (h != null) {
                td.add(new BR());
                td.add(h.getHolidayName(NlsContext.getLocale()));
            } else {
                String[] shd = new DateFormatSymbols(NlsContext.getLocale()).getShortWeekdays();
                td.add(new BR());
                td.add(shd[cal.get(7)]);
            }
            cal.add(5, 1);
        }
        for (int hr = this.m_startHour; hr < this.m_endHour; ++hr) {
            int i;
            tr = new TR();
            b.add(tr);
            tr.setCssClass("ui-wa-row");
            td = new TD();
            tr.add(td);
            td.setCssClass("ui-wa-gt");
            td.setRowspan(2);
            Span sp = new Span();
            td.add(sp);
            sp.setCssClass("ui-wa-hour");
            sp.add(Integer.toString(hr));
            sp = new Span();
            td.add(sp);
            sp.setCssClass("ui-wa-min");
            sp.setText("00");
            for (i = 0; i < days; ++i) {
                td = new TD();
                tr.add(td);
                td.setCssClass("ui-wa-cell");
                td.setText("\u00a0");
            }
            tr = new TR();
            b.add(tr);
            tr.setCssClass("ui-wa-row");
            for (i = 0; i < days; ++i) {
                td = new TD();
                tr.add(td);
                td.setCssClass("ui-wa-cell");
                td.setText("\u00a0");
            }
        }
    }

    private ScheduleHoliday findHoliday(long ts) {
        for (ScheduleHoliday h : this.m_holidays) {
            if (h.getDate().getTime() < ts || h.getDate().getTime() >= ts + 86400000L) continue;
            return h;
        }
        return null;
    }

    private void renderItems() throws Exception {
        this.m_renderMap.clear();
        this.m_itemBase.forceRebuild();
        this.m_timef = DateFormat.getTimeInstance(3, NlsContext.getLocale());
        for (ScheduleItem si : this.m_items) {
            this.renderItem(si);
        }
    }

    private void renderItem(T si) throws Exception {
        Div sidiv = new Div();
        this.m_itemBase.add(sidiv);
        this.renderItem(sidiv, si);
    }

    private void renderItem(Div sidiv, T si) throws Exception {
        sidiv.setCssClass("ui-wa-it");
        if (this.m_actualItemRenderer == null) {
            this.m_actualItemRenderer = this.getItemRenderer();
            if (this.m_actualItemRenderer == null) {
                this.m_actualItemRenderer = new DefaultScheduleItemRenderer();
            }
        }
        this.m_actualItemRenderer.renderNodeContent(this, sidiv, si, null);
        sidiv.setSpecialAttribute("startDate", WeekAgendaComponent.renderDate(si.getStart()));
        sidiv.setSpecialAttribute("endDate", WeekAgendaComponent.renderDate(si.getEnd()));
        sidiv.setDisplay(DisplayType.NONE);
        if (null != this.m_renderMap.put(si.getID(), sidiv)) {
            throw new IllegalStateException("Duplicate ID in ScheduleItem: " + si.getID());
        }
    }

    protected boolean inWindow(T si) {
        return si.getStart().getTime() < this.m_end.getTime() && si.getEnd().getTime() > this.m_date.getTime();
    }

    @Override
    public void scheduleItemAdded(T si) throws Exception {
        if (!this.inWindow(si)) {
            return;
        }
        this.renderItem(si);
    }

    @Override
    public void scheduleItemChanged(T si) throws Exception {
        Div d = this.m_renderMap.remove(si.getID());
        if (d == null) {
            return;
        }
        d.removeAllChildren();
        this.renderItem(d, si);
    }

    @Override
    public void scheduleItemDeleted(T si) throws Exception {
        Div d = this.m_renderMap.remove(si.getID());
        if (d == null) {
            return;
        }
        d.remove();
    }

    @Override
    public void scheduleModelChanged() throws Exception {
        this.forceRebuild();
    }

    public DateFormat getDateFormat() {
        if (this.m_timef == null) {
            this.m_timef = DateFormat.getTimeInstance(3, NlsContext.getLocale());
        }
        return this.m_timef;
    }

    public void appendDuration(StringBuilder sb, long duration) {
        long d;
        if (duration < 0L) {
            duration = -duration;
        }
        sb.append(' ');
        String sep = "";
        if (duration >= 86400000L) {
            d = duration / 86400000L;
            sb.append(d);
            sb.append('d');
            sep = " ";
            duration %= 86400000L;
        }
        if (duration >= 3600000L) {
            d = duration / 3600000L;
            sb.append(sep);
            sb.append(d);
            sb.append('h');
            sep = " ";
            duration %= 3600000L;
        }
        if (duration >= 60000L) {
            d = duration / 60000L;
            sb.append(sep);
            sb.append(d);
            sb.append('m');
        }
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("newappt".equals(action)) {
            String s = ctx.getParameter("date");
            if (s == null) {
                throw new IllegalStateException("WeekAgendaComponent: missing date");
            }
            long val = Long.parseLong(s);
            s = ctx.getParameter("duration");
            if (s == null) {
                throw new IllegalStateException("WeekAgendaComponent: missing duration");
            }
            long dur = Long.parseLong(s);
            if (this.getNewAppointmentListener() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(val);
                this.getNewAppointmentListener().newAppointment(cal.getTime(), dur);
            }
        } else {
            super.componentHandleWebAction(ctx, action);
        }
    }

    public ScheduleModel<T> getModel() {
        return this.m_model;
    }

    public void setModel(ScheduleModel<T> model) {
        if (DomUtil.isEqual(model, this.m_model)) {
            return;
        }
        if (this.m_model != null) {
            this.m_model.removeScheduleListener(this);
        }
        this.m_model = model;
        if (this.m_model != null) {
            this.m_model.addScheduleListener(this);
        }
        this.forceRebuild();
    }

    public ScheduleMode getMode() {
        return this.m_mode;
    }

    public void setMode(ScheduleMode mode) {
        if (this.m_mode == mode) {
            return;
        }
        this.m_mode = mode;
        this.initDateBounds();
        this.forceRebuild();
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setDate(Date date) {
        if (DomUtil.isEqual((Object)date, (Object)this.m_date)) {
            return;
        }
        this.m_date = date;
        this.initDateBounds();
        this.forceRebuild();
    }

    public int getDisplayDays() {
        return this.m_days;
    }

    public Date getFirstDate() {
        return this.m_date;
    }

    public Date getLastDate() {
        return this.m_end;
    }

    public INodeContentRenderer<T> getItemRenderer() {
        return this.m_itemRenderer;
    }

    public void setItemRenderer(INodeContentRenderer<T> itemRenderer) {
        this.m_itemRenderer = itemRenderer;
    }

    public INewAppointment getNewAppointmentListener() {
        return this.m_newAppointmentListener;
    }

    public void setNewAppointmentListener(INewAppointment newAppointmentListener) {
        this.m_newAppointmentListener = newAppointmentListener;
    }
}

