/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.binding;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.BindingDefinitionException;
import to.etc.domui.component.binding.BindingFailureException;
import to.etc.domui.component.binding.BindingValuePair;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.component.binding.IBindingConverter;
import to.etc.domui.component.binding.IBindingListener;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IDisplayControl;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.IValueAccessor;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.CodeException;

@DefaultNonNull
public final class ComponentPropertyBinding
implements IBinding {
    @Nonnull
    private final NodeBase m_control;
    @Nonnull
    private final PropertyMetaModel<?> m_controlProperty;
    @Nullable
    private Object m_instance;
    @Nullable
    private IValueAccessor<?> m_instanceProperty;
    @Nullable
    private IBindingListener<?> m_listener;
    @Nullable
    private IBindingConverter<?, ?> m_converter;
    @Nullable
    private Object m_lastValueFromControlAsModelValue;
    @Nullable
    private UIMessage m_bindError;
    private static final Map<Class<?>, Class<?>> BOXINGDISASTER = new HashMap();

    public ComponentPropertyBinding(@Nonnull NodeBase control, @Nonnull String controlProperty) {
        if (control == null) {
            throw new IllegalArgumentException("The control cannot be null.");
        }
        if (controlProperty.contains(".")) {
            throw new ProgrammerErrorException("You cannot bind a Control property dotted path, see https://etc.to/confluence/x/GYA-/");
        }
        this.m_control = control;
        this.m_controlProperty = MetaManager.getPropertyMeta(control.getClass(), controlProperty);
    }

    private void checkAssigned() {
        if (this.m_listener != null || this.m_instance != null) {
            throw new ProgrammerErrorException("This binding is already fully defined. Create a new one.");
        }
    }

    @Nonnull
    public ComponentPropertyBinding convert(@Nullable IBindingConverter<?, ?> converter) {
        this.checkAssigned();
        if (this.m_converter != null) {
            throw new ProgrammerErrorException("This binding already has a converter specified");
        }
        this.m_converter = converter;
        return this;
    }

    public void to(@Nonnull IBindingListener<?> listener) {
        this.checkAssigned();
        if (listener == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.m_listener = listener;
    }

    public <T> void to(@Nonnull T instance, @Nonnull String property) throws Exception {
        if (instance == null || property == null) {
            throw new IllegalArgumentException("The instance in a component bind request CANNOT be null!");
        }
        this.to(instance, MetaManager.getPropertyMeta(instance.getClass(), property));
    }

    public <T, V> void to(@Nonnull T instance, @Nonnull IValueAccessor<V> pmm) throws Exception {
        this.checkAssigned();
        if (instance == null || pmm == null) {
            throw new IllegalArgumentException("Parameters in a bind request CANNOT be null!");
        }
        this.m_instanceProperty = pmm;
        this.m_instance = instance;
        if (pmm instanceof PropertyMetaModel && this.m_converter == null) {
            PropertyMetaModel p = (PropertyMetaModel)pmm;
            Class<?> actualType = ComponentPropertyBinding.fixBoxingDisaster(p.getActualType());
            Class<Object> controlType = ComponentPropertyBinding.fixBoxingDisaster(this.m_controlProperty.getActualType());
            if (controlType == Object.class && this.m_control instanceof ITypedControl) {
                ITypedControl typedControl = (ITypedControl)((Object)this.m_control);
                controlType = typedControl.getActualType();
            }
            if (actualType != Object.class && controlType != Object.class) {
                if (!actualType.isAssignableFrom(controlType)) {
                    throw new BindingDefinitionException(this.toString(), actualType.getName(), controlType.getName());
                }
                if (!controlType.isAssignableFrom(actualType)) {
                    throw new BindingDefinitionException(this.toString(), actualType.getName(), controlType.getName());
                }
            }
        }
        this.moveModelToControl();
    }

    @Override
    @Nullable
    public UIMessage getBindError() {
        return this.m_bindError;
    }

    @Nonnull
    public IValueAccessor<?> getControlProperty() {
        return this.m_controlProperty;
    }

    public String toString() {
        NodeBase control;
        StringBuilder sb = new StringBuilder();
        sb.append("binding[");
        if (this.m_instance != null) {
            sb.append(this.m_instance);
        } else if (this.m_listener != null) {
            sb.append("listener ").append(this.m_listener);
        } else {
            sb.append("?");
        }
        IValueAccessor<?> instanceProperty = this.m_instanceProperty;
        if (instanceProperty != null) {
            sb.append(".");
            if (instanceProperty instanceof PropertyMetaModel) {
                sb.append(((PropertyMetaModel)instanceProperty).getName());
            } else {
                sb.append(instanceProperty.toString());
            }
        }
        if (null != (control = this.m_control)) {
            sb.append(" to ");
            sb.append(control.getClass().getSimpleName());
            PropertyMetaModel<?> controlProperty = this.m_controlProperty;
            if (null != controlProperty) {
                if (controlProperty instanceof PropertyMetaModel) {
                    sb.append(".").append(controlProperty.getName());
                } else {
                    sb.append(controlProperty.toString());
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Nullable
    public Object getInstance() {
        return this.m_instance;
    }

    @Nullable
    public IValueAccessor<?> getInstanceProperty() {
        return this.m_instanceProperty;
    }

    @Nonnull
    private static Class<?> fixBoxingDisaster(@Nonnull Class<?> clz) {
        Class<?> newClass = BOXINGDISASTER.get(clz);
        return newClass != null ? newClass : clz;
    }

    @Override
    public <T> void setModelValue(@Nullable T value) {
        IValueAccessor<?> instanceProperty = this.m_instanceProperty;
        if (null == instanceProperty) {
            throw new IllegalStateException("instance property cannot be null");
        }
        if (instanceProperty.isReadOnly()) {
            throw new IllegalStateException(instanceProperty + ": You cannot set this read-only property");
        }
        Object instance = this.m_instance;
        if (null == instance) {
            throw new IllegalStateException("instance cannot be null");
        }
        try {
            instanceProperty.setValue(instance, value);
        }
        catch (Exception x) {
            if (value == null) {
                throw new BindingFailureException(x, "->model", this + ": Binding error moving null to " + this.m_instanceProperty);
            }
            throw new BindingFailureException(x, "->model", this + ": Binding error moving " + value + " (a " + value.getClass().getName() + ") to " + this.m_instanceProperty);
        }
    }

    @Override
    @Nullable
    public BindingValuePair<?, ?> getBindingDifference() throws Exception {
        UIMessage newError;
        Object controlValue;
        Object instance;
        IValueAccessor<?> instanceProperty;
        block11: {
            IControl ict;
            NodeBase control = this.m_control;
            if (control instanceof IDisplayControl) {
                return null;
            }
            if (control instanceof IControl && ((ict = (IControl)((Object)control)).isDisabled() || ict.isReadOnly())) {
                return null;
            }
            IBindingListener<?> listener = this.m_listener;
            if (listener != null) {
                listener.moveControlToModel(control);
                return null;
            }
            instanceProperty = this.m_instanceProperty;
            if (null == instanceProperty) {
                throw new IllegalStateException("instance property cannot be null");
            }
            if (instanceProperty.isReadOnly()) {
                return null;
            }
            instance = this.m_instance;
            if (null == instance) {
                throw new IllegalStateException("instance cannot be null");
            }
            controlValue = null;
            newError = null;
            try {
                controlValue = this.m_controlProperty.getValue(this.m_control);
                IBindingConverter<?, ?> converter = this.m_converter;
                if (converter != null) {
                    controlValue = converter.controlToModel(controlValue);
                }
                this.m_lastValueFromControlAsModelValue = controlValue;
                this.m_bindError = null;
            }
            catch (CodeException cx) {
                newError = UIMessage.error(cx);
                newError.setErrorNode(control);
                newError.setErrorLocation(control.getErrorLocation());
                if (newError.equals(control.getMessage())) break block11;
                this.m_bindError = newError;
            }
        }
        if (null != newError) {
            return null;
        }
        Object propertyValue = instanceProperty.getValue(instance);
        if (MetaManager.areObjectsEqual(propertyValue, controlValue)) {
            return null;
        }
        return new BindingValuePair(this, controlValue, propertyValue);
    }

    @Override
    public void moveModelToControl() throws Exception {
        try {
            IBindingListener<?> listener = this.m_listener;
            if (listener != null) {
                listener.moveModelToControl(this.m_control);
                return;
            }
            IValueAccessor<?> instanceProperty = this.m_instanceProperty;
            if (null == instanceProperty) {
                throw new IllegalStateException("instance property cannot be null");
            }
            Object instance = this.m_instance;
            if (null == instance) {
                throw new IllegalStateException("instance cannot be null");
            }
            Object modelValue = instanceProperty.getValue(instance);
            if (!MetaManager.areObjectsEqual(modelValue, this.m_lastValueFromControlAsModelValue)) {
                this.m_lastValueFromControlAsModelValue = modelValue;
                IBindingConverter<?, ?> converter = this.m_converter;
                if (null != converter) {
                    modelValue = converter.modelToControl(modelValue);
                }
                this.m_controlProperty.setValue(this.m_control, modelValue);
                this.m_bindError = null;
            }
        }
        catch (Exception x) {
            throw new BindingFailureException(x, "Model->Control", this.toString());
        }
    }

    static {
        BOXINGDISASTER.put(Long.TYPE, Long.class);
        BOXINGDISASTER.put(Integer.TYPE, Integer.class);
        BOXINGDISASTER.put(Short.TYPE, Short.class);
        BOXINGDISASTER.put(Character.TYPE, Character.class);
        BOXINGDISASTER.put(Double.TYPE, Double.class);
        BOXINGDISASTER.put(Float.TYPE, Float.class);
        BOXINGDISASTER.put(Boolean.TYPE, Boolean.class);
        BOXINGDISASTER.put(Byte.TYPE, Byte.class);
    }
}

