/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.binding;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.BindingValuePair;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.component.binding.IBindingHandler;
import to.etc.domui.component.binding.IBindingHandlerFactory;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;

@DefaultNonNull
public class DefaultBindingHandler
implements IBindingHandler {
    public static final IBindingHandlerFactory FACTORY = new IBindingHandlerFactory(){

        @Override
        @Nonnull
        public IBindingHandler getBindingHandler(@Nonnull NodeBase node) {
            return new DefaultBindingHandler(node);
        }
    };
    private final NodeBase m_rootNode;

    public DefaultBindingHandler(NodeBase rootNode) {
        this.m_rootNode = rootNode;
    }

    @Override
    public void controlToModel() throws Exception {
        List<BindingValuePair<?, ?>> pairs = this.collectChangedBindings();
        if (pairs.size() == 0) {
            return;
        }
        for (BindingValuePair<?, ?> pair : pairs) {
            pair.moveControlToModel();
        }
    }

    private List<BindingValuePair<?, ?>> collectChangedBindings() throws Exception {
        final ArrayList result = new ArrayList();
        DomUtil.walkTree(this.m_rootNode, new DomUtil.IPerNode(){

            @Override
            @Nullable
            public Object before(NodeBase n) throws Exception {
                return null;
            }

            @Override
            @Nullable
            public Object after(NodeBase n) throws Exception {
                List<IBinding> list = n.getBindingList();
                if (null != list) {
                    for (IBinding sb : list) {
                        BindingValuePair<?, ?> pair = sb.getBindingDifference();
                        if (null == pair) continue;
                        result.add(pair);
                    }
                }
                return null;
            }
        });
        return result;
    }

    @Override
    public void modelToControl() throws Exception {
        DomUtil.walkTree(this.m_rootNode, new DomUtil.IPerNode(){

            @Override
            @Nullable
            public Object before(NodeBase n) throws Exception {
                List<IBinding> list = n.getBindingList();
                if (null != list) {
                    for (IBinding sb : list) {
                        sb.moveModelToControl();
                    }
                }
                return null;
            }

            @Override
            @Nullable
            public Object after(NodeBase n) throws Exception {
                return null;
            }
        });
    }
}

