/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.binding;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.ComponentPropertyBinding;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IValueAccessor;

public final class OldBindingHandler {
    public static final String BINDING_ERROR = "BindingError";

    private OldBindingHandler() {
    }

    public static void controlToModel(@Nonnull NodeBase root) throws Exception {
        DomApplication.get().getBindingHandler(root).controlToModel();
    }

    public static void modelToControl(@Nonnull NodeBase root) throws Exception {
        DomApplication.get().getBindingHandler(root).modelToControl();
    }

    @Nonnull
    public static List<UIMessage> getBindingErrors(@Nonnull NodeBase root) throws Exception {
        final ArrayList<UIMessage> res = new ArrayList<UIMessage>();
        DomUtil.walkTree(root, new DomUtil.IPerNode(){

            @Override
            public Object before(NodeBase n) throws Exception {
                List<IBinding> list = n.getBindingList();
                if (null != list) {
                    for (IBinding sb : list) {
                        UIMessage message = sb.getBindError();
                        if (null == message) continue;
                        res.add(message);
                    }
                }
                return null;
            }

            @Override
            public Object after(NodeBase n) throws Exception {
                return null;
            }
        });
        return res;
    }

    public static boolean reportBindingErrors(@Nonnull NodeBase root) throws Exception {
        final boolean[] silly = new boolean[1];
        DomUtil.walkTree(root, new DomUtil.IPerNode(){

            @Override
            public Object before(NodeBase n) throws Exception {
                List<IBinding> list = n.getBindingList();
                if (null != list) {
                    ArrayList<UIMessage> bindErrorList = new ArrayList<UIMessage>();
                    for (IBinding sb : list) {
                        UIMessage message = sb.getBindError();
                        if (null == message) continue;
                        bindErrorList.add(message);
                    }
                    if (bindErrorList.size() > 0) {
                        UIMessage message = (UIMessage)bindErrorList.get(0);
                        message.group(OldBindingHandler.BINDING_ERROR);
                        silly[0] = true;
                        n.setMessage(message);
                    } else {
                        UIMessage componentMessage = n.getMessage();
                        if (componentMessage != null && OldBindingHandler.BINDING_ERROR.equals(componentMessage.getGroup())) {
                            n.setMessage(null);
                        }
                    }
                }
                return null;
            }

            @Override
            public Object after(NodeBase n) throws Exception {
                return null;
            }
        });
        return silly[0];
    }

    @Nullable
    public static ComponentPropertyBinding findBinding(NodeBase nodeBase, String string) {
        List<IBinding> list = nodeBase.getBindingList();
        if (list != null) {
            for (IBinding sb : list) {
                ComponentPropertyBinding sib;
                IValueAccessor<?> property;
                if (!(sb instanceof ComponentPropertyBinding) || !((property = (sib = (ComponentPropertyBinding)sb).getControlProperty()) instanceof PropertyMetaModel) || !string.equals(((PropertyMetaModel)property).getName())) continue;
                return sib;
            }
        }
        return null;
    }
}

