/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.binding;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.BindingValuePair;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.component.binding.StyleBinder;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IValueAccessor;

public final class StyleBinding
implements IBinding {
    @Nonnull
    private final StyleBinder m_styleBinder;
    @Nonnull
    private final NodeBase m_component;
    @Nullable
    private Object m_instance;
    @Nullable
    private IValueAccessor<?> m_instanceProperty;
    @Nullable
    private String m_previousStyle;

    StyleBinding(@Nonnull StyleBinder styleBinder, @Nonnull NodeBase component) {
        this.m_styleBinder = styleBinder;
        this.m_component = component;
    }

    @Nonnull
    public <T, P> StyleBinder to(@Nonnull T instance, @Nonnull IValueAccessor<P> property) throws Exception {
        this.m_instance = instance;
        this.m_instanceProperty = property;
        this.m_component.addBinding(this);
        this.moveModelToControl();
        return this.m_styleBinder;
    }

    @Nonnull
    public <T> StyleBinder to(@Nonnull T instance, @Nonnull String property) throws Exception {
        return this.to(instance, MetaManager.getPropertyMeta(instance.getClass(), property));
    }

    @Override
    public void moveModelToControl() throws Exception {
        Object instance = this.m_instance;
        if (null == instance) {
            throw new IllegalStateException("Instance bound to is null??");
        }
        IValueAccessor<?> pmm = this.m_instanceProperty;
        if (null == pmm) {
            throw new IllegalStateException("Instance property is null?");
        }
        try {
            Object value = pmm.getValue(instance);
            String style = this.m_styleBinder.getStyleFor(value);
            this.updateStyle(style);
        }
        catch (Exception x) {
            System.err.println("Style binding error: " + x);
        }
    }

    private void updateStyle(@Nullable String style) {
        if (DomUtil.isEqual((Object)this.m_previousStyle, (Object)style)) {
            return;
        }
        String prev = this.m_previousStyle;
        if (null != prev) {
            this.m_component.removeCssClass(prev);
            this.m_previousStyle = null;
        }
        if (style != null) {
            this.m_previousStyle = style;
            this.m_component.addCssClass(style);
        }
    }

    @Override
    @Nullable
    public BindingValuePair<?, ?> getBindingDifference() throws Exception {
        return null;
    }

    @Override
    public <T> void setModelValue(T value) {
        throw new IllegalStateException("A style binding cannot move data to the model!");
    }

    @Override
    @Nullable
    public UIMessage getBindError() {
        return null;
    }
}

