/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.buttons;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.Underline;
import to.etc.domui.util.DomUtil;

public class DefaultButton
extends Button
implements IActionControl {
    private String m_text;
    @Nullable
    private String m_icon;
    private IUIAction<?> m_action;
    private Object m_actionInstance;

    public DefaultButton() {
        this.setCssClass("ui-sdbtn");
    }

    public DefaultButton(String txt) {
        this();
        this.setText(txt);
    }

    public DefaultButton(IUIAction<?> action) throws Exception {
        this();
        this.m_action = action;
        this.actionRefresh();
    }

    public <T> DefaultButton(T instance, IUIAction<T> action) throws Exception {
        this();
        this.m_action = action;
        this.m_actionInstance = instance;
        this.actionRefresh();
    }

    public DefaultButton(String txt, String icon) {
        this();
        this.setText(txt);
        this.setIcon(icon);
    }

    public DefaultButton(String txt, IClicked<DefaultButton> clicked) {
        this();
        this.setText(txt);
        this.setClicked(clicked);
    }

    public DefaultButton(String txt, String icon, IClicked<DefaultButton> clicked) {
        this();
        this.setText(txt);
        this.setIcon(icon);
        this.setClicked(clicked);
    }

    @Override
    public void createContent() throws Exception {
        Span s = new Span();
        this.add(s);
        s.setCssClass("ui-sdbtn-w");
        if (null != this.m_icon) {
            String icon = this.getThemedResourceRURL(this.m_icon);
            Img img = new Img(icon);
            s.add(img);
            img.setImgBorder(0);
            img.setDisabled(this.isDisabled());
        }
        Span txt = new Span();
        txt.setCssClass("ui-sdbtn-txt");
        s.add(txt);
        if (!DomUtil.isBlank(this.m_text)) {
            this.decodeAccelerator(this.m_text, txt);
        }
    }

    public DefaultButton mini() {
        this.setCssClass("ui-sdbtn-mini");
        return this;
    }

    public void setIconImage(Class<?> resourceBase, String name) {
        this.setIcon(DomUtil.getJavaResourceRURL(resourceBase, name));
    }

    public void setIcon(@Nullable String name) {
        this.m_icon = name;
        this.forceRebuild();
    }

    @Nullable
    public String getIcon() {
        return this.m_icon;
    }

    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(@Nullable String text) {
        this.m_text = text;
        if (null != text) {
            this.setCalculcatedId("button_" + DomUtil.convertToID(text));
        }
        this.forceRebuild();
    }

    private void decodeAccelerator(String txt, Span into) {
        StringBuilder sb = new StringBuilder(txt.length());
        int ix = 0;
        int len = txt.length();
        while (ix < len) {
            int pos = txt.indexOf(33, ix);
            if (pos == -1) {
                sb.append(txt.substring(ix));
                if (sb.length() > 0) {
                    into.add(sb.toString());
                }
                return;
            }
            if (pos > 0 && txt.charAt(pos - 1) == '\\') {
                sb.append(txt, ix, pos - 1);
                sb.append('!');
                ix = pos + 1;
                continue;
            }
            if (pos > ix) {
                sb.append(txt, ix, pos);
            }
            if (pos + 1 >= len) {
                sb.append('!');
                into.add(sb.toString());
                return;
            }
            char c = txt.charAt(pos + 1);
            if (Character.isLetterOrDigit(c)) {
                c = Character.toLowerCase(c);
                this.setAccessKey(c);
            }
            if (sb.length() > 0) {
                into.add(sb.toString());
                sb.setLength(0);
            }
            Underline ac = new Underline();
            into.add(ac);
            ac.add(txt.substring(pos + 1, pos + 2));
            ix = pos + 2;
        }
    }

    @Override
    public String getComponentInfo() {
        return "Button:" + this.m_text;
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.forceRebuild();
    }

    @Nullable
    public IUIAction<?> getAction() {
        return this.m_action;
    }

    private void actionRefresh() throws Exception {
        final IUIAction<?> action = this.getAction();
        if (null == action) {
            return;
        }
        String dt = action.getDisableReason(this.m_actionInstance);
        if (null == dt) {
            dt = action.getTitle(this.m_actionInstance);
            this.setDisabled(false);
        } else {
            this.setDisabled(true);
        }
        this.setTitle(dt);
        this.setText(action.getName(this.m_actionInstance));
        this.setIcon(action.getIcon(this.m_actionInstance));
        this.setClicked(new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                action.execute(DefaultButton.this, DefaultButton.this.m_actionInstance);
            }
        });
    }
}

