/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.buttons;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.server.DomApplication;

@DefaultNonNull
public final class HoverButton
extends Button
implements IActionControl {
    @Nullable
    private String m_url;
    @Nullable
    private Size m_size;

    public HoverButton() {
    }

    public HoverButton(@Nonnull String rurl) {
        this.setSrc(rurl);
    }

    public HoverButton(@Nonnull String rurl, @Nonnull IClicked<HoverButton> cl) {
        this();
        this.setClicked(cl);
        this.setSrc(rurl);
    }

    @Override
    public void createContent() throws Exception {
        Dimension dimension = this.calculateSize();
        if (null == dimension) {
            throw new IllegalStateException("Cannot detect the image dimension of image " + this.getBackgroundImage());
        }
        int totalWidth = dimension.getWidth();
        int width = totalWidth / 3;
        if (width * 3 != totalWidth || width < dimension.getHeight() - 4) {
            System.err.println("ERROR: Resource " + this.getBackgroundImage() + " for a hover button must have 3 images in width: 1x normal, 1x hover, 1x disabled; it seems wrong");
        }
        this.setWidth(width + "px");
        this.setHeight(dimension.getHeight() + "px");
        this.addCssClass("ui-hvrbtn ui-hvrbtn-" + width);
    }

    public void setSrc(String src) {
        this.m_url = src;
        this.setBackgroundImage(src);
        this.forceRebuild();
    }

    @Nullable
    private Dimension calculateSize() throws Exception {
        return DomApplication.get().getResourceInfoCache().getImageDimension(this, this.getBackgroundImage());
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

