/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.buttons;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.parts.GrayscalerPart;
import to.etc.domui.util.DomUtil;

public class LinkButton
extends ATag
implements IActionControl {
    @Nullable
    private String m_text;
    @Nullable
    private String m_imageUrl;
    private boolean m_disabled;
    @Nullable
    private IUIAction<Void> m_action;
    @Nullable
    private Object m_actionInstance;
    @Nullable
    private String m_disabledBecause;

    public LinkButton() {
        this.setCssClass("ui-lnkb");
    }

    public LinkButton(@Nonnull String txt, @Nonnull String image, @Nonnull IClicked<? extends NodeBase> clk) {
        this.setCssClass("ui-lnkb ui-lbtn");
        this.setClicked(clk);
        this.m_text = txt;
        this.setImage(image);
    }

    public LinkButton(@Nonnull String txt, @Nonnull String image) {
        this.setCssClass("ui-lnkb ui-lbtn");
        this.m_text = txt;
        this.setImage(image);
    }

    public LinkButton(@Nonnull String txt) {
        this.setCssClass("ui-lnkb");
        this.m_text = txt;
    }

    public LinkButton(@Nonnull String txt, @Nonnull IClicked<? extends NodeBase> clk) {
        this.setCssClass("ui-lnkb");
        this.setClicked(clk);
        this.m_text = txt;
    }

    public LinkButton(@Nonnull IUIAction<Void> action) throws Exception {
        this();
        this.m_action = action;
        this.actionRefresh();
    }

    public LinkButton(@Nonnull IUIAction<Void> action, @Nullable Object actionInstance) throws Exception {
        this();
        this.m_action = action;
        this.m_actionInstance = actionInstance;
        this.actionRefresh();
    }

    @Override
    public void createContent() throws Exception {
        this.updateStyle();
        this.setText(this.m_text);
    }

    private void actionRefresh() throws Exception {
        final IUIAction<?> action = this.getAction();
        if (null == action) {
            return;
        }
        String dt = action.getDisableReason(this.getActionInstance());
        if (null == dt) {
            this.setTitle(action.getTitle(this.getActionInstance()));
            this.setDisabled(false);
        } else {
            this.setTitle(dt);
            this.setDisabled(true);
        }
        this.setText(action.getName(this.getActionInstance()));
        this.setImage(action.getIcon(this.getActionInstance()));
        this.setClicked(new IClicked<LinkButton>(){

            @Override
            public void clicked(@Nonnull LinkButton clickednode) throws Exception {
                action.execute(LinkButton.this, LinkButton.this.getActionInstance());
            }
        });
    }

    public void setImage(@Nullable String url) {
        if (DomUtil.isEqual((Object)url, (Object)this.m_imageUrl)) {
            return;
        }
        this.m_imageUrl = url;
        this.forceRebuild();
    }

    public String getImage() {
        return this.m_imageUrl;
    }

    private void updateStyle() {
        String imageUrl = this.m_imageUrl;
        if (imageUrl == null) {
            this.setBackgroundImage(null);
            this.setCssClass("ui-lnkb");
        } else {
            String image = this.getThemedResourceRURL(imageUrl);
            if (this.isDisabled()) {
                image = GrayscalerPart.getURL(image);
            }
            this.setBackgroundImage(image);
            this.setCssClass("ui-lnkb ui-lbtn");
        }
        if (this.isDisabled()) {
            this.addCssClass("ui-lnkb-dis");
        } else {
            this.removeCssClass("ui-lnkb-dis");
        }
    }

    @Override
    public void setText(@Nullable String txt) {
        this.m_text = txt;
        super.setText(txt);
    }

    @Override
    @Nonnull
    public String getComponentInfo() {
        return "LinkButton:" + this.m_text;
    }

    @Nullable
    public IUIAction<?> getAction() {
        return this.m_action;
    }

    @Nullable
    public Object getActionInstance() {
        return this.m_actionInstance;
    }

    public void setAction(@Nonnull IUIAction<Void> action) throws Exception {
        if (DomUtil.isEqual(this.m_action, action)) {
            return;
        }
        this.m_action = action;
        this.actionRefresh();
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.forceRebuild();
    }

    @Override
    public void internalOnClicked(@Nonnull ClickInfo cli) throws Exception {
        if (this.isDisabled()) {
            return;
        }
        super.internalOnClicked(cli);
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }
}

