/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.ckeditor;

import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.ckeditor.CKEditor;
import to.etc.domui.component.htmleditor.EditorFile;
import to.etc.domui.component.htmleditor.EditorFolder;
import to.etc.domui.component.htmleditor.EditorResourceType;
import to.etc.domui.component.htmleditor.IEditorFileRef;
import to.etc.domui.component.htmleditor.IEditorFileSystem;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.PrettyXmlOutputWriter;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.state.UIContext;
import to.etc.domui.trouble.ThingyNotFoundException;

public class CKEditResPart
implements IUnbufferedPartFactory {
    private static final ThreadLocal<DateFormat> m_format = new ThreadLocal();

    private static DateFormat getFormatter() {
        DateFormat df = m_format.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyyMMddHHmmss");
            m_format.set(df);
        }
        return df;
    }

    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        System.out.println("QS=" + param.getRequestResponse().getQueryString());
        System.out.println("RURL=" + rurl);
        ComponentPartRenderer cpr = new ComponentPartRenderer();
        cpr.initialize(app, param, rurl);
        if (cpr.getArgs().length != 4) {
            throw new IllegalStateException("Invalid input URL '" + rurl + "': must be in format cid/pageclass/componentID/resourceType.");
        }
        String resty = cpr.getArgs()[3];
        if (!(cpr.getComponent() instanceof CKEditor)) {
            throw new ThingyNotFoundException("The component " + cpr.getComponent().getActualID() + " on page " + cpr.getPage().getBody() + " is not an HtmlEditor instance");
        }
        CKEditor e = (CKEditor)cpr.getComponent();
        IEditorFileSystem ifs = e.getFileSystem();
        if (ifs == null) {
            throw new ThingyNotFoundException("The HtmlEditor component " + cpr.getComponent().getActualID() + " on page " + cpr.getPage().getBody() + " has no file system attached to it");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(UIContext.getRequestContext().getRelativePath(CKEditResPart.class.getName()));
        sb.append("/");
        sb.append(rurl);
        sb.append(".part");
        String cmd = param.getParameter("Command");
        if ("init".equalsIgnoreCase(cmd)) {
            this.sendInit(app, ifs, param);
        } else if ("getfoldersandfiles".equalsIgnoreCase(cmd)) {
            this.sendFolderAndFiles(app, ifs, param, resty, sb);
        } else if ("File".equalsIgnoreCase(cmd)) {
            this.sendFile(app, ifs, param, resty);
        } else {
            throw new IllegalStateException("Unimplemented command: " + cmd);
        }
    }

    private IBrowserOutput defaultHeader(RequestContextImpl ctx, String cmd, String rtype, String path) throws Exception {
        Writer outputWriter = ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8");
        PrettyXmlOutputWriter w = new PrettyXmlOutputWriter(outputWriter);
        w.tag("Connector");
        w.attr("command", cmd);
        w.attr("resourceType", rtype);
        w.endtag();
        w.tag("CurrentFolder");
        w.attr("path", path);
        w.attr("url", "whatteh");
        w.endAndCloseXmltag();
        return w;
    }

    private String getPath(RequestContextImpl ctx, String name) throws Exception {
        String rpath = ctx.getParameter(name);
        if (rpath == null) {
            rpath = "";
        }
        while (rpath.startsWith("/")) {
            rpath = rpath.substring(1);
        }
        if (rpath.contains("..") || rpath.contains(":") || rpath.contains("\\")) {
            throw new IllegalStateException("Invalid input path");
        }
        return rpath;
    }

    private void sendFolderAndFiles(DomApplication app, IEditorFileSystem ifs, RequestContextImpl ctx, String type, CharSequence baseURL) throws Exception {
        String rpath = this.getPath(ctx, "CurrentFolder");
        IBrowserOutput w = this.defaultHeader(ctx, "GetFolderAndFiles", type, rpath);
        w.tag("Error");
        w.attr("number", 0);
        w.endAndCloseXmltag();
        w.tag("Folders");
        w.endtag();
        List<?> resl = ifs.getFilesAndFolders(type, rpath);
        for (Object o : resl) {
            if (!(o instanceof EditorFolder)) continue;
            EditorFolder ef = (EditorFolder)o;
            w.tag("Folder");
            w.attr("name", ef.getName());
            w.attr("hasChildren", ef.isHasChildren());
            w.attr("acl", ef.getAcl());
            w.endAndCloseXmltag();
        }
        w.closetag("Folders");
        w.tag("Files");
        w.endtag();
        StringBuilder sb = new StringBuilder(128);
        for (Object o : resl) {
            if (!(o instanceof EditorFile)) continue;
            EditorFile ef = (EditorFile)o;
            w.tag("File");
            w.attr("name", ef.getName());
            w.attr("date", CKEditResPart.getFormatter().format(ef.getDate()));
            int sz = ef.getSize() / 1024;
            w.attr("size", sz == 0 ? 1 : sz);
            sb.setLength(0);
            sb.append(baseURL);
            sb.append("?Command=File&path=");
            sb.append(rpath);
            sb.append('/');
            sb.append(ef.getName());
            w.attr("url", sb.toString());
            w.endAndCloseXmltag();
        }
        w.closetag("Files");
        w.closetag("Connector");
    }

    private void sendInit(DomApplication app, IEditorFileSystem ifs, RequestContextImpl ctx) throws Exception {
        PrettyXmlOutputWriter w = new PrettyXmlOutputWriter(ctx.getOutputWriter("text/xml; charset=UTF-8", "utf-8"));
        w.tag("Connector");
        w.endtag();
        w.tag("Error");
        w.attr("number", 0);
        w.endAndCloseXmltag();
        w.tag("ConnectorInfo");
        w.attr("enabled", "true");
        w.attr("s", "");
        w.attr("c", "");
        w.attr("thumbsEnabled", "true");
        w.endAndCloseXmltag();
        w.tag("ResourceTypes");
        w.endtag();
        for (EditorResourceType t : ifs.getResourceTypes()) {
            w.tag("ResourceType");
            w.attr("name", t.getName());
            w.attr("url", t.getRootURL());
            w.attr("allowedExtensions", t.getAllowedExtensions().toString().replace("[", "").replace("]", ""));
            w.attr("deniedExtensions", t.getDeniedExtensions().toString().replace("[", "").replace("]", ""));
            w.attr("defaultView", "Thumbnails");
            w.attr("acl", 255);
            w.endAndCloseXmltag();
        }
        w.closetag("ResourceTypes");
        w.closetag("Connector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(DomApplication app, IEditorFileSystem ifs, RequestContextImpl ctx, String type) throws Exception {
        String rpath = this.getPath(ctx, "path");
        if (rpath.length() == 0) {
            throw new ThingyNotFoundException("IEditorFileSystem file with path=" + rpath);
        }
        IEditorFileRef efr = ifs.getStreamRef(type, rpath);
        if (efr == null) {
            throw new ThingyNotFoundException("IEditorFileSystem file with path=" + rpath + " does not return a reference");
        }
        OutputStream os = null;
        try {
            int len = efr.getSize();
            os = ctx.getRequestResponse().getOutputStream(efr.getMimeType(), null, len);
            efr.copyTo(os);
            os.close();
            os = null;
        }
        finally {
            try {
                efr.close();
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

