/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.ckeditor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.ckeditor.CKToolbarSet;
import to.etc.domui.component.htmleditor.IEditorFileSystem;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.component.misc.MsgBoxButton;
import to.etc.domui.component.misc.OddCharacters;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.VisibilityType;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;
import to.etc.webapp.nls.NlsContext;

public class CKEditor
extends TextArea {
    @Nullable
    private String m_vn;
    @Nonnull
    private CKToolbarSet m_toolbarSet = CKToolbarSet.DOMUI;
    private IEditorFileSystem m_fileSystem;
    @Nullable
    private IClicked<NodeBase> m_onDomuiImageClicked;
    @Nullable
    private IClicked<NodeBase> m_onDomuiOddCharsClicked;
    @Nonnull
    private static final String WEBUI_CK_DOMUIIMAGE_ACTION = "CKIMAGE";
    @Nonnull
    private static final String WEBUI_CK_DOMUIODDCHAR_ACTION = "CKODDCHAR";
    private boolean m_toolbarStartExpanded = true;
    @Nullable
    private String m_internalWidth;
    @Nullable
    private String m_internalHeight;

    public CKEditor() {
        super.setCssClass("ui-ckeditor");
        this.setVisibility(VisibilityType.HIDDEN);
    }

    @Override
    public final void setCssClass(@Nullable String cssClass) {
        throw new IllegalStateException("Cannot set a class on CKEditor");
    }

    @Override
    public void createContent() throws Exception {
        StringBuilder sb = new StringBuilder(1024);
        this.m_vn = "_ck" + this.getActualID();
        sb.append("var ").append(this.m_vn).append(" = CKEDITOR.replace('").append(this.getActualID()).append("', {");
        sb.append("customConfig: '").append(DomUtil.getRelativeApplicationResourceURL("$ckeditor/domuiconfig.js")).append("'\n");
        sb.append(",on: {instanceReady: function(ev) {WebUI.CKeditor_OnComplete('" + this.getActualID() + "');}}\n");
        String dl = NlsContext.getLocale().getLanguage();
        if (dl.contains("nl")) {
            dl = "nl";
        } else if (dl.contains("en")) {
            dl = "en";
        }
        sb.append(", defaultLanguage:'").append(dl).append("'\n");
        if (!this.isToolbarStartExpanded()) {
            sb.append(", toolbarStartupExpanded: false\n");
            sb.append(", toolbarCanCollapse: true\n");
        } else {
            sb.append(", toolbarCanCollapse: false\n");
        }
        sb.append(", resize_enabled: false\n");
        sb.append(", toolbar: '" + this.m_toolbarSet.name() + "'\n");
        switch (this.m_toolbarSet) {
            case DOMUI: 
            case FULL: {
                sb.append(", extraPlugins : 'domuiimage,domuioddchar,justify,colorbutton,smiley,font'\n");
                break;
            }
        }
        String color = "#5689E6";
        sb.append(", uiColor: '" + color + "'\n");
        String s = this.m_internalWidth;
        if (null != s) {
            sb.append(", width:'").append(s).append("'\n");
        }
        if (null != (s = this.m_internalHeight)) {
            sb.append(", height:'").append(s).append("'\n");
        }
        sb.append("});\n");
        sb.append("WebUI.registerCkEditorId('" + this.getActualID() + "', " + this.m_vn + ");");
        this.appendCreateJS(sb);
        this.setDisplay(DisplayType.NONE);
    }

    @Override
    public void setWidth(@Nullable String width) {
        this.m_internalWidth = width;
    }

    @Override
    public void setHeight(@Nullable String height) {
        this.m_internalHeight = height;
    }

    private void appendOption(@Nonnull StringBuilder sb, @Nonnull String option, @Nonnull String value) {
        sb.append(this.m_vn).append(".").append(option).append(" = ");
        try {
            StringTool.strToJavascriptString((Appendable)sb, (String)value, (boolean)true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        sb.append(";");
    }

    @Nonnull
    public CKToolbarSet getToolbarSet() {
        return this.m_toolbarSet;
    }

    public void setToolbarSet(@Nonnull CKToolbarSet toolbarSet) {
        if (DomUtil.isEqual((Object)toolbarSet, (Object)this.m_toolbarSet)) {
            return;
        }
        this.m_toolbarSet = toolbarSet;
        if (!this.isBuilt()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.appendOption(sb, "toolbar", this.m_toolbarSet.name());
        this.appendJavascript("");
    }

    @Nullable
    public IEditorFileSystem getFileSystem() {
        return this.m_fileSystem;
    }

    public void setFileSystem(@Nullable IEditorFileSystem fileSystem) {
        this.m_fileSystem = fileSystem;
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if (WEBUI_CK_DOMUIIMAGE_ACTION.equals(action)) {
            this.selectImage(ctx);
        } else if (WEBUI_CK_DOMUIODDCHAR_ACTION.equals(action)) {
            this.oddChars(ctx);
        } else {
            super.componentHandleWebAction(ctx, action);
        }
    }

    private void selectImage(@Nonnull RequestContextImpl ctx) throws Exception {
        IClicked<NodeBase> clicked = this.m_onDomuiImageClicked;
        if (clicked == null) {
            MsgBox.message((NodeBase)this, MsgBox.Type.ERROR, "No image picker is defined", new MsgBox.IAnswer(){

                @Override
                public void onAnswer(MsgBoxButton result) throws Exception {
                    CKEditor.this.renderCancelImage();
                }
            });
        } else {
            clicked.clicked(this);
        }
    }

    private void oddChars(@Nonnull RequestContextImpl ctx) throws Exception {
        IClicked<NodeBase> clicked = this.m_onDomuiOddCharsClicked;
        if (clicked == null) {
            OddCharacters oddChars = new OddCharacters();
            oddChars.setOnClose(new IWindowClosed(){

                @Override
                public void closed(@Nonnull String closeReason) throws Exception {
                    CKEditor.this.renderCloseOddCharacters();
                }
            });
            this.getPage().getBody().add(oddChars);
        } else {
            clicked.clicked(this);
        }
    }

    public void renderImageSelected(@Nonnull String url) {
        this.appendJavascript("CkeditorDomUIImage.addImage('" + this.getActualID() + "', '" + url + "');");
    }

    public void renderCancelImage() {
        this.appendJavascript("CkeditorDomUIImage.cancel('" + this.getActualID() + "');");
    }

    public void renderCloseOddCharacters() {
        this.appendJavascript("CkeditorDomUIOddChar.cancel('" + this.getActualID() + "');");
    }

    public void renderOddCharacters(@Nonnull String input) {
        this.appendJavascript("CkeditorDomUIOddChar.addString('" + this.getActualID() + "', '" + input + "');");
    }

    @Nullable
    public IClicked<NodeBase> getOnDomuiImageClicked() {
        return this.m_onDomuiImageClicked;
    }

    public void setOnDomuiImageClicked(@Nonnull IClicked<NodeBase> onDomuiImageClicked) {
        this.m_onDomuiImageClicked = onDomuiImageClicked;
    }

    @Nullable
    public IClicked<NodeBase> getOnDomuiOddCharsClicked() {
        return this.m_onDomuiOddCharsClicked;
    }

    public void setOnDomuiOddCharsClicked(@Nonnull IClicked<NodeBase> onDomuiOddCharsClicked) {
        this.m_onDomuiOddCharsClicked = onDomuiOddCharsClicked;
    }

    public boolean isToolbarStartExpanded() {
        return this.m_toolbarStartExpanded;
    }

    public void setToolbarStartExpanded(boolean toolbarStartExpanded) {
        this.m_toolbarStartExpanded = toolbarStartExpanded;
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) throws Exception {
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            StringBuilder sb = new StringBuilder();
            try {
                StringTool.entitiesToUnicode((Appendable)sb, (String)s, (boolean)true);
                values[i] = sb.toString();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                values[i] = e.toString();
            }
        }
        return super.acceptRequestParameter(values);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onRemoveFromPage(Page p) {
        super.onRemoveFromPage(p);
        this.appendJavascript("WebUI.unregisterCkEditorId('" + this.getActualID() + "');");
    }

    public void appendfixSizeJS() {
        this.appendJavascript("WebUI.CKeditor_OnComplete('" + this.getActualID() + "');");
    }
}

