/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.combobox;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.combobox.ComboOption;
import to.etc.domui.component.input.CriteriaComboDataSet;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.server.DomApplication;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.IListMaker;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.domui.util.Msgs;
import to.etc.util.WrappedException;
import to.etc.webapp.query.QCriteria;

public class ComboBoxBase<T, V>
extends Div
implements IControl<V> {
    private boolean m_mandatory;
    private boolean m_disabled;
    private boolean m_readOnly;
    private String m_emptyText;
    private V m_currentValue;
    private int m_currentIndex;
    private IValueChanged<?> m_onValueChanged;
    private ComboOption<T> m_emptyOption;
    private List<T> m_data;
    private INodeContentRenderer<T> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Class<? extends INodeContentRenderer<T>> m_contentRendererClass;
    private PropertyMetaModel<?> m_propertyMetaModel;
    private IListMaker<T> m_listMaker;
    private IComboDataSet<T> m_dataSet;
    private IValueTransformer<V> m_valueTransformer;
    private Div m_popupDiv;
    private Span m_valueNode;
    private Div m_arrowBox;

    public ComboBoxBase() {
    }

    public ComboBoxBase(@Nonnull IListMaker<T> maker) {
        this.m_listMaker = maker;
    }

    public ComboBoxBase(@Nonnull IComboDataSet<T> dataSet) {
        this.m_dataSet = dataSet;
    }

    public ComboBoxBase(@Nonnull QCriteria<T> query) {
        this.m_dataSet = new CriteriaComboDataSet<T>(query);
    }

    public ComboBoxBase(@Nonnull List<T> in) {
        this.m_data = in;
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-cbb");
        Span span = this.m_valueNode = new Span();
        this.add(span);
        Div d = this.m_popupDiv = new Div();
        d.setCssClass("ui-cbb-pu");
        this.add(d);
        List<T> list = this.getData();
        V raw = this.internalGetCurrentValue();
        boolean isvalidselection = false;
        int ix = 0;
        ClassMetaModel cmm = null;
        for (T val : list) {
            V res = this.listToValue(val);
            ComboOption<T> o = new ComboOption<T>(val);
            d.add(o);
            this.renderOptionLabel(o);
            if (null != raw) {
                boolean eq;
                if (cmm == null) {
                    cmm = MetaManager.findClassMeta(raw.getClass());
                }
                if (eq = MetaManager.areObjectsEqual(res, raw, cmm)) {
                    o.setSelected(eq);
                    this.internalSetSelectedIndex(ix);
                    isvalidselection = true;
                    this.renderOptionLabel(span, o);
                }
            }
            ++ix;
        }
        this.setEmptyOption(null);
        if (!this.isMandatory() || !isvalidselection) {
            ComboOption<Object> o = new ComboOption<Object>(null);
            if (this.getEmptyText() != null) {
                o.setText(this.getEmptyText());
            }
            this.add(0, o);
            this.setEmptyOption(o);
            if (!isvalidselection) {
                o.setSelected(true);
                this.internalSetSelectedIndex(0);
            } else {
                this.internalSetSelectedIndex(this.getSelectedIndex() + 1);
            }
            this.renderOptionLabel(span, o);
        }
        Div a = this.m_arrowBox = new Div();
        this.add(a);
        a.setCssClass("ui-cbb-ab");
        this.appendCreateJS("new WebUI.comboBox('" + this.getActualID() + "');");
    }

    private void internalSetSelectedIndex(int ix) {
        this.m_currentIndex = ix;
    }

    public int getSelectedIndex() {
        return this.m_currentIndex;
    }

    public void setSelectedIndex(int ix) {
        this.m_currentIndex = ix;
        int i = this.getChildCount();
        while (--i >= 0) {
            this.getOption(i).setSelected(i == this.m_currentIndex);
        }
    }

    @Override
    public final V getValue() {
        if (this.isMandatory() && this.m_currentValue == null) {
            this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.mandatory", new Object[0]));
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        this.clearMessage();
        return this.m_currentValue;
    }

    @Override
    public final void setValue(@Nullable V v) {
        V currentValue = this.m_currentValue;
        ClassMetaModel cmm = v != null ? MetaManager.findClassMeta(v.getClass()) : null;
        if (MetaManager.areObjectsEqual(v, currentValue, cmm)) {
            return;
        }
        this.m_currentValue = v;
        if (!this.isBuilt()) {
            return;
        }
        int ix = this.findListIndexForValue(v);
        if (null == v || ix < 0) {
            if (this.getEmptyOption() == null) {
                ComboOption<Object> o = new ComboOption<Object>(null);
                if (this.getEmptyText() != null) {
                    o.setText(this.getEmptyText());
                }
                this.add(0, o);
                this.setEmptyOption(o);
            }
            this.setSelectedIndex(0);
            return;
        }
        if (this.getEmptyOption() != null) {
            ++ix;
        }
        this.setSelectedIndex(ix);
    }

    protected boolean internalOnUserInput(int oldindex, int nindex) {
        Object newval = nindex < 0 ? null : (this.getEmptyOption() != null ? (nindex <= 0 ? null : this.findListValueByIndex(--nindex)) : this.findListValueByIndex(nindex));
        ClassMetaModel cmm = newval == null ? null : MetaManager.findClassMeta(newval.getClass());
        V currentValue = this.m_currentValue;
        if (MetaManager.areObjectsEqual(newval, currentValue, cmm)) {
            return false;
        }
        this.m_currentValue = newval;
        return true;
    }

    private int findListIndexForValue(V newvalue) {
        if (null == newvalue) {
            return -1;
        }
        try {
            ClassMetaModel cmm = MetaManager.findClassMeta(newvalue.getClass());
            List<T> data = this.getData();
            for (int ix = 0; ix < data.size(); ++ix) {
                V value = this.listToValue(data.get(ix));
                if (!MetaManager.areObjectsEqual(value, newvalue, cmm)) continue;
                return ix;
            }
            return -1;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    private V findListValueByIndex(int ix) {
        try {
            List<T> data = this.getData();
            if (ix < 0 || ix >= data.size()) {
                return null;
            }
            return this.listToValue(data.get(ix));
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    protected V listToValue(T in) throws Exception {
        if (this.m_valueTransformer == null) {
            return (V)in;
        }
        return this.m_valueTransformer.getValue(in);
    }

    @Nonnull
    private INodeContentRenderer<T> calculateContentRenderer(Object val) {
        if (this.m_contentRenderer != null) {
            return this.m_contentRenderer;
        }
        if (this.m_contentRendererClass != null) {
            return DomApplication.get().createInstance(this.m_contentRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(this.m_propertyMetaModel, cmm);
    }

    protected void renderOptionLabel(@Nonnull ComboOption<T> o) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(o.getValue());
        }
        this.m_actualContentRenderer.renderNodeContent(this, o, o.getValue(), this);
    }

    protected void renderOptionLabel(@Nonnull NodeContainer into, @Nonnull ComboOption<T> o) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(o.getValue());
        }
        this.m_actualContentRenderer.renderNodeContent(this, into, o.getValue(), this);
    }

    public void setData(List<T> data) {
        if (this.m_data != data) {
            this.forceRebuild();
            this.m_actualContentRenderer = null;
        }
        this.m_data = data;
    }

    @Nonnull
    public List<T> getData() throws Exception {
        List<T> data = this.m_data;
        if (data == null) {
            data = this.m_data = this.provideData();
        }
        return data;
    }

    @Nonnull
    protected List<T> provideData() throws Exception {
        if (this.m_listMaker != null) {
            return DomApplication.get().getCachedList(this.m_listMaker);
        }
        IComboDataSet<T> builder = this.m_dataSet;
        if (builder != null) {
            return builder.getComboDataSet(this.getPage().getBody());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public V getValueSafe() {
        return (V)DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    public Class<? extends INodeContentRenderer<T>> getContentRendererClass() {
        return this.m_contentRendererClass;
    }

    public void setContentRendererClass(Class<? extends INodeContentRenderer<T>> contentRendererClass) {
        this.m_contentRendererClass = contentRendererClass;
    }

    public PropertyMetaModel<?> getPropertyMetaModel() {
        return this.m_propertyMetaModel;
    }

    public void setPropertyMetaModel(PropertyMetaModel<?> propertyMetaModel) {
        this.m_propertyMetaModel = propertyMetaModel;
    }

    public IListMaker<T> getListMaker() {
        return this.m_listMaker;
    }

    public void setListMaker(IListMaker<T> listMaker) {
        this.m_listMaker = listMaker;
    }

    public IValueTransformer<V> getValueTransformer() {
        return this.m_valueTransformer;
    }

    public void setValueTransformer(IValueTransformer<V> valueTransformer) {
        this.m_valueTransformer = valueTransformer;
    }

    public String getEmptyText() {
        return this.m_emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.m_emptyText = emptyText;
    }

    @Nullable
    protected ComboOption<T> getEmptyOption() {
        return this.m_emptyOption;
    }

    @Nonnull
    private ComboOption<T> getOption(int ix) {
        if (ix < 0 || ix >= this.m_popupDiv.getChildCount()) {
            throw new ArrayIndexOutOfBoundsException("The option index " + ix + " is invalid, the #options is " + this.getChildCount());
        }
        return (ComboOption)this.m_popupDiv.getChild(ix);
    }

    protected void setEmptyOption(ComboOption<T> emptyOption) {
        this.m_emptyOption = emptyOption;
    }

    @Nullable
    protected V internalGetCurrentValue() {
        return this.m_currentValue;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.m_mandatory == mandatory) {
            return;
        }
        this.m_mandatory = mandatory;
        this.forceRebuild();
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.m_disabled = disabled;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        IValueChanged<?> vc = this.m_onValueChanged;
        return vc;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }
}

