/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.IModelBinding;
import to.etc.domui.component.controlfactory.ModelBindings;
import to.etc.domui.component.controlfactory.SimpleComponentPropertyBinding;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.BundleRef;

public final class BindingMessenger {
    @Nonnull
    private ModelBindings m_bindings;
    @Nullable
    private BundleRef m_bundleRef;
    @Nullable
    private Object m_object;

    public BindingMessenger(@Nonnull ModelBindings bindings, @Nonnull BundleRef bundleRef) {
        this.m_bindings = bindings;
        this.m_bundleRef = bundleRef;
    }

    public BindingMessenger(@Nonnull Object object, @Nonnull ModelBindings bindings, @Nonnull Class<? extends UrlPage> urlClass) {
        this(object, bindings, MetaManager.findClassMeta(urlClass).getClassBundle());
    }

    public BindingMessenger(@Nonnull Object object, @Nonnull ModelBindings bindings, @Nonnull BundleRef bundleRef) {
        this.m_bindings = bindings;
        this.m_bundleRef = bundleRef;
        this.m_object = object;
    }

    public BindingMessenger(@Nonnull ModelBindings bindings) {
        this.m_bindings = bindings;
    }

    public BindingMessenger(@Nonnull Object object, @Nonnull ModelBindings bindings) {
        this.m_bindings = bindings;
        this.m_object = object;
    }

    public void error(@Nonnull Object object, @Nonnull String property, @Nonnull String message, Object ... param) throws Exception {
        this.error(object, property, UIMessage.error(DomUtil.nullChecked(this.m_bundleRef), message, param));
    }

    @Nonnull
    public Object getObject() {
        if (null != this.m_object) {
            return this.m_object;
        }
        throw new IllegalStateException("This binding does not have an object set.");
    }

    public void error(@Nonnull String property, @Nonnull String message, Object ... param) throws Exception {
        BundleRef bundleRef = DomUtil.nullChecked(this.m_bundleRef);
        this.error(this.getObject(), property, UIMessage.error(bundleRef, message, param));
    }

    public void error(@Nonnull Object object, @Nonnull String property, @Nonnull UIMessage m) throws Exception {
        IControl[] h = new IControl[1];
        this.find(this.m_bindings, h, object, property);
        if (h[0] == null) {
            throw new ProgrammerErrorException(object.getClass().getSimpleName() + "." + property + " not found in bindings");
        }
        h[0].setMessage(m);
    }

    private void find(@Nonnull ModelBindings bindings, @Nonnull IControl<?>[] h, @Nonnull Object object, @Nonnull String property) throws Exception {
        for (IModelBinding mb : bindings) {
            if (mb instanceof SimpleComponentPropertyBinding) {
                SimpleComponentPropertyBinding b = (SimpleComponentPropertyBinding)mb;
                if (!b.getModel().getValue().equals(object) || !b.getPropertyMeta().getName().equals(property)) continue;
                h[0] = b.getControl();
                return;
            }
            if (!(mb instanceof ModelBindings)) continue;
            ModelBindings modelBindings = (ModelBindings)mb;
            this.find(modelBindings, h, object, property);
        }
    }

    public <T> IControl<T> findControl(@Nonnull String property) throws Exception {
        return this.findControl(this.getObject(), property);
    }

    public <T> IControl<T> findControl(@Nonnull Object object, @Nonnull String property) throws Exception {
        IControl[] h = new IControl[1];
        this.find(this.m_bindings, h, object, property);
        if (h[0] == null) {
            throw new ProgrammerErrorException(object.getClass().getSimpleName() + "." + property + " not found in bindings");
        }
        return h[0];
    }
}

