/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.domui.component.controlfactory.IModelBinding;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.util.IReadOnlyModel;

@Immutable
public abstract class ComponentPropertyBinding<T, C>
implements IModelBinding {
    @Nonnull
    final IControl<C> m_control;
    @Nonnull
    private final PropertyMetaModel<T> m_propertyMeta;
    @Nonnull
    private final IReadOnlyModel<?> m_model;

    @Nullable
    protected abstract C convertValueToControl(@Nullable T var1) throws Exception;

    protected abstract T convertControlToValue(@Nullable C var1) throws Exception;

    public ComponentPropertyBinding(@Nonnull IReadOnlyModel<?> model, @Nonnull PropertyMetaModel<T> propertyMeta, @Nonnull IControl<C> control) {
        this.m_model = model;
        this.m_propertyMeta = propertyMeta;
        this.m_control = control;
    }

    @Override
    public void moveControlToModel() throws Exception {
        C val = this.m_control.getValue();
        T nval = this.convertControlToValue(val);
        Object base = this.m_model.getValue();
        this.m_propertyMeta.setValue(base, nval);
    }

    @Override
    public void moveModelToControl() throws Exception {
        Object base = this.m_model.getValue();
        Object pval = this.m_propertyMeta.getValue(base);
        C cval = this.convertValueToControl(pval);
        this.m_control.setValue(cval);
    }

    @Override
    public void setControlsEnabled(boolean on) {
        this.m_control.setReadOnly(!on);
    }

    @Nonnull
    public IControl<C> getControl() {
        return this.m_control;
    }

    @Nonnull
    public PropertyMetaModel<T> getPropertyMeta() {
        return this.m_propertyMeta;
    }

    @Nonnull
    public IReadOnlyModel<?> getModel() {
        return this.m_model;
    }
}

