/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.ComboFixed;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.layout.ErrorMessageDiv;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.LookupControlRegistry;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IControlErrorFragmentFactory;
import to.etc.domui.server.IControlLabelFactory;
import to.etc.domui.util.DefaultControlLabelFactory;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IReadOnlyModel;
import to.etc.webapp.nls.NlsContext;

public class ControlBuilder {
    @Nonnull
    private List<PropertyControlFactory> m_controlFactoryList = new ArrayList<PropertyControlFactory>();
    @Nonnull
    private final LookupControlRegistry m_lookupControlRegistry = new LookupControlRegistry();
    @Nonnull
    private IControlLabelFactory m_controlLabelFactory = new DefaultControlLabelFactory();
    @Nonnull
    private IControlErrorFragmentFactory m_errorFragmentfactory = new IControlErrorFragmentFactory(){

        @Override
        public NodeContainer createErrorFragment() {
            return new ErrorMessageDiv();
        }
    };
    @Nonnull
    private static final IReadOnlyModel<Object> DUMMY_MODEL = new IReadOnlyModel<Object>(){

        @Override
        public Object getValue() throws Exception {
            throw new IllegalStateException("Should not ever call this");
        }
    };

    public ControlBuilder(@Nonnull DomApplication app) {
    }

    public synchronized void registerControlFactory(@Nonnull PropertyControlFactory cf) {
        this.m_controlFactoryList = new ArrayList<PropertyControlFactory>(this.m_controlFactoryList);
        this.m_controlFactoryList.add(cf);
    }

    @Nonnull
    protected synchronized List<PropertyControlFactory> getControlFactoryList() {
        return this.m_controlFactoryList;
    }

    public PropertyControlFactory findControlFactory(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (pmm.getControlFactory() != null) {
            return pmm.getControlFactory();
        }
        PropertyControlFactory best = null;
        int score = 0;
        for (PropertyControlFactory cf : this.getControlFactoryList()) {
            int v = cf.accepts(pmm, editable, controlClass);
            if (v <= score) continue;
            score = v;
            best = cf;
        }
        return best;
    }

    @Nonnull
    public PropertyControlFactory getControlFactory(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        PropertyControlFactory cf = this.findControlFactory(pmm, editable, controlClass);
        if (cf == null) {
            throw new IllegalStateException("Cannot get a control factory for " + pmm);
        }
        return cf;
    }

    @Nonnull
    public synchronized IControlLabelFactory getControlLabelFactory() {
        return this.m_controlLabelFactory;
    }

    public synchronized void setControlLabelFactory(@Nonnull IControlLabelFactory controlLabelFactory) {
        this.m_controlLabelFactory = controlLabelFactory;
    }

    @Nonnull
    public synchronized IControlErrorFragmentFactory getErrorFragmentfactory() {
        return this.m_errorFragmentfactory;
    }

    public synchronized void setErrorFragmentfactory(@Nonnull IControlErrorFragmentFactory errorFragmentfactory) {
        if (errorFragmentfactory == null) {
            throw new IllegalArgumentException("Cannot accept null");
        }
        this.m_errorFragmentfactory = errorFragmentfactory;
    }

    public void addErrorFragment(@Nonnull NodeContainer nc) {
        NodeContainer lsn = this.getErrorFragmentfactory().createErrorFragment();
        nc.add(lsn);
        DomUtil.getMessageFence(nc).addErrorListener((IErrorMessageListener)((Object)lsn));
    }

    public void register(@Nonnull ILookupControlFactory f) {
        this.m_lookupControlRegistry.register(f);
    }

    @Nullable
    public ILookupControlFactory findLookupControlFactory(@Nonnull SearchPropertyMetaModel pmm) {
        return this.m_lookupControlRegistry.findFactory(pmm);
    }

    @Nonnull
    public ILookupControlFactory getLookupControlFactory(@Nonnull SearchPropertyMetaModel pmm) {
        return this.m_lookupControlRegistry.getControlFactory(pmm);
    }

    @Nonnull
    public <T, X extends NodeBase> ILookupControlFactory getLookupQueryFactory(@Nonnull SearchPropertyMetaModel pmm, @Nonnull X control) {
        return this.m_lookupControlRegistry.getLookupQueryFactory(pmm, control);
    }

    @Deprecated
    @Nonnull
    public ControlFactoryResult createControlFor(@Nonnull IReadOnlyModel<?> model, @Nonnull PropertyMetaModel<?> pmm, boolean editable) {
        PropertyControlFactory cf = this.getControlFactory(pmm, editable, null);
        return cf.createControl(pmm, editable, null);
    }

    @Nonnull
    public ControlFactoryResult createControlFor(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        PropertyControlFactory cf = this.getControlFactory(pmm, editable, controlClass);
        return cf.createControl(pmm, editable, controlClass);
    }

    public <T> T createControl(@Nonnull Class<T> controlClass, @Nonnull Class<?> dataClass, @Nonnull String propertyName, boolean editable) {
        PropertyMetaModel<?> pmm = MetaManager.getPropertyMeta(dataClass, propertyName);
        return this.createControl(controlClass, pmm, editable);
    }

    public <T> T createControl(@Nonnull Class<T> controlClass, @Nonnull PropertyMetaModel<?> pmm, boolean editable) {
        if (controlClass == null) {
            throw new IllegalArgumentException("controlClass cannot be null");
        }
        PropertyControlFactory cf = this.getControlFactory(pmm, editable, null);
        ControlFactoryResult r = cf.createControl(pmm, editable, controlClass);
        if (r.getNodeList().length != 1) {
            throw new IllegalStateException("The control factory " + cf + " created != 1 components for a find-control-for-class query");
        }
        NodeBase c = r.getNodeList()[0];
        if (!controlClass.isAssignableFrom(controlClass)) {
            throw new IllegalStateException("The control factory " + cf + " created a " + c + " which is NOT assignment-compatible with the requested class " + controlClass);
        }
        return (T)c;
    }

    public <T> ComboFixed<T> createComboFor(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(type);
        Object[] vals = cmm.getDomainValues();
        if (vals == null || vals.length == 0) {
            throw new IllegalArgumentException("The type " + type + " is not known as a fixed-size domain type");
        }
        ArrayList vl = new ArrayList();
        for (Object o : vals) {
            String label = cmm.getDomainLabel(NlsContext.getLocale(), o);
            if (label == null) {
                label = o == null ? "" : o.toString();
            }
            vl.add(new ValueLabelPair<Object>(o, label));
        }
        ComboFixed c = new ComboFixed(vl);
        return c;
    }

    @Nonnull
    public ComboFixed<?> createComboFor(PropertyMetaModel<?> pmm, boolean editable) {
        String s;
        if (pmm == null) {
            throw new IllegalArgumentException("propertyMeta cannot be null");
        }
        Object[] vals = pmm.getDomainValues();
        if (vals == null || vals.length == 0) {
            throw new IllegalArgumentException("The type of property " + pmm + " (" + pmm.getActualType() + ") is not known as a fixed-size domain type");
        }
        ClassMetaModel ecmm = null;
        ArrayList vl = new ArrayList();
        for (Object o : vals) {
            String label = pmm.getDomainValueLabel(NlsContext.getLocale(), o);
            if (label == null) {
                if (ecmm == null) {
                    ecmm = MetaManager.findClassMeta(pmm.getActualType());
                }
                if ((label = ecmm.getDomainLabel(NlsContext.getLocale(), o)) == null) {
                    label = o == null ? "" : o.toString();
                }
            }
            vl.add(new ValueLabelPair<Object>(o, label));
        }
        ComboFixed c = new ComboFixed(vl);
        if (pmm.isRequired()) {
            c.setMandatory(true);
        }
        if (!editable || pmm.getReadOnly() == YesNoType.YES) {
            c.setDisabled(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            c.setTitle(s);
        }
        return c;
    }

    public ComboFixed<?> createComboFor(Class<?> dataClass, String property, boolean editable) {
        PropertyMetaModel<?> pmm = MetaManager.getPropertyMeta(dataClass, property);
        return this.createComboFor(pmm, editable);
    }
}

