/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.DateInput;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.misc.DisplayValue;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.DateConverter;
import to.etc.domui.converter.DateTimeConverter;
import to.etc.domui.converter.TimeOnlyConverter;

public class ControlFactoryDate
implements PropertyControlFactory {
    @Override
    public int accepts(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(DateInput.class)) {
            return -1;
        }
        Class<?> iclz = pmm.getActualType();
        if (Date.class.isAssignableFrom(iclz)) {
            return 2;
        }
        return 0;
    }

    @Override
    @Nonnull
    public <T> ControlFactoryResult createControl(@Nonnull PropertyMetaModel<T> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (!editable && (controlClass == null || controlClass.isAssignableFrom(Text.class))) {
            Class cc;
            DisplayValue<Class<Date>> txt = new DisplayValue<Class<Date>>(Date.class);
            if (pmm == null) {
                cc = DateTimeConverter.class;
            } else {
                switch (pmm.getTemporal()) {
                    default: {
                        throw new IllegalStateException("Unsupported temporal metadata type: " + (Object)((Object)pmm.getTemporal()));
                    }
                    case UNKNOWN: 
                    case DATETIME: {
                        cc = DateTimeConverter.class;
                        break;
                    }
                    case DATE: {
                        cc = DateConverter.class;
                        break;
                    }
                    case TIME: {
                        cc = TimeOnlyConverter.class;
                    }
                }
            }
            txt.setConverter(ConverterRegistry.getConverterInstance(cc));
            return new ControlFactoryResult(txt);
        }
        DateInput di = DateInput.createDateInput(pmm, editable);
        return new ControlFactoryResult(di);
    }
}

