/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.misc.DisplayValue;
import to.etc.domui.converter.MoneyUtil;

public class ControlFactoryMoney
implements PropertyControlFactory {
    @Override
    public int accepts(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(Text.class)) {
            return -1;
        }
        Class<?> clz = pmm.getActualType();
        if (clz != Double.class && clz != Double.TYPE && clz != BigDecimal.class) {
            return -1;
        }
        if (!NumericPresentation.isMonetary(pmm.getNumericPresentation())) {
            return -1;
        }
        return 2;
    }

    @Override
    @Nonnull
    public <T> ControlFactoryResult createControl(@Nonnull PropertyMetaModel<T> pmm, boolean editable, @Nullable Class<?> controlClass) {
        Text<Number> txt;
        Class<T> iclz = pmm.getActualType();
        if (!editable) {
            DisplayValue<Class<T>> dv = new DisplayValue<Class<T>>(iclz);
            dv.addCssClass("ui-numeric");
            MoneyUtil.assignMonetaryConverter(pmm, editable, dv);
            String s = pmm.getDefaultHint();
            if (s != null) {
                dv.setTitle(s);
            }
            return new ControlFactoryResult(dv);
        }
        if (pmm.getActualType() == Double.class || pmm.getActualType() == Double.TYPE) {
            txt = Text.createDoubleMoneyInput(pmm, editable);
        } else if (pmm.getActualType() == BigDecimal.class) {
            txt = Text.createBDMoneyInput(pmm, editable);
        } else {
            throw new IllegalStateException("Cannot handle type=" + pmm.getActualType() + " in monetary control factory");
        }
        return new ControlFactoryResult(txt);
    }
}

